/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.index.ft.FTBuilder;
import org.basex.index.ft.FTFuzzy;
import org.basex.index.ft.FTFuzzyList;
import org.basex.index.ft.FTIndex;
import org.basex.index.ft.FTIndexTree;
import org.basex.index.ft.FTIndexTrees;
import org.basex.index.ft.FTList;
import org.basex.io.out.DataOutput;
import org.basex.util.Token;
import org.basex.util.list.IntList;

final class FTFuzzyBuilder
extends FTBuilder {
    private final FTIndexTrees tree = new FTIndexTrees();

    protected FTFuzzyBuilder(Data d) throws IOException {
        super(d);
    }

    @Override
    public FTIndex build() throws IOException {
        this.index();
        return new FTFuzzy(this.data);
    }

    @Override
    void index(byte[] tok) {
        this.tree.index(tok, this.pre, this.pos, this.csize);
    }

    @Override
    int nrTokens() {
        int l = 0;
        FTIndexTree[] fTIndexTreeArray = this.tree.trees;
        int n = this.tree.trees.length;
        int n2 = 0;
        while (n2 < n) {
            FTIndexTree t = fTIndexTreeArray[n2];
            if (t != null) {
                l += t.size();
            }
            ++n2;
        }
        return l;
    }

    @Override
    void calcFreq() {
        this.tree.init();
        while (this.tree.more(0)) {
            FTIndexTree t = this.tree.nextTree();
            t.next();
            this.calcFreq(t.nextPres());
        }
    }

    @Override
    public void write() throws IOException {
        this.writeIndex(this.csize++);
        if (!this.merge) {
            return;
        }
        DataOutput outX = new DataOutput(this.data.meta.dbfile("ftxx"));
        DataOutput outY = new DataOutput(this.data.meta.dbfile("ftxy"));
        DataOutput outZ = new DataOutput(this.data.meta.dbfile("ftxz"));
        IntList ind = new IntList();
        FTList[] v = new FTList[this.csize];
        int b = 0;
        while (b < this.csize) {
            v[b] = new FTFuzzyList(this.data, b);
            ++b;
        }
        IntList il = new IntList();
        while (this.check(v)) {
            int min = 0;
            il.reset();
            il.add(min);
            int i = 0;
            while (i < this.csize) {
                if (min != i && v[i].tok.length != 0) {
                    int l = v[i].tok.length - v[min].tok.length;
                    int d = Token.diff(v[min].tok, v[i].tok);
                    if (l < 0 || l == 0 && d > 0 || v[min].tok.length == 0) {
                        min = i;
                        il.reset();
                        il.add(min);
                    } else if (d == 0 && v[i].tok.length > 0) {
                        il.add(i);
                    }
                }
                ++i;
            }
            if (ind.size() == 0 || ind.get(ind.size() - 2) < v[min].tok.length) {
                ind.add(v[min].tok.length);
                ind.add((int)outY.size());
            }
            outY.writeBytes(v[min].tok);
            outY.write5(outZ.size());
            outY.write4(this.merge(outZ, il, v));
        }
        this.writeInd(outX, ind, ind.get(ind.size() - 2) + 1, (int)outY.size());
        outX.close();
        outY.close();
        outZ.close();
    }

    private void writeInd(DataOutput outX, IntList il, int ls, int lp) throws IOException {
        int is = il.size();
        outX.write1(is >> 1);
        int i = 0;
        while (i < is) {
            outX.write1(il.get(i));
            outX.write4(il.get(i + 1));
            i += 2;
        }
        outX.write1(ls);
        outX.write4(lp);
    }

    @Override
    protected void writeIndex(int cs) throws IOException {
        String s = "ftx" + (this.merge ? Integer.valueOf(cs) : "");
        DataOutput outX = new DataOutput(this.data.meta.dbfile(String.valueOf(s) + 'x'));
        DataOutput outY = new DataOutput(this.data.meta.dbfile(String.valueOf(s) + 'y'));
        DataOutput outZ = new DataOutput(this.data.meta.dbfile(String.valueOf(s) + 'z'));
        IntList ind = new IntList();
        long dr = 0L;
        int tr = 0;
        int j = 0;
        this.tree.init();
        while (this.tree.more(cs)) {
            FTIndexTree t = this.tree.nextTree();
            t.next();
            byte[] key = t.nextTok();
            if (j < key.length) {
                j = key.length;
                ind.add(j);
                ind.add(tr);
            }
            int i = 0;
            while (i < j) {
                outY.write1(key[i]);
                ++i;
            }
            outY.write5(dr);
            outY.write4(t.nextNumPre());
            this.writeFTData(outZ, t.nextPres(), t.nextPoss());
            dr = outZ.size();
            tr = (int)outY.size();
        }
        this.writeInd(outX, ind, ++j, tr);
        outX.close();
        outY.close();
        outZ.close();
        this.tree.initFT();
    }
}

