/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import java.awt.Graphics;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.tree.TreeConstants;
import org.basex.gui.view.tree.TreeRect;
import org.basex.gui.view.tree.TreeSubtree;

final class TreeRects
implements TreeConstants {
    private TreeRect[][][] rects;

    TreeRects() {
    }

    double generateRects(TreeSubtree sub, Graphics g, Context c, int ds, int dw, boolean slim) {
        int[] roots = c.current.list;
        int rl = roots.length;
        if (rl == 0) {
            return 0.0;
        }
        double w = (double)(dw - 2 - ds) / (double)rl;
        if (w < 2.0) {
            return -1.0;
        }
        this.rects = new TreeRect[rl][][];
        int i = 0;
        while (i < rl) {
            this.generateRects(sub, c, g, i, ds, w, slim);
            ++i;
        }
        return w;
    }

    private int generateRects(TreeSubtree sub, Context c, Graphics g, int rn, int ds, double dw, boolean slim) {
        int h = sub.getSubtreeHeight(rn);
        this.rects[rn] = new TreeRect[h][];
        double w = -1.0;
        int lv = 0;
        while (lv < h) {
            w = dw / (double)sub.levelSize(rn, lv);
            if (w < 2.0) {
                this.bigRectangle(rn, lv, ds, dw);
            } else {
                this.normalRectangle(sub, c, g, rn, lv, ds, w, slim);
            }
            ++lv;
        }
        return (int)w;
    }

    private void bigRectangle(int rn, int lv, int ds, double w) {
        this.rects[rn][lv] = new TreeRect[1];
        this.rects[rn][lv][0] = new TreeRect((int)(w * (double)rn) + 2 + ds, (int)w - 2);
    }

    private void normalRectangle(TreeSubtree sub, Context c, Graphics g, int rn, int lv, int ds, double w, boolean slim) {
        int subSi = sub.levelSize(rn, lv);
        this.rects[rn][lv] = new TreeRect[subSi];
        double xx = (double)rn * w * (double)subSi + (double)ds;
        double ww = w;
        int i = 0;
        while (i < subSi) {
            if (slim) {
                double boxMiddle = xx + ww / 2.0;
                byte[] b = this.getText(c, rn, sub.getPrePerIndex(rn, lv, i));
                int o = this.calcOptimalRectWidth(g, b) + 10;
                if (o < 4) {
                    o = 4;
                }
                if (w > (double)o) {
                    xx = boxMiddle - (double)o / 2.0;
                    ww = o;
                }
            }
            this.rects[rn][lv][i] = new TreeRect((int)xx + 2, (int)ww - 2);
            xx += w;
            ++i;
        }
    }

    TreeRect[] getTreeRectsPerLevel(int rn, int lv) {
        return this.rects[rn][lv];
    }

    TreeRect getTreeRectPerIndex(int rn, int lv, int ix) {
        return this.rects[rn][lv][ix];
    }

    byte[] getText(Context c, int rn, int pre) {
        Data d = c.data;
        if (pre == c.current.list[rn]) {
            return ViewData.path(d, pre);
        }
        return ViewData.content(d, pre, false);
    }

    private int calcOptimalRectWidth(Graphics g, byte[] b) {
        return BaseXLayout.width(g, b);
    }

    boolean bigRect(TreeSubtree sub, int rn, int lv) {
        return sub.levelSize(rn, lv) != this.rects[rn][lv].length;
    }

    int getPrePerXPos(TreeSubtree sub, int rn, int lv, int x) {
        TreeRect r = this.getTreeRectsPerLevel(rn, lv)[0];
        double ratio = (double)(x - r.x) / (double)r.w;
        int idx = (int)(ratio * (double)sub.levelSize(rn, lv));
        return sub.getPrePerIndex(rn, lv, idx);
    }

    TreeRect searchRect(TreeSubtree sub, int rn, int lv, int pre) {
        int i = sub.searchPreArrayPos(rn, lv, pre);
        return i < 0 ? null : (this.bigRect(sub, rn, lv) ? this.rects[rn][lv][0] : this.rects[rn][lv][i]);
    }
}

