/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.gui.view.map.MapAlgo;
import org.basex.gui.view.map.MapList;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;

final class BinaryAlgo
extends MapAlgo {
    BinaryAlgo() {
    }

    @Override
    MapRects calcMap(MapRect r, MapList ml, int ns, int ne) {
        return this.calcMap(r, ml, ns, ne, 1.0);
    }

    private MapRects calcMap(MapRect r, MapList ml, int ns, int ne, double sumweight) {
        int hh;
        if (ne - ns == 0) {
            MapRects rects = new MapRects();
            rects.add(new MapRect(r, ml.get(ns)));
            return rects;
        }
        MapRects rects = new MapRects();
        double weight = 0.0;
        int ni = ns + (ne - ns) / 2;
        int i = ns;
        while (i <= ni) {
            weight += ml.weight[i];
            ++i;
        }
        int xx = r.x;
        int yy = r.y;
        int ww = r.w <= r.h ? r.w : (int)((double)(r.w * 1) / sumweight * weight);
        int n = hh = r.w > r.h ? r.h : (int)((double)(r.h * 1) / sumweight * weight);
        if (ww > 0 && hh > 0 && weight > 0.0) {
            rects.add(this.calcMap(new MapRect(xx, yy, ww, hh, 0, r.level), ml, ns, ni, weight));
        }
        if (r.w > r.h) {
            xx += ww;
            ww = r.w - ww;
        } else {
            yy += hh;
            hh = r.h - hh;
        }
        if (ww > 0 && hh > 0 && sumweight - weight > 0.0 && ni + 1 <= ne) {
            rects.add(this.calcMap(new MapRect(xx, yy, ww, hh, 0, r.level), ml, ni + 1, ne, sumweight - weight));
        }
        return rects;
    }
}

