/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.info;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.MouseEvent;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.XQuery;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class InfoView
extends View {
    private final TokenBuilder text = new TokenBuilder();
    private final BaseXLabel header;
    private final BaseXLabel timer;
    private final BaseXBack north;
    private final BaseXEditor area;
    private IntList stat = new IntList();
    private StringList strings;
    private int focus = -1;
    private int w;
    private int h;
    private int bw;
    private int bs;

    public InfoView(ViewNotifier man) {
        super("info", Text.HELPINFOO, man);
        this.border(6, 6, 6, 6).layout(new BorderLayout());
        this.north = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        this.header = new BaseXLabel(Text.INFOTIT);
        this.north.add((Component)this.header, "North");
        this.north.add((Component)this.header, "North");
        this.timer = new BaseXLabel(" ", true, false);
        this.north.add((Component)this.timer, "South");
        this.add((Component)this.north, (Object)"North");
        this.area = new BaseXEditor(false, (Window)this.gui);
        this.add((Component)this.area, (Object)"Center");
        this.refreshLayout();
    }

    @Override
    public void refreshInit() {
    }

    @Override
    public void refreshFocus() {
    }

    @Override
    public void refreshMark() {
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
    }

    @Override
    public void refreshUpdate() {
    }

    @Override
    public void refreshLayout() {
        this.header.setFont(GUIConstants.lfont);
        this.timer.setFont(GUIConstants.font);
        this.area.setFont(GUIConstants.font);
    }

    @Override
    public boolean visible() {
        return this.gui.gprop.is(GUIProp.SHOWINFO);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gprop.set(GUIProp.SHOWINFO, v);
    }

    @Override
    protected boolean db() {
        return false;
    }

    public void setInfo(String info, Command cmd, String time, boolean ok) {
        StringList eval = new StringList();
        StringList comp = new StringList();
        StringList plan = new StringList();
        StringList sl = new StringList();
        StringList stats = new StringList();
        IntList il = new IntList();
        String err = "";
        String qu = "";
        String res = "";
        String[] split = info.split(Text.NL);
        int i = 0;
        while (i < split.length) {
            String line = split[i];
            int s = line.indexOf(58);
            if (line.startsWith(Text.QUERYPARSE) || line.startsWith(Text.QUERYCOMPILE) || line.startsWith(Text.QUERYEVALUATE) || line.startsWith(Text.QUERYPRINT) || line.startsWith(Text.QUERYTOTAL)) {
                int t = line.indexOf(" ms");
                sl.add(line.substring(0, s).trim());
                il.add((int)(Double.parseDouble(line.substring(s + 1, t)) * 100.0));
            } else if (line.startsWith(Text.QUERYSTRING)) {
                qu = line.substring(s + 1).trim();
            } else if (line.startsWith(Text.QUERYPLAN)) {
                while (++i < split.length && !split[i].isEmpty()) {
                    plan.add(split[i]);
                }
                --i;
            } else if (line.startsWith(Text.QUERYCOMP)) {
                while (++i < split.length && !split[i].isEmpty()) {
                    comp.add(split[i]);
                }
            } else if (line.startsWith(Text.QUERYRESULT)) {
                res = line.substring(s + 1).trim();
            } else if (line.startsWith(Text.QUERYEVAL)) {
                while (split[++i].startsWith("- ")) {
                    eval.add(split[i]);
                }
                --i;
            } else if (!ok) {
                err = String.valueOf(err) + line + Text.NL;
            } else if (line.startsWith(Text.QUERYHITS) || line.startsWith(Text.QUERYUPDATED) || line.startsWith(Text.QUERYPRINTED)) {
                stats.add("- " + line);
            }
            ++i;
        }
        this.stat = il;
        this.strings = sl;
        String total = time;
        boolean q = cmd instanceof XQuery;
        if (!ok || !q) {
            this.text.bold();
            if (q) {
                this.add(Text.QUERYQU, cmd.toString().replaceAll("^.*? ", "").trim());
            } else if (cmd != null) {
                this.text.bold().add(String.valueOf(Text.BUTTONCMD) + ": ").norm().addExt(cmd, new Object[0]).nline();
            }
            if (ok) {
                this.text.add(info).nline();
            } else {
                this.add(Text.QUERYCOMP, comp);
                this.add(Text.QUERYPLAN, plan);
                this.add(Text.INFOERROR, err.replaceAll(String.valueOf(Text.STOPPED) + ".*\\r?\\n", ""));
            }
        } else if (sl.size() != 0) {
            this.text.reset();
            this.add(Text.QUERYEVAL, eval);
            this.add(Text.QUERYQU, qu);
            this.add(Text.QUERYCOMP, comp);
            if (comp.size() != 0) {
                this.add(Text.QUERYRESULT, res);
            }
            this.add(Text.QUERYTIME, sl);
            this.add(Text.QUERYRESULT, stats);
            this.add(Text.QUERYPLAN, plan);
            int runs = Math.max(1, this.gui.context.prop.num(Prop.RUNS));
            total = Performance.getTimer((long)il.get(il.size() - 1) * 10000L * (long)runs, runs);
        }
        this.area.setText(this.text.finish());
        if (total != null) {
            this.timer.setText(String.valueOf(Text.QUERYTOTAL) + total);
        }
        this.repaint();
    }

    public void reset() {
        this.text.reset();
    }

    private void add(String head, StringList list) {
        int runs = Math.max(1, this.gui.context.prop.num(Prop.RUNS));
        if (list.size() == 0) {
            return;
        }
        this.text.bold().add(head).norm().nline();
        int is = list.size();
        int i = 0;
        while (i < is) {
            String line = list.get(i);
            if (list == this.strings) {
                line = " - " + line + ":  " + Performance.getTimer((long)this.stat.get(i) * 10000L * (long)runs, runs);
            }
            this.text.add(line).nline();
            ++i;
        }
        this.text.hline();
    }

    private void add(String head, String txt) {
        if (txt.isEmpty()) {
            return;
        }
        this.text.bold().add(head).norm().add(txt).nline().hline();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        this.focus = -1;
        if (e.getY() < this.h) {
            int i = 0;
            while (i < l) {
                int bx = this.w - this.bw + this.bs * i;
                if (e.getX() >= bx && e.getX() < bx + this.bs) {
                    this.focus = i;
                }
                ++i;
            }
        }
        int runs = Math.max(1, this.gui.context.prop.num(Prop.RUNS));
        int f = this.focus == -1 ? l - 1 : this.focus;
        this.timer.setText(String.valueOf(this.strings.get(f)) + ": " + Performance.getTimer((long)this.stat.get(f) * 10000L * (long)runs, runs));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int bx;
        super.paintComponent(g);
        int l = this.stat.size();
        if (l == 0) {
            return;
        }
        this.h = this.north.getHeight();
        this.w = this.getWidth() - 8;
        this.bw = this.gui.gprop.num(GUIProp.FONTSIZE) * 2 + this.w / 10;
        this.bs = this.bw / (l - 1);
        int m = 0;
        int i = 0;
        while (i < l - 1) {
            m = Math.max(m, this.stat.get(i));
            ++i;
        }
        int by = 10;
        int bh = this.h - 10;
        int i2 = 0;
        while (i2 < l - 1) {
            if (i2 == this.focus) {
                bx = this.w - this.bw + this.bs * i2;
                g.setColor(GUIConstants.color4);
                g.fillRect(bx, 10, this.bs + 1, bh);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < l - 1) {
            bx = this.w - this.bw + this.bs * i2;
            g.setColor(GUIConstants.color((i2 == this.focus ? 3 : 2) + i2 * 2));
            int p = Math.max(1, this.stat.get(i2) * bh / m);
            g.fillRect(bx, 10 + bh - p, this.bs, p);
            g.setColor(GUIConstants.color(8));
            g.drawRect(bx, 10 + bh - p, this.bs, p - 1);
            ++i2;
        }
    }
}

