/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;
import org.basex.core.Prop;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IOFile;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

public final class BaseXList
extends BaseXBack {
    private final JScrollPane scroll;
    final boolean single;
    final BaseXTextField text;
    final JList list;
    String[] values;
    boolean num = true;

    public BaseXList(String[] choice, Dialog d) {
        this(choice, d, true);
    }

    public BaseXList(String[] choice, final Dialog d, boolean s) {
        this.values = (String[])choice.clone();
        this.single = s;
        String[] stringArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            this.num = this.num && v.matches("[0-9]+");
            ++n2;
        }
        this.layout(new TableLayout(2, 1));
        this.text = new BaseXTextField(d);
        this.text.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                BaseXList.this.text.selectAll();
            }
        });
        this.text.addKeyListener(new KeyAdapter(){
            boolean typed;

            @Override
            public void keyPressed(KeyEvent e) {
                int page = BaseXList.this.getHeight() / BaseXList.this.getFont().getSize();
                int[] inds = BaseXList.this.list.getSelectedIndices();
                int op1 = inds.length == 0 ? -1 : inds[0];
                int op2 = inds.length == 0 ? -1 : inds[inds.length - 1];
                int np1 = op1;
                int np2 = op2;
                if (BaseXKeys.NEXTLINE.is(e)) {
                    np2 = Math.min(op2 + 1, BaseXList.this.values.length - 1);
                } else if (BaseXKeys.PREVLINE.is(e)) {
                    np1 = Math.max(op1 - 1, 0);
                } else if (BaseXKeys.NEXTPAGE.is(e)) {
                    np2 = Math.min(op2 + page, BaseXList.this.values.length - 1);
                } else if (BaseXKeys.PREVPAGE.is(e)) {
                    np1 = Math.max(op1 - page, 0);
                } else if (BaseXKeys.TEXTSTART.is(e)) {
                    np1 = 0;
                } else if (BaseXKeys.TEXTEND.is(e)) {
                    np2 = BaseXList.this.values.length - 1;
                } else {
                    return;
                }
                IntList il = new IntList();
                int n = np1;
                while (n <= np2) {
                    il.add(n);
                    ++n;
                }
                int nv = op2 != np2 ? np2 : np1;
                String val = BaseXList.this.values[nv];
                BaseXList.this.list.setSelectedValue(val, true);
                if (e.isShiftDown() && !BaseXList.this.single) {
                    BaseXList.this.list.setSelectedIndices(il.toArray());
                    BaseXList.this.text.setText("");
                } else {
                    BaseXList.this.list.setSelectedIndex(nv);
                    BaseXList.this.text.setText(val);
                    BaseXList.this.text.selectAll();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char ch = e.getKeyChar();
                if (BaseXList.this.num) {
                    boolean bl = this.typed = ch >= '0' && ch <= '9';
                    if (!this.typed) {
                        e.consume();
                    }
                } else {
                    this.typed = ch >= ' ' && ch != '\u007f';
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (this.typed) {
                    this.typed = false;
                    String txt = BaseXList.this.text.getText().trim().toLowerCase();
                    boolean glob = txt.matches("^.*[*?,].*$");
                    String regex = glob ? IOFile.regex(txt, false) : null;
                    IntList il = new IntList();
                    int i = 0;
                    while (i < BaseXList.this.values.length) {
                        String db;
                        String string = db = Prop.WIN ? BaseXList.this.values[i].toLowerCase() : BaseXList.this.values[i];
                        if (glob) {
                            if (db.matches(regex)) {
                                il.add(i);
                            }
                        } else if (db.startsWith(txt)) {
                            int c = BaseXList.this.text.getCaretPosition();
                            BaseXList.this.list.setSelectedValue(BaseXList.this.values[i], true);
                            BaseXList.this.text.setText(BaseXList.this.values[i]);
                            BaseXList.this.text.select(c, BaseXList.this.values[i].length());
                            break;
                        }
                        ++i;
                    }
                    if (glob) {
                        BaseXList.this.list.setSelectedValue(BaseXList.this.values[il.get(0)], true);
                        BaseXList.this.list.setSelectedIndices(il.toArray());
                    }
                }
                d.action(null);
            }
        });
        this.add(this.text);
        MouseInputAdapter mouse = new MouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseXLayout.focus(BaseXList.this.text, null);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Object[] i = BaseXList.this.list.getSelectedValues();
                if (i.length == 0) {
                    return;
                }
                BaseXList.this.text.setText(i.length == 1 ? i[0].toString() : "");
                BaseXList.this.text.requestFocusInWindow();
                BaseXList.this.text.selectAll();
                d.action(null);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    d.close();
                    return;
                }
            }
        };
        this.list = new JList<String>(choice);
        this.list.setFocusable(false);
        if (s) {
            this.list.setSelectionMode(0);
        }
        this.list.addMouseListener(mouse);
        this.list.addMouseMotionListener(mouse);
        this.text.setFont(this.list.getFont());
        BaseXLayout.addInteraction(this.list, d);
        this.scroll = new JScrollPane(this.list, 20, 31);
        this.add(this.scroll);
        this.setIndex(0);
    }

    public void setValue(String value) {
        this.list.setSelectedValue(value, true);
        this.text.setText(value);
    }

    public void setFont(String font, int style) {
        Font f = this.text.getFont();
        this.text.setFont(new Font(font, style, f.getSize()));
    }

    public String[] getList() {
        return this.values;
    }

    public String getValue() {
        return this.text.getText();
    }

    public StringList getValues() {
        StringList sl = new StringList();
        Object[] objectArray = this.list.getSelectedValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            sl.add(o.toString());
            ++n2;
        }
        return sl;
    }

    public int getNum() {
        int i = Token.toInt(this.text.getText());
        if (i != Integer.MIN_VALUE) {
            return i;
        }
        Object value = this.list.getSelectedValue();
        return value != null ? Token.toInt(value.toString()) : 0;
    }

    public int getIndex() {
        return this.list.getSelectedIndex();
    }

    public void setIndex(int i) {
        if (i < this.values.length) {
            this.setValue(this.values[i]);
        } else {
            this.text.setText("");
        }
    }

    @Override
    public void setSize(int w, int h) {
        BaseXLayout.setWidth(this.text, w);
        BaseXLayout.setSize(this.scroll, w, h);
    }

    public void setData(String[] data) {
        this.values = (String[])data.clone();
        this.list.setListData(data);
        this.setIndex(0);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.text.requestFocusInWindow();
    }
}

