/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogParsing;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.io.IO;
import org.basex.io.IOFile;

public abstract class DialogImport
extends Dialog {
    protected BaseXLabel info;
    protected BaseXBack buttons;
    protected DialogParsing parsing;
    protected BaseXTextField path;
    private BaseXCheckBox archives;
    private BaseXCheckBox skip;
    private BaseXTextField filter;

    public DialogImport(GUI main, String title) {
        super(main, title);
    }

    protected void init(BaseXBack p) {
        p.add(new BaseXLabel(String.valueOf(Text.CREATETITLE) + ":", true, true).border(0, 0, 4, 0));
        p.add(new BaseXLabel());
        this.path = new BaseXTextField(this.gui.gprop.get(GUIProp.CREATEPATH), this);
        this.path.addKeyListener(this.keys);
        p.add(this.path);
        BaseXButton browse = new BaseXButton(Text.BUTTONBROWSE, this);
        browse.setMnemonic();
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogImport.this.choose();
            }
        });
        p.add(browse);
        Prop prop = this.gui.context.prop;
        this.skip = new BaseXCheckBox(Text.CREATECORRUPT, prop.is(Prop.SKIPCORRUPT), this);
        p.add(this.skip);
        p.add(new BaseXLabel());
        this.archives = new BaseXCheckBox(Text.CREATEARCHIVES, prop.is(Prop.ADDARCHIVES), this);
        p.add(this.archives);
        p.add(new BaseXLabel());
        p.add(new BaseXLabel(String.valueOf(Text.CREATEPATTERN) + ":", true, true).border(8, 0, 4, 0));
        p.add(new BaseXLabel());
        this.filter = new BaseXTextField(prop.get(Prop.CREATEFILTER), this);
        p.add(this.filter);
        p.add(new BaseXLabel());
        this.parsing = new DialogParsing(this);
        this.buttons = DialogImport.okCancel(this);
        this.set(this.buttons, "South");
    }

    protected IOFile choose() {
        IOFile input = this.inputFile();
        if (input != null) {
            this.path.setText(input.path());
        }
        return input;
    }

    protected IOFile inputFile() {
        BaseXFileChooser fc = new BaseXFileChooser(Text.CREATETITLE, this.gui.gprop.get(GUIProp.CREATEPATH), this.gui);
        fc.addFilter("XML Documents", ".xml");
        fc.addFilter("HTML Documents", IO.HTMLSUFFIXES);
        fc.addFilter("Comma-Separated Values", ".csv");
        fc.addFilter("Plain text", ".txt");
        fc.addFilter("GZIP Archives", ".gz");
        fc.addFilter("ZIP Archives", IO.ZIPSUFFIXES);
        IOFile file = fc.select(BaseXFileChooser.Mode.FDOPEN);
        if (file != null) {
            this.gui.gprop.set(GUIProp.CREATEPATH, file.path());
        }
        return file;
    }

    protected boolean action(Object cmp, boolean empty) {
        this.ok = true;
        this.parsing.action(cmp);
        String in = this.path.getText().trim();
        IO io = IO.get(in);
        this.gui.gprop.set(GUIProp.CREATEPATH, in);
        boolean valid = empty ? io.exists() || in.isEmpty() : !in.isEmpty() && io.exists();
        String inf = valid ? "" : Text.PATHWHICH;
        this.info.setText(null, null);
        if (!inf.isEmpty()) {
            this.ok = false;
            this.info.setText(inf, GUIConstants.Msg.ERROR);
        }
        this.filter.setEnabled(valid && io.isDir());
        DialogImport.enableOK(this.buttons, Text.BUTTONOK, this.ok);
        return this.ok;
    }

    @Override
    public void close() {
        if (!this.ok) {
            return;
        }
        super.close();
        this.gui.set(Prop.CREATEFILTER, this.filter.getText());
        this.gui.set(Prop.ADDARCHIVES, this.archives.isSelected());
        this.gui.set(Prop.SKIPCORRUPT, this.skip.isSelected());
        this.parsing.close();
    }
}

