/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogMessage;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.TableLayout;

public abstract class Dialog
extends JDialog {
    public final GUI gui;
    protected final BaseXBack panel;
    protected boolean ok;
    private int[] loc;
    protected final KeyAdapter keys = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            if (!BaseXKeys.modifier(e)) {
                Dialog.this.action(BaseXKeys.ENTER.is(e) ? e.getSource() : null);
            }
        }
    };

    protected Dialog(GUI main, String title) {
        this(main, title, true);
    }

    protected Dialog(GUI main, String title, boolean modal) {
        super(main, title, modal);
        this.gui = main;
        this.panel = new BaseXBack(new BorderLayout()).border(10, 10, 10, 10);
        this.add((Component)this.panel, "Center");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Dialog.this.cancel();
            }
        });
    }

    protected final void set(Component comp, String pos) {
        this.panel.add(comp, pos);
    }

    protected final void finish(int[] l) {
        this.pack();
        if (l == null) {
            this.setLocationRelativeTo(this.gui);
        } else {
            this.setLocation(this.gui.getX() + l[0], this.gui.getY() + l[1]);
        }
        this.loc = l;
        this.setVisible(true);
    }

    @Override
    public void setLocation(int x, int y) {
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        int xx = Math.max(0, Math.min(scr.width - this.getWidth(), x));
        int yy = Math.max(0, Math.min(scr.height - this.getHeight(), y));
        super.setLocation(xx, yy);
    }

    public void action(Object comp) {
    }

    public void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void close() {
        this.ok = true;
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.loc != null) {
            Container par = this.getParent();
            this.loc[0] = this.getX() - par.getX();
            this.loc[1] = this.getY() - par.getY();
            this.gui.gprop.write();
        }
        super.dispose();
    }

    public final boolean ok() {
        return this.ok;
    }

    protected static BaseXBack okCancel(Dialog dialog) {
        return Dialog.newButtons(dialog, Text.BUTTONOK, Text.BUTTONCANCEL);
    }

    protected static BaseXBack newButtons(Dialog dialog, Object ... buttons) {
        BaseXBack panel = new BaseXBack(GUIConstants.Fill.NONE).border(12, 0, 0, 0).layout(new TableLayout(1, buttons.length, 8, 0));
        StringBuilder mnem = new StringBuilder();
        Object[] objectArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            BaseXButton b = null;
            b = obj instanceof BaseXButton ? (BaseXButton)obj : new BaseXButton(obj.toString(), dialog);
            BaseXButton.setMnemonics(mnem, b);
            panel.add(b);
            ++n2;
        }
        BaseXBack but = new BaseXBack(GUIConstants.Fill.NONE).layout(new BorderLayout());
        but.add((Component)panel, "East");
        return but;
    }

    protected static void enableOK(JComponent panel, String label, boolean enabled) {
        Component[] componentArray = panel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JComponent) {
                if (c instanceof BaseXButton) {
                    BaseXButton b = (BaseXButton)c;
                    if (b.getText().equals(label)) {
                        b.setEnabled(enabled);
                    }
                } else {
                    Dialog.enableOK((JComponent)c, label, enabled);
                }
            }
            ++n2;
        }
    }

    public static Boolean yesNoCancel(GUI gui, String text) {
        DialogMessage msg = new DialogMessage(gui, text.trim(), GUIConstants.Msg.YESNOCANCEL);
        return msg.canceled() ? null : Boolean.valueOf(msg.ok());
    }

    public static boolean confirm(GUI gui, String text) {
        return new DialogMessage(gui, text.trim(), GUIConstants.Msg.QUESTION).ok();
    }

    public static void info(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.SUCCESS);
    }

    public static void warn(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.WARN);
    }

    public static void error(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.ERROR);
    }
}

