/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.FTPosData;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public final class Nodes
implements Result {
    public final FTPosData ftpos;
    public boolean root;
    public Data data;
    public int[] list;
    public int[] sorted;

    public Nodes(Data d) {
        this(new int[0], d);
    }

    public Nodes(int n, Data d) {
        this(new int[]{n}, d);
    }

    public Nodes(int[] n, Data d) {
        this(n, d, Prop.gui ? new FTPosData() : null);
    }

    public Nodes(int[] n, Data d, FTPosData ft) {
        this.data = d;
        this.ftpos = ft;
        this.set(n);
        if (d == null) {
            Util.notexpected("No data available");
        }
    }

    public Nodes(int[] n) {
        this.list = n;
        this.ftpos = null;
    }

    @Override
    public long size() {
        return this.list.length;
    }

    @Override
    public boolean sameAs(Result v) {
        int s = this.list.length;
        if (!(v instanceof Nodes) || v.size() != (long)s) {
            return false;
        }
        Nodes n = (Nodes)v;
        if (this.data != n.data) {
            return false;
        }
        int c = 0;
        while (c < s) {
            if (n.list[c] != this.list[c]) {
                return false;
            }
            ++c;
        }
        return this.ftpos == null || this.ftpos.sameAs(n.ftpos);
    }

    public Nodes checkRoot() {
        IntList docs = this.data.doc();
        if (this.list.length != docs.size()) {
            this.root = false;
        } else {
            int c = -1;
            while (++c < this.list.length && this.list[c] == docs.get(c)) {
            }
            this.root = c == this.list.length;
        }
        return this;
    }

    public boolean contains(int p) {
        return this.find(p) >= 0;
    }

    public int find(int p) {
        this.sort();
        return Arrays.binarySearch(this.sorted, p);
    }

    public void toggle(int p) {
        int[] n = new int[]{p};
        this.set(this.contains(p) ? Nodes.except(this.list, n) : Nodes.union(this.list, n));
    }

    public void union(int[] p) {
        this.set(Nodes.union(this.list, p));
    }

    private static int[] union(int[] ai, int[] bi) {
        int al = ai.length;
        int bl = bi.length;
        IntList c = new IntList();
        int a = 0;
        int b = 0;
        while (a != al && b != bl) {
            int d = ai[a] - bi[b];
            c.add(d <= 0 ? ai[a++] : bi[b++]);
            if (d != 0) continue;
            ++b;
        }
        while (a != al) {
            c.add(ai[a++]);
        }
        while (b != bl) {
            c.add(bi[b++]);
        }
        return c.toArray();
    }

    private static int[] except(int[] ai, int[] bi) {
        int al = ai.length;
        int bl = bi.length;
        IntList c = new IntList();
        int a = 0;
        int b = 0;
        while (a != al && b != bl) {
            int d = ai[a] - bi[b];
            if (d < 0) {
                c.add(ai[a]);
            } else {
                ++b;
            }
            if (d > 0) continue;
            ++a;
        }
        while (a != al) {
            c.add(ai[a++]);
        }
        return c.toArray();
    }

    private void set(int[] n) {
        this.list = n;
        this.sorted = null;
    }

    private void sort() {
        if (this.sorted != null) {
            return;
        }
        int i = Integer.MIN_VALUE;
        int[] nArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (i > n3) {
                this.sorted = Arrays.copyOf(this.list, this.list.length);
                Arrays.sort(this.sorted);
                return;
            }
            i = n3;
            ++n2;
        }
        this.sorted = this.list;
    }

    @Override
    public void serialize(Serializer ser) throws IOException {
        int c = 0;
        while (c < this.list.length && !ser.finished()) {
            this.serialize(ser, c);
            ++c;
        }
    }

    @Override
    public void serialize(Serializer ser, int n) throws IOException {
        ser.openResult();
        ser.node(this.data, this.list[n], this.ftpos);
        ser.closeResult();
    }

    public String toString() {
        ArrayOutput ao = new ArrayOutput();
        try {
            this.serialize(new XMLSerializer(ao));
        }
        catch (IOException ex) {
            Util.notexpected(ex);
        }
        return ao.toString();
    }
}

