/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.data.MetaData;
import org.basex.util.Performance;
import org.basex.util.TokenBuilder;

public final class InfoDB
extends AInfo {
    private static final SimpleDateFormat DATE = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");

    public InfoDB() {
        super(513, new String[0]);
    }

    @Override
    protected boolean run() throws IOException {
        boolean create = this.context.user.perm(4);
        this.out.print(InfoDB.db(this.context.data.meta, false, true, create));
        return true;
    }

    public static byte[] db(MetaData meta, boolean bold, boolean index, boolean create) {
        TokenBuilder tb = new TokenBuilder();
        String header = String.valueOf(bold ? new TokenBuilder().bold().add("%").norm().toString() : "%") + Text.NL;
        tb.addExt(header, Text.INFODB);
        InfoDB.format(tb, Text.INFODBNAME, meta.name);
        InfoDB.format(tb, Text.INFODBSIZE, Performance.format(meta.dbsize()));
        InfoDB.format(tb, Text.INFONODES, Integer.toString(meta.size));
        tb.add(Text.NL).addExt(header, Text.INFOCREATE);
        InfoDB.format(tb, Text.INFOTIME, DATE.format(new Date(meta.time)));
        if (create && !meta.original.isEmpty()) {
            InfoDB.format(tb, Text.INFOPATH, meta.original);
        }
        if (meta.filesize != 0L) {
            InfoDB.format(tb, Text.INFODOCSIZE, Performance.format(meta.filesize));
        }
        InfoDB.format(tb, Text.INFOENCODING, meta.encoding);
        InfoDB.format(tb, Text.INFONDOCS, Integer.toString(meta.ndocs));
        InfoDB.format(tb, Text.INFOCHOP, InfoDB.flag(meta.chop));
        if (index) {
            tb.add(Text.NL).addExt(header, Text.INFOINDEX);
            if (meta.oldindex) {
                tb.add(" " + Text.INDUPDATE + Text.NL);
            } else {
                InfoDB.format(tb, Text.INFOUPTODATE, String.valueOf(meta.uptodate));
                InfoDB.format(tb, Text.INFOPATHINDEX, InfoDB.flag(meta.pathindex));
                InfoDB.format(tb, Text.INFOTEXTINDEX, InfoDB.flag(meta.textindex));
                InfoDB.format(tb, Text.INFOATTRINDEX, InfoDB.flag(meta.attrindex));
                InfoDB.format(tb, Text.INFOFTINDEX, String.valueOf(InfoDB.flag(meta.ftindex)) + (meta.ftindex && meta.wildcards ? " (" + Text.INFOWCINDEX + ")" : ""));
            }
        }
        return tb.finish();
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.DB));
    }
}

