/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.AUser;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.server.ClientListener;
import org.basex.util.Util;

public final class DropUser
extends AUser {
    public DropUser(String name) {
        this(name, (String)null);
    }

    public DropUser(String name, String db) {
        super(name, db);
    }

    @Override
    protected boolean run() {
        return this.run(0, true);
    }

    @Override
    protected boolean run(String user, String db) {
        if (user.equals("admin")) {
            return !this.info(Text.USERADMIN, new Object[0]);
        }
        if (db == null) {
            for (ClientListener s : this.context.sessions) {
                if (!s.user().name.equals(user)) continue;
                return !this.info(Text.USERLOG, user);
            }
            this.context.users.drop(this.context.users.get(user));
            return this.info(Text.USERDROP, user);
        }
        try {
            Data data = Open.open(db, this.context);
            if (data.meta.users.drop(data.meta.users.get(user))) {
                this.info(Text.USERDROPON, user, db);
                data.meta.dirty = true;
                data.flush();
            }
            Close.close(data, this.context);
            return true;
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return !this.info(msg.isEmpty() ? Text.DBOPENERR : msg, db);
        }
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.USER)).arg(0).arg("ON", 1);
    }
}

