/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import org.basex.core.Text;

public interface Commands {

    public static enum Cmd {
        ADD(Text.HELPADD),
        ALTER(Text.HELPALTER),
        CHECK(Text.HELPCHECK),
        CLOSE(Text.HELPCLOSE),
        COPY(Text.HELPCOPY),
        CREATE(Text.HELPCREATE),
        CS(Text.HELPCS),
        DELETE(Text.HELPDELETE),
        DROP(Text.HELPDROP),
        EXIT(Text.HELPEXIT),
        EXPORT(Text.HELPEXPORT),
        FIND(Text.HELPFIND),
        GET(Text.HELPGET),
        GRANT(Text.HELPGRANT),
        HELP(Text.HELPHELP),
        INFO(Text.HELPINFO),
        KILL(Text.HELPKILL),
        LIST(Text.HELPLIST),
        OPEN(Text.HELPOPEN),
        OPTIMIZE(Text.HELPOPTIMIZE),
        PASSWORD(Text.HELPPASSWORD),
        RENAME(Text.HELPRENAME),
        REPLACE(Text.HELPREPLACE),
        REPO(Text.HELPREPO),
        RESTORE(Text.HELPRESTORE),
        RUN(Text.HELPRUN),
        SET(Text.HELPSET),
        SHOW(Text.HELPSHOW),
        XQUERY(Text.HELPXQUERY);

        private final String[] help;

        private Cmd() {
            this(null);
        }

        private Cmd(String ... h) {
            this.help = h;
        }

        public final String help(boolean detail, boolean wiki) {
            StringBuilder sb = new StringBuilder();
            if (wiki) {
                this.wiki(sb);
            } else if (this.help == null) {
                if (detail) {
                    sb.append(String.valueOf(Text.NOHELP) + Text.NL);
                }
            } else {
                sb.append((Object)((Object)this) + " " + this.help[0] + Text.NL + "  " + this.help[1] + Text.NL);
                if (detail) {
                    sb.append(String.valueOf(Text.NL) + this.help[2] + Text.NL);
                }
            }
            return sb.toString();
        }

        private void wiki(StringBuilder sb) {
            if (this.help == null) {
                return;
            }
            sb.append("===" + (Object)((Object)this) + "===" + Text.NL + Text.NL);
            sb.append("'''<code>" + (Object)((Object)this) + " " + this.help[0] + "</code>'''" + Text.NL + Text.NL);
            String[] stringArray = this.help[2].split(Text.NL);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.startsWith("- ")) {
                    s = s.replaceAll("^- (.*?)(:|$)", "* <code>$1</code>$2");
                } else {
                    s = s.replaceAll("^ ", ":");
                    s = s.replaceAll("\\[", "<code>[").replaceAll("\\]", "]</code>");
                }
                sb.append(s).append(Text.NL);
                ++n2;
            }
            sb.append(Text.NL);
        }
    }

    public static enum CmdAlter {
        DATABASE,
        DB,
        USER;

    }

    public static enum CmdCreate {
        DATABASE,
        DB,
        INDEX,
        USER,
        BACKUP,
        EVENT;

    }

    public static enum CmdDrop {
        DATABASE,
        DB,
        INDEX,
        USER,
        BACKUP,
        EVENT;

    }

    public static enum CmdIndex {
        TEXT,
        ATTRIBUTE,
        FULLTEXT,
        PATH;

    }

    public static enum CmdIndexInfo {
        NULL,
        TEXT,
        ATTRIBUTE,
        FULLTEXT,
        PATH,
        TAG,
        ATTNAME;

    }

    public static enum CmdInfo {
        NULL,
        DATABASE,
        DB,
        INDEX,
        STORAGE;

    }

    public static enum CmdOptimize {
        NULL,
        ALL;

    }

    public static enum CmdPerm {
        NONE,
        READ,
        WRITE,
        CREATE,
        ADMIN;

    }

    public static enum CmdRepo {
        INSTALL,
        DELETE,
        LIST;

    }

    public static enum CmdSet {
        QUERYINFO,
        DEBUG,
        SERIALIZE,
        CHOP,
        ENTITY,
        TEXTINDEX,
        ATTRINDEX,
        FTINDEX,
        PATHINDEX;

    }

    public static enum CmdShow {
        DATABASES,
        SESSIONS,
        USERS,
        BACKUPS,
        EVENTS;

    }
}

