/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.execution;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.task.api.ClusterStatusInformation;
import com.evolveum.midpoint.task.api.Node;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskExecutionStatus;
import com.evolveum.midpoint.task.api.TaskManagerException;
import com.evolveum.midpoint.task.api.TaskManagerInitializationException;
import com.evolveum.midpoint.task.api.UseThreadInterrupt;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerConfiguration;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.TaskQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.TaskQuartzImplUtil;
import com.evolveum.midpoint.task.quartzimpl.cluster.ClusterManager;
import com.evolveum.midpoint.task.quartzimpl.execution.LocalNodeManager;
import com.evolveum.midpoint.task.quartzimpl.execution.RemoteNodesManager;
import com.evolveum.midpoint.task.quartzimpl.execution.TaskSynchronizer;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class ExecutionManager {
    private static final transient Trace LOGGER = TraceManager.getTrace(ExecutionManager.class);
    private static final String DOT_CLASS = String.valueOf(ExecutionManager.class.getName()) + ".";
    private static final long WAIT_FOR_COMPLETION_INITIAL = 100L;
    private static final long WAIT_FOR_COMPLETION_MAX = 1600L;
    private static final long INTERRUPT_TASK_THREAD_AFTER = 5000L;
    private TaskManagerQuartzImpl taskManager;
    private LocalNodeManager localNodeManager;
    private RemoteNodesManager remoteNodesManager;
    private TaskSynchronizer taskSynchronizer;
    private Scheduler quartzScheduler;

    public ExecutionManager(TaskManagerQuartzImpl taskManager) {
        this.taskManager = taskManager;
        this.localNodeManager = new LocalNodeManager(taskManager);
        this.remoteNodesManager = new RemoteNodesManager(taskManager);
        this.taskSynchronizer = new TaskSynchronizer(taskManager);
    }

    public void stopScheduler(String nodeIdentifier, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(this.getClass().getName()) + ".stopScheduler");
        result.addParam("nodeIdentifier", (Object)nodeIdentifier);
        if (this.isCurrentNode(nodeIdentifier)) {
            this.localNodeManager.stopScheduler(result);
        } else {
            this.remoteNodesManager.stopRemoteScheduler(nodeIdentifier, result);
        }
    }

    public boolean stopSchedulersAndTasks(List<String> nodeList, long timeToWait, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(this.getClass().getName()) + ".stopSchedulersAndTasks");
        result.addParam("nodeList", nodeList);
        result.addParam("timeToWait", (Object)timeToWait);
        LOGGER.info("Stopping schedulers and tasks on nodes: {}, waiting {} ms for task(s) shutdown.", nodeList, (Object)timeToWait);
        for (String nodeIdentifier : nodeList) {
            this.stopScheduler(nodeIdentifier, result);
        }
        ClusterStatusInformation csi = this.getClusterStatusInformation(true, result);
        Set taskInfoList = csi.getTasksOnNodes(nodeList);
        LOGGER.debug("{} task(s) found on nodes that are going down, stopping them.", (Object)taskInfoList.size());
        HashSet<Task> tasks = new HashSet<Task>();
        for (ClusterStatusInformation.TaskInfo taskInfo : taskInfoList) {
            try {
                tasks.add(this.taskManager.getTask(taskInfo.getOid(), result));
            }
            catch (ObjectNotFoundException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Task {} that was about to be stopped does not exist. Ignoring it.", (Throwable)e, (Object[])new Object[]{taskInfo.getOid()});
            }
            catch (SchemaException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Task {} that was about to be stopped cannot be read due to schema problem. Ignoring it.", (Throwable)e, (Object[])new Object[]{taskInfo.getOid()});
            }
        }
        boolean stopped = this.stopTasksRunAndWait(tasks, csi, timeToWait, true, result);
        LOGGER.trace("All tasks stopped = " + stopped);
        result.recordSuccessIfUnknown();
        return stopped;
    }

    public void startScheduler(String nodeIdentifier, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(this.getClass().getName()) + ".startScheduler");
        result.addParam("nodeIdentifier", (Object)nodeIdentifier);
        if (this.isCurrentNode(nodeIdentifier)) {
            this.localNodeManager.startScheduler(result);
        } else {
            this.remoteNodesManager.startRemoteScheduler(nodeIdentifier, result);
        }
    }

    public ClusterStatusInformation getClusterStatusInformation(boolean clusterwide, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ExecutionManager.class.getName()) + ".getClusterStatusInformation");
        result.addParam("clusterwide", (Object)clusterwide);
        ClusterStatusInformation retval = new ClusterStatusInformation();
        if (clusterwide) {
            for (PrismObject<NodeType> node : this.taskManager.getClusterManager().getAllNodes(result)) {
                try {
                    this.addNodeAndTaskInformation(retval, node, result);
                }
                catch (TaskManagerException e) {
                    LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get node/task information from node {}", (Throwable)e, (Object[])new Object[]{node.getName()});
                }
            }
        } else {
            try {
                this.addNodeAndTaskInformation(retval, this.taskManager.getClusterManager().getNodePrism(), result);
            }
            catch (TaskManagerException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get node/task information from local node", (Throwable)e, (Object[])new Object[0]);
            }
        }
        LOGGER.debug("cluster state information = " + retval.dump());
        result.recomputeStatus();
        return retval;
    }

    private void addNodeAndTaskInformation(ClusterStatusInformation info, PrismObject<NodeType> node, OperationResult parentResult) throws TaskManagerException {
        OperationResult result = parentResult.createSubresult(String.valueOf(ExecutionManager.class.getName()) + ".addNodeAndTaskInformation");
        result.addParam("node", node);
        if (this.isCurrentNode(node)) {
            LOGGER.trace("Getting node and task info from the current node ({})", (Object)((NodeType)node.asObjectable()).getNodeIdentifier());
            ArrayList<ClusterStatusInformation.TaskInfo> taskInfoList = new ArrayList<ClusterStatusInformation.TaskInfo>();
            Set<Task> tasks = this.localNodeManager.getLocallyRunningTasks(result);
            for (Task task : tasks) {
                taskInfoList.add(new ClusterStatusInformation.TaskInfo(task.getOid()));
            }
            Node nodeInfo = new Node(node);
            nodeInfo.setNodeExecutionStatus(this.localNodeManager.getLocalNodeExecutionStatus());
            nodeInfo.setNodeErrorStatus(this.taskManager.getLocalNodeErrorStatus());
            info.addNodeAndTaskInfo(nodeInfo, taskInfoList);
        } else {
            LOGGER.debug("Getting running task info from remote node ({}, {})", (Object)((NodeType)node.asObjectable()).getNodeIdentifier(), (Object)((NodeType)node.asObjectable()).getHostname());
            this.remoteNodesManager.addNodeStatusFromRemoteNode(info, node, result);
        }
        result.recordSuccessIfUnknown();
    }

    public boolean stopAllTasksOnThisNodeAndWait(long timeToWait, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(DOT_CLASS) + "stopAllTasksOnThisNodeAndWait");
        result.addParam("timeToWait", (Object)timeToWait);
        LOGGER.info("Stopping all tasks on local node");
        Set<Task> tasks = this.localNodeManager.getLocallyRunningTasks(result);
        boolean retval = this.stopTasksRunAndWait(tasks, null, timeToWait, false, result);
        result.computeStatus();
        return retval;
    }

    public boolean stopTasksRunAndWait(Collection<Task> tasks, ClusterStatusInformation csi, long waitTime, boolean clusterwide, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(DOT_CLASS) + "stopTasksRunAndWait");
        result.addParam("tasks", TaskQuartzImplUtil.tasksToOperationResult(tasks));
        result.addParam("waitTime", (Object)waitTime);
        result.addParam("clusterwide", (Object)clusterwide);
        if (tasks.isEmpty()) {
            result.recordSuccess();
            return true;
        }
        LOGGER.trace("Stopping tasks " + tasks + " (waiting " + waitTime + " msec); clusterwide = " + clusterwide);
        if (clusterwide && csi == null) {
            csi = this.getClusterStatusInformation(true, result);
        }
        for (Task task : tasks) {
            this.stopTaskRun(task, csi, clusterwide, result);
        }
        boolean stopped = false;
        if (waitTime >= 0L) {
            stopped = this.waitForTaskRunCompletion(tasks, waitTime, clusterwide, result);
        }
        result.recordSuccessIfUnknown();
        return stopped;
    }

    private boolean waitForTaskRunCompletion(Collection<Task> tasks, long maxWaitTime, boolean clusterwide, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ExecutionManager.class.getName()) + ".waitForTaskRunCompletion");
        result.addParam("tasks", tasks);
        result.addParam("maxWaitTime", (Object)maxWaitTime);
        result.addParam("clusterwide", (Object)clusterwide);
        boolean interruptExecuted = false;
        LOGGER.trace("Waiting for task(s) " + tasks + " to complete, at most for " + maxWaitTime + " ms.");
        HashSet<String> oids = new HashSet<String>();
        for (Task t : tasks) {
            if (t.getOid() == null) continue;
            oids.add(t.getOid());
        }
        long singleWait = 100L;
        long started = System.currentTimeMillis();
        while (true) {
            String message;
            boolean isAnythingExecuting = false;
            ClusterStatusInformation rtinfo = this.getClusterStatusInformation(clusterwide, result);
            for (String oid : oids) {
                if (rtinfo.findNodeInfoForTask(oid) == null) continue;
                isAnythingExecuting = true;
                break;
            }
            if (!isAnythingExecuting) {
                message = "The task(s), for which we have been waiting for, have finished.";
                LOGGER.trace(message);
                result.recordStatus(OperationResultStatus.SUCCESS, message);
                return true;
            }
            if (maxWaitTime > 0L && System.currentTimeMillis() - started >= maxWaitTime) {
                message = "Wait time has elapsed without (some of) tasks being stopped. Finishing waiting for task(s) completion.";
                LOGGER.trace(message);
                result.recordWarning(message);
                return false;
            }
            if (this.getConfiguration().getUseThreadInterrupt() == UseThreadInterrupt.WHEN_NECESSARY && !interruptExecuted && System.currentTimeMillis() - started >= 5000L) {
                LOGGER.info("Some tasks have not completed yet, sending their threads the 'interrupt' signal (if running locally).");
                for (String oid : oids) {
                    this.localNodeManager.interruptLocalTaskThread(oid);
                }
                interruptExecuted = true;
            }
            LOGGER.trace("Some tasks have not completed yet, waiting for " + singleWait + " ms (max: " + maxWaitTime + ")");
            try {
                Thread.sleep(singleWait);
            }
            catch (InterruptedException e) {
                LOGGER.trace("Waiting interrupted" + e);
            }
            if (singleWait >= 1600L) continue;
            singleWait *= 2L;
        }
    }

    private void stopTaskRun(Task task, ClusterStatusInformation csi, boolean clusterwide, OperationResult parentResult) {
        String oid = task.getOid();
        LOGGER.trace("stopTaskRun: task = {}, csi = {}, clusterwide = {}", new Object[]{task, csi, clusterwide});
        if (!clusterwide) {
            this.stopLocalTaskIfRunning(oid, parentResult);
        } else {
            Node node = csi.findNodeInfoForTask(task.getOid());
            if (node != null) {
                if (this.taskManager.getClusterManager().isCurrentNode(node.getNodeIdentifier())) {
                    this.stopLocalTaskIfRunning(oid, parentResult);
                } else {
                    this.remoteNodesManager.stopRemoteTaskRun(task.getOid(), node, parentResult);
                }
            }
        }
    }

    private void stopLocalTaskIfRunning(String oid, OperationResult parentResult) {
        if (this.localNodeManager.isTaskThreadActiveLocally(oid)) {
            this.localNodeManager.stopLocalTaskRun(oid, parentResult);
        }
    }

    public void unscheduleTask(Task task, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(DOT_CLASS) + "unscheduleTask");
        JobKey jobKey = TaskQuartzImplUtil.createJobKeyForTask(task);
        try {
            for (Trigger trigger : this.quartzScheduler.getTriggersOfJob(jobKey)) {
                this.quartzScheduler.unscheduleJob(trigger.getKey());
            }
            result.recordSuccess();
        }
        catch (SchedulerException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot unschedule task {}", (Throwable)e, (Object[])new Object[]{task});
            result.recordFatalError("Cannot unschedule task " + task, (Throwable)e);
        }
    }

    public boolean removeTaskFromQuartz(String oid, OperationResult parentResult) {
        JobKey jobKey = TaskQuartzImplUtil.createJobKeyForTaskOid(oid);
        try {
            this.quartzScheduler.deleteJob(jobKey);
            return true;
        }
        catch (SchedulerException e) {
            String message = "Cannot delete task " + oid + " from Quartz job store";
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            parentResult.createSubresult(String.valueOf(DOT_CLASS) + "removeTaskFromQuartz").recordFatalError(message, (Throwable)e);
            return false;
        }
    }

    private OperationResult createOperationResult(String methodName) {
        return new OperationResult(String.valueOf(ExecutionManager.class.getName()) + "." + methodName);
    }

    private ClusterManager getClusterManager() {
        return this.taskManager.getClusterManager();
    }

    public void setQuartzScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    private boolean isCurrentNode(String nodeIdentifier) {
        return this.taskManager.getClusterManager().isCurrentNode(nodeIdentifier);
    }

    private boolean isCurrentNode(PrismObject<NodeType> node) {
        return this.taskManager.isCurrentNode(node);
    }

    private TaskManagerConfiguration getConfiguration() {
        return this.taskManager.getConfiguration();
    }

    public void shutdownLocalScheduler() throws TaskManagerException {
        this.localNodeManager.shutdownScheduler();
    }

    public void shutdownLocalSchedulerChecked() {
        try {
            this.localNodeManager.shutdownScheduler();
        }
        catch (TaskManagerException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot shutdown scheduler.", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public boolean stopSchedulerAndTasksLocally(long timeToWait, OperationResult result) {
        return this.localNodeManager.stopSchedulerAndTasks(timeToWait, result);
    }

    public void synchronizeTask(TaskQuartzImpl task, OperationResult result) {
        this.taskSynchronizer.synchronizeTask(task, result);
    }

    public Long getNextRunStartTime(String oid, OperationResult result) {
        Trigger t;
        try {
            t = this.quartzScheduler.getTrigger(TaskQuartzImplUtil.createTriggerKeyForTaskOid(oid));
            result.recordSuccess();
        }
        catch (SchedulerException e) {
            String message = "Cannot determine next run start time for task with OID " + oid;
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            result.recordFatalError(message, (Throwable)e);
            return null;
        }
        if (t == null) {
            return null;
        }
        Date next = t.getNextFireTime();
        return next == null ? null : Long.valueOf(next.getTime());
    }

    public boolean synchronizeJobStores(OperationResult result) {
        return this.taskSynchronizer.synchronizeJobStores(result);
    }

    public Set<Task> getLocallyRunningTasks() {
        return this.localNodeManager.getLocallyRunningTasks(this.createOperationResult("getRunningTasks"));
    }

    public void initializeLocalScheduler() throws TaskManagerInitializationException {
        this.localNodeManager.initializeScheduler();
    }

    public void scheduleTaskNow(Task task, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(DOT_CLASS) + "scheduleTaskNow");
        if (task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
            String message = "Task " + task + " cannot be scheduled, because it is not in RUNNABLE state.";
            result.recordFatalError(message);
            LOGGER.error(message);
            return;
        }
        Trigger now = TaskQuartzImplUtil.createTriggerNowForTask(task);
        try {
            this.quartzScheduler.scheduleJob(now);
            result.recordSuccess();
        }
        catch (SchedulerException e) {
            String message = "Task " + task + " cannot be scheduled: " + e.getMessage();
            result.recordFatalError(message, (Throwable)e);
            LOGGER.error(message);
        }
    }
}

