/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl.cluster;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.NodeErrorStatus;
import com.evolveum.midpoint.task.api.TaskManagerInitializationException;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerConfiguration;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.cluster.ClusterManager;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;

public class NodeRegistrar {
    private static final transient Trace LOGGER = TraceManager.getTrace(NodeRegistrar.class);
    private TaskManagerQuartzImpl taskManager;
    private ClusterManager clusterManager;
    private PrismObject<NodeType> nodePrism;

    public NodeRegistrar(TaskManagerQuartzImpl taskManager, ClusterManager clusterManager) {
        Validate.notNull((Object)taskManager);
        Validate.notNull((Object)clusterManager);
        this.taskManager = taskManager;
        this.clusterManager = clusterManager;
    }

    PrismObject<NodeType> createNodeObject(OperationResult result) throws TaskManagerInitializationException {
        this.nodePrism = this.createNodePrism(this.taskManager.getConfiguration());
        NodeType node = (NodeType)this.nodePrism.asObjectable();
        LOGGER.info("Registering this node in the repository as " + node.getNodeIdentifier() + " at " + node.getHostname() + ":" + node.getJmxPort());
        List<PrismObject<NodeType>> nodes = null;
        try {
            nodes = this.findNodesWithGivenName(result, node.getName());
        }
        catch (SchemaException e) {
            throw new TaskManagerInitializationException("Node registration failed because of schema exception", (Throwable)e);
        }
        for (PrismObject<NodeType> n : nodes) {
            LOGGER.trace("Removing existing NodeType with oid = {}, name = {}", (Object)n.getOid(), (Object)n.getName());
            try {
                this.getRepositoryService().deleteObject(NodeType.class, n.getOid(), result);
            }
            catch (ObjectNotFoundException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot remove NodeType with oid = {}, name = {}, because it does not exist.", (Throwable)e, (Object[])new Object[]{n.getOid(), n.getName()});
            }
        }
        try {
            String oid = this.getRepositoryService().addObject(this.nodePrism, result);
            this.nodePrism.setOid(oid);
        }
        catch (ObjectAlreadyExistsException e) {
            this.taskManager.setNodeErrorStatus(NodeErrorStatus.NODE_REGISTRATION_FAILED);
            throw new TaskManagerInitializationException("Cannot register this node, because it already exists (this should not happen, as nodes with such a name were just removed)", (Throwable)e);
        }
        catch (SchemaException e) {
            this.taskManager.setNodeErrorStatus(NodeErrorStatus.NODE_REGISTRATION_FAILED);
            throw new TaskManagerInitializationException("Cannot register this node because of schema exception", (Throwable)e);
        }
        LOGGER.trace("Node was successfully registered in the repository.");
        return this.nodePrism;
    }

    private PrismObject<NodeType> createNodePrism(TaskManagerConfiguration configuration) {
        PrismObjectDefinition nodeTypeDef = this.getPrismContext().getSchemaRegistry().findObjectDefinitionByCompileTimeClass(NodeType.class);
        PrismObject nodePrism = nodeTypeDef.instantiate();
        NodeType node = (NodeType)nodePrism.asObjectable();
        node.setNodeIdentifier(configuration.getNodeId());
        node.setName(configuration.getNodeId());
        node.setHostname(this.getMyAddress());
        node.setJmxPort(Integer.valueOf(configuration.getJmxPort()));
        node.setClustered(Boolean.valueOf(configuration.isClustered()));
        node.setRunning(Boolean.valueOf(true));
        node.setLastCheckInTime(this.getCurrentTime());
        this.generateInternalNodeIdentifier(node);
        return nodePrism;
    }

    private void generateInternalNodeIdentifier(NodeType node) {
        String id = String.valueOf(node.getNodeIdentifier()) + ":" + node.getJmxPort() + ":" + Math.round(Math.random() * 1.0E13);
        LOGGER.trace("internal node identifier generated: " + id);
        node.setInternalNodeIdentifier(id);
    }

    private XMLGregorianCalendar getCurrentTime() {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
        }
        catch (DatatypeConfigurationException e) {
            throw new SystemException("Cannot create DatatypeFactory (to create XMLGregorianCalendar instance).", (Throwable)e);
        }
    }

    private PropertyDelta<NodeType> createCheckInTimeDelta() {
        return PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)this.nodePrism.getDefinition()), (QName)NodeType.F_LAST_CHECK_IN_TIME, (Object[])new Object[]{this.getCurrentTime()});
    }

    @Deprecated
    void removeNodeObject(OperationResult result) {
        String oid = this.nodePrism.getOid();
        String name = ((NodeType)this.nodePrism.asObjectable()).getNodeIdentifier();
        LOGGER.trace("Removing this node from the repository (name {}, oid {})", (Object)name, (Object)oid);
        try {
            this.getRepositoryService().deleteObject(NodeType.class, oid, result);
            LOGGER.trace("Node successfully unregistered (removed).");
        }
        catch (ObjectNotFoundException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot unregister (remove) this node (name {}, oid {}), because it does not exist.", (Throwable)e, (Object[])new Object[]{name, oid});
        }
    }

    void recordNodeShutdown(OperationResult result) {
        LOGGER.trace("Registering this node shutdown (name {}, oid {})", (Object)((NodeType)this.nodePrism.asObjectable()).getName(), (Object)this.nodePrism.getOid());
        ArrayList<Object> modifications = new ArrayList<Object>();
        modifications.add(PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)this.nodePrism.getDefinition()), (QName)NodeType.F_RUNNING, (Object[])new Object[]{false}));
        modifications.add(this.createCheckInTimeDelta());
        try {
            this.getRepositoryService().modifyObject(NodeType.class, this.nodePrism.getOid(), modifications, result);
            LOGGER.trace("Node shutdown successfully registered.");
        }
        catch (ObjectNotFoundException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot register shutdown of this node (name {}, oid {}), because it does not exist.", (Throwable)e, (Object[])new Object[]{((NodeType)this.nodePrism.asObjectable()).getName(), this.nodePrism.getOid()});
        }
        catch (ObjectAlreadyExistsException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot register shutdown of this node (name {}, oid {}).", (Throwable)e, (Object[])new Object[]{((NodeType)this.nodePrism.asObjectable()).getName(), this.nodePrism.getOid()});
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot register shutdown of this node (name {}, oid {}) due to schema exception.", (Throwable)e, (Object[])new Object[]{((NodeType)this.nodePrism.asObjectable()).getName(), this.nodePrism.getOid()});
        }
    }

    void updateNodeObject(OperationResult result) {
        block6: {
            LOGGER.trace("Updating this node registration (name {}, oid {})", (Object)((NodeType)this.nodePrism.asObjectable()).getName(), (Object)this.nodePrism.getOid());
            ArrayList<Object> modifications = new ArrayList<Object>();
            modifications.add(PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)this.nodePrism.getDefinition()), (QName)NodeType.F_HOSTNAME, (Object[])new Object[]{this.getMyAddress()}));
            modifications.add(this.createCheckInTimeDelta());
            try {
                this.getRepositoryService().modifyObject(NodeType.class, this.nodePrism.getOid(), modifications, result);
                LOGGER.trace("Node registration successfully updated.");
            }
            catch (ObjectNotFoundException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot update registration of this node (name {}, oid {}), because it does not exist in repository. It is probably caused by cluster misconfiguration (other node rewriting the Node object?) Stopping the scheduler.", (Throwable)e, (Object[])new Object[]{((NodeType)this.nodePrism.asObjectable()).getName(), this.nodePrism.getOid()});
                if (this.taskManager.getLocalNodeErrorStatus() == NodeErrorStatus.OK) {
                    this.registerNodeError(NodeErrorStatus.NODE_REGISTRATION_FAILED);
                }
            }
            catch (ObjectAlreadyExistsException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot update registration of this node (name {}, oid {}).", (Throwable)e, (Object[])new Object[]{((NodeType)this.nodePrism.asObjectable()).getName(), this.nodePrism.getOid()});
                if (this.taskManager.getLocalNodeErrorStatus() == NodeErrorStatus.OK) {
                    this.registerNodeError(NodeErrorStatus.NODE_REGISTRATION_FAILED);
                }
            }
            catch (SchemaException e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Cannot update registration of this node (name {}, oid {}) due to schema exception. Stopping the scheduler.", (Throwable)e, (Object[])new Object[]{((NodeType)this.nodePrism.asObjectable()).getName(), this.nodePrism.getOid()});
                if (this.taskManager.getLocalNodeErrorStatus() != NodeErrorStatus.OK) break block6;
                this.registerNodeError(NodeErrorStatus.NODE_REGISTRATION_FAILED);
            }
        }
    }

    void verifyNodeObject(OperationResult result) {
        PrismObject nodeInRepo;
        String oid = this.nodePrism.getOid();
        String myName = ((NodeType)this.nodePrism.asObjectable()).getName();
        LOGGER.trace("Verifying node record with OID = " + oid);
        try {
            nodeInRepo = this.getRepositoryService().getObject(NodeType.class, oid, result);
        }
        catch (ObjectNotFoundException e) {
            if (this.doesNodeExist(result, myName)) {
                LoggingUtils.logException((Trace)LOGGER, (String)"The record of this node cannot be read (OID {} not found), but another node record with the name '{}' exists. It seems that in this cluster there are two or more nodes with the same name '{}'. Stopping the scheduler to minimize the damage.", (Throwable)e, (Object[])new Object[]{oid, myName, myName});
                this.registerNodeError(NodeErrorStatus.DUPLICATE_NODE_ID_OR_NAME);
                return;
            }
            LoggingUtils.logException((Trace)LOGGER, (String)"The record of this node cannot be read (OID {} not found). It  seems it was deleted in the meantime. Please check the reason. Stopping the scheduler to minimize the damage.", (Throwable)e, (Object[])new Object[]{oid, myName, myName});
            this.registerNodeError(NodeErrorStatus.NODE_REGISTRATION_FAILED);
            return;
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot check the record of this node (OID = {}) because of schema exception. Stopping the scheduler.", (Throwable)e, (Object[])new Object[]{oid});
            this.registerNodeError(NodeErrorStatus.NODE_REGISTRATION_FAILED);
            return;
        }
        String existingId = ((NodeType)this.nodePrism.asObjectable()).getInternalNodeIdentifier();
        String idInRepo = ((NodeType)nodeInRepo.asObjectable()).getInternalNodeIdentifier();
        if (!existingId.equals(idInRepo)) {
            LOGGER.error("Internal node identifier has been overwritten in the repository. Probably somebody has overwritten it in the meantime, i.e. another node with the name of '" + ((NodeType)this.nodePrism.asObjectable()).getName() + "' is running. Stopping the scheduler.");
            this.registerNodeError(NodeErrorStatus.DUPLICATE_NODE_ID_OR_NAME);
            return;
        }
    }

    public void checkNonClusteredNodes(OperationResult result) {
        LOGGER.trace("Checking non-clustered nodes.");
        ArrayList<String> clustered = new ArrayList<String>();
        ArrayList<String> nonClustered = new ArrayList<String>();
        List<PrismObject<NodeType>> allNodes = this.clusterManager.getAllNodes(result);
        for (PrismObject<NodeType> nodePrism : allNodes) {
            NodeType n = (NodeType)nodePrism.asObjectable();
            if (!this.isUp(n)) continue;
            if (n.isClustered().booleanValue()) {
                clustered.add(n.getNodeIdentifier());
                continue;
            }
            nonClustered.add(n.getNodeIdentifier());
        }
        LOGGER.trace("Clustered nodes: " + clustered);
        LOGGER.trace("Non-clustered nodes: " + nonClustered);
        int all = clustered.size() + nonClustered.size();
        if (!this.taskManager.getConfiguration().isClustered() && all > 1) {
            LOGGER.error("This node is a non-clustered one, mixed with other nodes. In this system, there are " + nonClustered.size() + " non-clustered nodes (" + nonClustered + ") and " + clustered.size() + " clustered ones (" + clustered + "). Stopping this node.");
            this.registerNodeError(NodeErrorStatus.NON_CLUSTERED_NODE_WITH_OTHERS);
        }
    }

    boolean isUp(NodeType n) {
        return n.getLastCheckInTime() != null && System.currentTimeMillis() - n.getLastCheckInTime().toGregorianCalendar().getTimeInMillis() <= (long)this.taskManager.getConfiguration().getNodeTimeout() * 1000L;
    }

    private boolean doesNodeExist(OperationResult result, String myName) {
        try {
            List<PrismObject<NodeType>> nodes = this.findNodesWithGivenName(result, myName);
            return nodes != null && !nodes.isEmpty();
        }
        catch (SchemaException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Existence of a Node cannot be checked due to schema exception.", (Throwable)e, (Object[])new Object[0]);
            return false;
        }
    }

    private List<PrismObject<NodeType>> findNodesWithGivenName(OperationResult result, String name) throws SchemaException {
        QueryType q = QueryUtil.createNameQuery((String)name);
        return this.getRepositoryService().searchObjects(NodeType.class, q, new PagingType(), result);
    }

    private void registerNodeError(NodeErrorStatus status) {
        this.taskManager.setNodeErrorStatus(status);
        if (this.taskManager.getServiceThreadsActivationState()) {
            this.taskManager.getExecutionManager().stopSchedulerAndTasksLocally(0L, new OperationResult("nodeError"));
        }
        this.taskManager.getExecutionManager().shutdownLocalSchedulerChecked();
        LOGGER.warn("Scheduler stopped, please check your cluster configuration as soon as possible; kind of error = " + status);
    }

    private String getMyAddress() {
        if (this.taskManager.getConfiguration().getJmxHostName() != null) {
            return this.taskManager.getConfiguration().getJmxHostName();
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Cannot get local IP address", (Throwable)e, (Object[])new Object[0]);
            return "unknown-host";
        }
    }

    public PrismObject<NodeType> getNodePrism() {
        return this.nodePrism;
    }

    public String getNodeId() {
        return ((NodeType)this.nodePrism.asObjectable()).getNodeIdentifier();
    }

    public boolean isCurrentNode(PrismObject<NodeType> node) {
        return this.getNodeId().equals(((NodeType)node.asObjectable()).getNodeIdentifier());
    }

    boolean isCurrentNode(String nodeIdentifier) {
        return nodeIdentifier == null || this.getNodeId().equals(nodeIdentifier);
    }

    private RepositoryService getRepositoryService() {
        return this.taskManager.getRepositoryService();
    }

    private PrismContext getPrismContext() {
        return this.taskManager.getPrismContext();
    }

    public void deleteNode(String nodeIdentifier, OperationResult parentResult) {
        OperationResult result = parentResult.createSubresult(String.valueOf(NodeRegistrar.class.getName()) + ".deleteNode");
        result.addParam("nodeIdentified", (Object)nodeIdentifier);
        boolean deleted = false;
        List<PrismObject<NodeType>> nodes = this.clusterManager.getAllNodes(result);
        for (PrismObject<NodeType> nodePrism : nodes) {
            if (!nodeIdentifier.equals(((NodeType)nodePrism.asObjectable()).getNodeIdentifier())) continue;
            deleted = true;
            if (this.isUp((NodeType)nodePrism.asObjectable())) {
                result.recordFatalError("Node " + nodeIdentifier + " cannot be deleted, because it is currently up.");
                continue;
            }
            try {
                this.taskManager.getRepositoryService().deleteObject(NodeType.class, nodePrism.getOid(), result);
                result.recordSuccess();
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                result.recordFatalError("Node " + nodeIdentifier + " cannot be deleted, because it does not exist in repository.");
            }
        }
        if (!deleted) {
            result.recordFatalError("Node " + nodeIdentifier + " cannot be deleted, because it does not exist in repository.");
        }
    }
}

