/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTypeHandler<T>
implements TypeHandler<T> {
    @Override
    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            if (jdbcType == null) {
                try {
                    ps.setNull(i, JdbcType.OTHER.TYPE_CODE);
                }
                catch (SQLException e) {
                    throw new TypeException("Error setting null parameter.  Most JDBC drivers require that the JdbcType must be specified for all nullable parameters. Cause: " + e, e);
                }
            } else {
                ps.setNull(i, jdbcType.TYPE_CODE);
            }
        } else {
            this.setNonNullParameter(ps, i, parameter, jdbcType);
        }
    }

    @Override
    public T getResult(ResultSet rs, String columnName) throws SQLException {
        T result = this.getNullableResult(rs, columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    @Override
    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        T result = this.getNullableResult(cs, columnIndex);
        if (cs.wasNull()) {
            return null;
        }
        return result;
    }

    public abstract void setNonNullParameter(PreparedStatement var1, int var2, T var3, JdbcType var4) throws SQLException;

    public abstract T getNullableResult(ResultSet var1, String var2) throws SQLException;

    public abstract T getNullableResult(CallableStatement var1, int var2) throws SQLException;
}

