/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.reflection.ReflectionException;
import org.apache.ibatis.reflection.invoker.GetFieldInvoker;
import org.apache.ibatis.reflection.invoker.Invoker;
import org.apache.ibatis.reflection.invoker.MethodInvoker;
import org.apache.ibatis.reflection.invoker.SetFieldInvoker;
import org.apache.ibatis.reflection.property.PropertyNamer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflector {
    private static boolean classCacheEnabled = true;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map<Class<?>, Reflector> REFLECTOR_MAP = Collections.synchronizedMap(new HashMap());
    private Class<?> type;
    private String[] readablePropertyNames = EMPTY_STRING_ARRAY;
    private String[] writeablePropertyNames = EMPTY_STRING_ARRAY;
    private Map<String, Invoker> setMethods = new HashMap<String, Invoker>();
    private Map<String, Invoker> getMethods = new HashMap<String, Invoker>();
    private Map<String, Class<?>> setTypes = new HashMap();
    private Map<String, Class<?>> getTypes = new HashMap();
    private Constructor<?> defaultConstructor;
    private Map<String, String> caseInsensitivePropertyMap = new HashMap<String, String>();

    private Reflector(Class<?> clazz) {
        this.type = clazz;
        this.addDefaultConstructor(clazz);
        this.addGetMethods(clazz);
        this.addSetMethods(clazz);
        this.addFields(clazz);
        this.readablePropertyNames = this.getMethods.keySet().toArray(new String[this.getMethods.keySet().size()]);
        this.writeablePropertyNames = this.setMethods.keySet().toArray(new String[this.setMethods.keySet().size()]);
        for (String propName : this.readablePropertyNames) {
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
        }
        for (String propName : this.writeablePropertyNames) {
            this.caseInsensitivePropertyMap.put(propName.toUpperCase(Locale.ENGLISH), propName);
        }
    }

    private void addDefaultConstructor(Class<?> clazz) {
        Constructor<?>[] consts;
        for (Constructor<?> constructor : consts = clazz.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!constructor.isAccessible()) continue;
            this.defaultConstructor = constructor;
        }
    }

    private void addGetMethods(Class<?> cls) {
        Method[] methods;
        for (Method method : methods = this.getClassMethods(cls)) {
            String name = method.getName();
            if (name.startsWith("get") && name.length() > 3) {
                if (method.getParameterTypes().length != 0) continue;
                name = PropertyNamer.methodToProperty(name);
                this.addGetMethod(name, method);
                continue;
            }
            if (!name.startsWith("is") || name.length() <= 2 || method.getParameterTypes().length != 0) continue;
            name = PropertyNamer.methodToProperty(name);
            this.addGetMethod(name, method);
        }
    }

    private void addGetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.getMethods.put(name, new MethodInvoker(method));
            this.getTypes.put(name, method.getReturnType());
        }
    }

    private void addSetMethods(Class<?> cls) {
        Method[] methods;
        HashMap<String, List<Method>> conflictingSetters = new HashMap<String, List<Method>>();
        for (Method method : methods = this.getClassMethods(cls)) {
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3 || method.getParameterTypes().length != 1) continue;
            name = PropertyNamer.methodToProperty(name);
            this.addSetterConflict(conflictingSetters, name, method);
        }
        this.resolveSetterConflicts(conflictingSetters);
    }

    private void addSetterConflict(Map<String, List<Method>> conflictingSetters, String name, Method method) {
        List<Method> list = conflictingSetters.get(name);
        if (list == null) {
            list = new ArrayList<Method>();
            conflictingSetters.put(name, list);
        }
        list.add(method);
    }

    private void resolveSetterConflicts(Map<String, List<Method>> conflictingSetters) {
        for (String propName : conflictingSetters.keySet()) {
            List<Method> setters = conflictingSetters.get(propName);
            Method firstMethod = setters.get(0);
            if (setters.size() == 1) {
                this.addSetMethod(propName, firstMethod);
                continue;
            }
            Class<?> expectedType = this.getTypes.get(propName);
            if (expectedType == null) {
                throw new ReflectionException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            Iterator<Method> methods = setters.iterator();
            Method setter = null;
            while (methods.hasNext()) {
                Method method = methods.next();
                if (method.getParameterTypes().length != 1 || !expectedType.equals(method.getParameterTypes()[0])) continue;
                setter = method;
                break;
            }
            if (setter == null) {
                throw new ReflectionException("Illegal overloaded setter method with ambiguous type for property " + propName + " in class " + firstMethod.getDeclaringClass() + ".  This breaks the JavaBeans " + "specification and can cause unpredicatble results.");
            }
            this.addSetMethod(propName, setter);
        }
    }

    private void addSetMethod(String name, Method method) {
        if (this.isValidPropertyName(name)) {
            this.setMethods.put(name, new MethodInvoker(method));
            this.setTypes.put(name, method.getParameterTypes()[0]);
        }
    }

    private void addFields(Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    field.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!field.isAccessible()) continue;
            if (!this.setMethods.containsKey(field.getName())) {
                this.addSetField(field);
            }
            if (this.getMethods.containsKey(field.getName())) continue;
            this.addGetField(field);
        }
        if (clazz.getSuperclass() != null) {
            this.addFields(clazz.getSuperclass());
        }
    }

    private void addSetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.setMethods.put(field.getName(), new SetFieldInvoker(field));
            this.setTypes.put(field.getName(), field.getType());
        }
    }

    private void addGetField(Field field) {
        if (this.isValidPropertyName(field.getName())) {
            this.getMethods.put(field.getName(), new GetFieldInvoker(field));
            this.getTypes.put(field.getName(), field.getType());
        }
    }

    private boolean isValidPropertyName(String name) {
        return !name.startsWith("$") && !"serialVersionUID".equals(name) && !"class".equals(name);
    }

    private Method[] getClassMethods(Class<?> cls) {
        HashMap<String, Method> uniqueMethods = new HashMap<String, Method>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces;
            this.addUniqueMethods(uniqueMethods, currentClass.getDeclaredMethods());
            for (Class<?> anInterface : interfaces = currentClass.getInterfaces()) {
                this.addUniqueMethods(uniqueMethods, anInterface.getMethods());
            }
        }
        Collection methods = uniqueMethods.values();
        return methods.toArray(new Method[methods.size()]);
    }

    private void addUniqueMethods(HashMap<String, Method> uniqueMethods, Method[] methods) {
        for (Method currentMethod : methods) {
            String signature;
            if (currentMethod.isBridge() || uniqueMethods.containsKey(signature = this.getSignature(currentMethod))) continue;
            if (Reflector.canAccessPrivateMethods()) {
                try {
                    currentMethod.setAccessible(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            uniqueMethods.put(signature, currentMethod);
        }
    }

    private String getSignature(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        Class<?>[] parameters = method.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i == 0) {
                sb.append(':');
            } else {
                sb.append(',');
            }
            sb.append(parameters[i].getName());
        }
        return sb.toString();
    }

    private static boolean canAccessPrivateMethods() {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (null != securityManager) {
                securityManager.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Constructor<?> getDefaultConstructor() {
        if (this.defaultConstructor != null) {
            return this.defaultConstructor;
        }
        throw new ReflectionException("There is no default constructor for " + this.type);
    }

    public Invoker getSetInvoker(String propertyName) {
        Invoker method = this.setMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Invoker getGetInvoker(String propertyName) {
        Invoker method = this.getMethods.get(propertyName);
        if (method == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return method;
    }

    public Class<?> getSetterType(String propertyName) {
        Class<?> clazz = this.setTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no setter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public Class<?> getGetterType(String propertyName) {
        Class<?> clazz = this.getTypes.get(propertyName);
        if (clazz == null) {
            throw new ReflectionException("There is no getter for property named '" + propertyName + "' in '" + this.type + "'");
        }
        return clazz;
    }

    public String[] getGetablePropertyNames() {
        return this.readablePropertyNames;
    }

    public String[] getSetablePropertyNames() {
        return this.writeablePropertyNames;
    }

    public boolean hasSetter(String propertyName) {
        return this.setMethods.keySet().contains(propertyName);
    }

    public boolean hasGetter(String propertyName) {
        return this.getMethods.keySet().contains(propertyName);
    }

    public String findPropertyName(String name) {
        return this.caseInsensitivePropertyMap.get(name.toUpperCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reflector forClass(Class<?> clazz) {
        if (classCacheEnabled) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                Reflector cached = REFLECTOR_MAP.get(clazz);
                if (cached == null) {
                    cached = new Reflector(clazz);
                    REFLECTOR_MAP.put(clazz, cached);
                }
                return cached;
            }
        }
        return new Reflector(clazz);
    }

    public static void setClassCacheEnabled(boolean classCacheEnabled) {
        Reflector.classCacheEnabled = classCacheEnabled;
    }

    public static boolean isClassCacheEnabled() {
        return classCacheEnabled;
    }
}

