/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.ibatis.migration.Change;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationReader;
import org.apache.ibatis.migration.commands.BaseCommand;

public class ScriptCommand
extends BaseCommand {
    public ScriptCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    public void execute(String ... sparams) {
        try {
            BigDecimal v2;
            if (sparams == null || sparams.length < 1 || sparams[0] == null) {
                throw new MigrationException("The script command requires a range of versions from v1 - v2.");
            }
            StringTokenizer parser = new StringTokenizer(sparams[0]);
            if (parser.countTokens() != 2) {
                throw new MigrationException("The script command requires a range of versions from v1 - v2.");
            }
            BigDecimal v1 = new BigDecimal(parser.nextToken());
            boolean undo = v1.compareTo(v2 = new BigDecimal(parser.nextToken())) > 0;
            Properties variables = this.environmentProperties();
            List<Change> migrations = this.getMigrations();
            Collections.sort(migrations);
            if (undo) {
                Collections.reverse(migrations);
            }
            for (Change change : migrations) {
                int l;
                if (!this.shouldRun(change, v1, v2)) continue;
                this.printStream.println("-- " + change.getFilename());
                File file = this.scriptFile(change.getFilename());
                MigrationReader migrationReader = new MigrationReader(this.scriptFileReader(file), undo, variables);
                char[] cbuf = new char[1024];
                while ((l = migrationReader.read(cbuf)) == cbuf.length) {
                    this.printStream.print(new String(cbuf, 0, l));
                }
                this.printStream.print(new String(cbuf, 0, l - 1));
                this.printStream.println();
                this.printStream.println();
                this.printStream.println(undo ? this.generateVersionDelete(change) : this.generateVersionInsert(change));
                this.printStream.println();
            }
        }
        catch (IOException e) {
            throw new MigrationException("Error generating script. Cause: " + e, e);
        }
    }

    private String generateVersionInsert(Change change) {
        return "INSERT INTO " + this.changelogTable() + " (ID, APPLIED_AT, DESCRIPTION) " + "VALUES (" + change.getId() + ", '" + this.generateAppliedTimeStampAsString() + "', '" + change.getDescription().replace('\'', ' ') + "');";
    }

    private String generateVersionDelete(Change change) {
        return "DELETE FROM " + this.changelogTable() + " WHERE ID = " + change.getId() + ";";
    }

    private boolean shouldRun(Change change, BigDecimal v1, BigDecimal v2) {
        BigDecimal id = change.getId();
        if (v1.compareTo(v2) > 0) {
            return id.compareTo(v2) >= 0 && id.compareTo(v1) <= 0;
        }
        return id.compareTo(v1) >= 0 && id.compareTo(v2) <= 0;
    }
}

