/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.datasource.jndi;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.DataSourceException;
import org.apache.ibatis.datasource.DataSourceFactory;

public class JndiDataSourceFactory
implements DataSourceFactory {
    public static final String INITIAL_CONTEXT = "initial_context";
    public static final String DATA_SOURCE = "data_source";
    public static final String ENV_PREFIX = "env.";
    private DataSource dataSource;

    public void setProperties(Properties properties) {
        try {
            InitialContext initCtx = null;
            Hashtable env = JndiDataSourceFactory.getEnvProperties(properties);
            initCtx = env == null ? new InitialContext() : new InitialContext(env);
            if (properties.containsKey(INITIAL_CONTEXT) && properties.containsKey(DATA_SOURCE)) {
                Context ctx = (Context)initCtx.lookup(properties.getProperty(INITIAL_CONTEXT));
                this.dataSource = (DataSource)ctx.lookup(properties.getProperty(DATA_SOURCE));
            } else if (properties.containsKey(DATA_SOURCE)) {
                this.dataSource = (DataSource)initCtx.lookup(properties.getProperty(DATA_SOURCE));
            }
        }
        catch (NamingException e) {
            throw new DataSourceException("There was an error configuring JndiDataSourceTransactionPool. Cause: " + e, e);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    private static Hashtable getEnvProperties(Map allProps) {
        String PREFIX = ENV_PREFIX;
        Properties contextProperties = null;
        for (String key : allProps.keySet()) {
            String value = (String)allProps.get(key);
            if (!key.startsWith(ENV_PREFIX)) continue;
            if (contextProperties == null) {
                contextProperties = new Properties();
            }
            ((Hashtable)contextProperties).put(key.substring(ENV_PREFIX.length()), value);
        }
        return contextProperties;
    }
}

