/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BundleClassLoader
extends URLClassLoader {
    private static final String FRAMEWORK_PACKAGE = "org.identityconnectors.framework";
    private static final String[] ALLOWED_FRAMEWORK_PACKAGES = new String[]{"org.identityconnectors.framework.api", "org.identityconnectors.framework.common", "org.identityconnectors.framework.spi"};
    private final Map<String, String> nativeLibs;

    public BundleClassLoader(List<URL> urls, Map<String, String> nativeLibs, ClassLoader parent) {
        super(urls.toArray(new URL[urls.size()]), parent);
        this.nativeLibs = CollectionUtil.newReadOnlyMap(nativeLibs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                if (this.runningInOIM()) {
                    List<ClassLoader> loaders = ThreadClassLoaderManager.getInstance().popAll();
                    try {
                        c = this.getParent().loadClass(name);
                    }
                    finally {
                        ThreadClassLoaderManager.getInstance().pushAll(loaders);
                    }
                }
                c = this.getParent().loadClass(name);
                this.checkAccessAllowed(c);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private boolean runningInOIM() {
        ClassLoader loader = this.getClass().getClassLoader();
        return loader != null && loader.getClass().getName().contains("tcADPClassLoader");
    }

    private void checkAccessAllowed(Class<?> c) throws ClassNotFoundException {
        String name = c.getName();
        if (!name.startsWith("org.identityconnectors.framework.")) {
            return;
        }
        for (String pack : ALLOWED_FRAMEWORK_PACKAGES) {
            if (!name.startsWith(pack + ".")) continue;
            return;
        }
        String message = "Connector may not reference class '" + name + "', " + "it is an internal framework class.";
        throw new ClassNotFoundException(message);
    }

    @Override
    protected String findLibrary(String libname) {
        return this.nativeLibs.get(System.mapLibraryName(libname));
    }
}

