/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.OperationTimeoutException;

public class MethodTimeoutProxy
implements InvocationHandler {
    private static final ExecutorService THREADPOOL = Executors.newCachedThreadPool();
    private final Object _target;
    private final long _timeoutMillis;

    public MethodTimeoutProxy(Object target, long timeoutMillis) {
        this._target = target;
        this._timeoutMillis = timeoutMillis;
    }

    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this._target, args);
        }
        final Locale locale = CurrentLocale.get();
        Callable<Object> callable = new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                Object object;
                try {
                    CurrentLocale.set(locale);
                    object = method.invoke(MethodTimeoutProxy.this._target, args);
                }
                catch (Throwable throwable) {
                    try {
                        CurrentLocale.clear();
                        throw throwable;
                    }
                    catch (InvocationTargetException e) {
                        Throwable root = e.getCause();
                        if (root instanceof RuntimeException) {
                            throw (RuntimeException)root;
                        }
                        if (root instanceof Exception) {
                            throw (Exception)root;
                        }
                        if (root instanceof Error) {
                            throw (Error)root;
                        }
                        throw ConnectorException.wrap(root);
                    }
                }
                CurrentLocale.clear();
                return object;
            }
        };
        try {
            FutureTask<Object> t = new FutureTask<Object>(callable);
            THREADPOOL.execute(t);
            return t.get(this._timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException ex) {
            throw new OperationTimeoutException(ex);
        }
        catch (ExecutionException ex) {
            throw ex.getCause();
        }
    }
}

