/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoManagerImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorInfoManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorInfoManagerFactoryImpl
extends ConnectorInfoManagerFactory {
    private final Map<LocalManagerKey, ConnectorInfoManager> _localManagerCache = new HashMap<LocalManagerKey, ConnectorInfoManager>();
    private final Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> _remoteManagerCache = new HashMap<RemoteManagerKey, RemoteConnectorInfoManagerImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocalCache() {
        Map<LocalManagerKey, ConnectorInfoManager> map = this._localManagerCache;
        synchronized (map) {
            this._localManagerCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearRemoteCache() {
        Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> map = this._remoteManagerCache;
        synchronized (map) {
            this._remoteManagerCache.clear();
        }
    }

    @Override
    public ConnectorInfoManager getLocalManager(URL ... urls) throws ConfigurationException {
        return this.getLocalManager(Arrays.asList(urls), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorInfoManager getLocalManager(List<URL> urls, ClassLoader bundleParentClassLoader) throws ConfigurationException {
        Assertions.nullCheck(urls, "urls");
        for (URL url : urls) {
            Assertions.nullCheck(url, "urls");
        }
        if (bundleParentClassLoader == null) {
            bundleParentClassLoader = ConnectorInfoManagerFactory.class.getClassLoader();
        }
        LocalManagerKey key = new LocalManagerKey(urls, bundleParentClassLoader);
        Map<LocalManagerKey, ConnectorInfoManager> map = this._localManagerCache;
        synchronized (map) {
            ConnectorInfoManager rv = this._localManagerCache.get(key);
            if (rv == null) {
                rv = new LocalConnectorInfoManagerImpl(urls, bundleParentClassLoader);
            }
            this._localManagerCache.put(key, rv);
            return rv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectorInfoManager getRemoteManager(RemoteFrameworkConnectionInfo info) throws ConfigurationException {
        RemoteManagerKey key = new RemoteManagerKey(info);
        Map<RemoteManagerKey, RemoteConnectorInfoManagerImpl> map = this._remoteManagerCache;
        synchronized (map) {
            RemoteConnectorInfoManagerImpl rv = this._remoteManagerCache.get(key);
            if (rv == null) {
                rv = new RemoteConnectorInfoManagerImpl(info);
            }
            this._remoteManagerCache.put(key, rv);
            return rv.derive(info);
        }
    }

    private static final class RemoteManagerKey {
        private final String _host;
        private final int _port;

        public RemoteManagerKey(RemoteFrameworkConnectionInfo info) {
            this._host = info.getHost();
            this._port = info.getPort();
        }

        public boolean equals(Object o) {
            if (o instanceof RemoteManagerKey) {
                RemoteManagerKey other = (RemoteManagerKey)o;
                if (!this._host.equals(other._host)) {
                    return false;
                }
                return this._port == other._port;
            }
            return false;
        }

        public int hashCode() {
            return this._host.hashCode() ^ this._port;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalManagerKey {
        private final List<URL> _urls;
        private final ClassLoader _bundleParentClassLoader;

        public LocalManagerKey(List<URL> urls, ClassLoader bundleParentClassLoader) {
            this._urls = CollectionUtil.newReadOnlyList(urls);
            this._bundleParentClassLoader = bundleParentClassLoader;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LocalManagerKey) {
                LocalManagerKey other = (LocalManagerKey)obj;
                if (!((Object)this._urls).equals(other._urls)) {
                    return false;
                }
                return this._bundleParentClassLoader.equals(other._bundleParentClassLoader);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this._urls).hashCode() ^ this._bundleParentClassLoader.hashCode();
        }
    }
}

