/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.script.groovy;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.script.ScriptExecutor;
import org.identityconnectors.common.script.ScriptExecutorFactory;

public class GroovyScriptExecutorFactory
extends ScriptExecutorFactory {
    public GroovyScriptExecutorFactory() {
        new GroovyShell();
    }

    public ScriptExecutor newScriptExecutor(ClassLoader loader, String script, boolean compile) {
        return new GroovyScriptExecutor(loader, script);
    }

    public String getLanguageName() {
        return "Groovy";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroovyScriptExecutor
    implements ScriptExecutor {
        private final Script _groovyScript;

        public GroovyScriptExecutor(ClassLoader loader, String script) {
            this._groovyScript = new GroovyShell(loader).parse(script);
        }

        @Override
        public Object execute(Map<String, Object> arguments) throws Exception {
            Map<String, Object> args = CollectionUtil.nullAsEmpty(arguments);
            for (Map.Entry<String, Object> entry : args.entrySet()) {
                this._groovyScript.setProperty(entry.getKey(), entry.getValue());
            }
            return this._groovyScript.run();
        }
    }
}

