/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedAttributeDefinition;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.controller.Filter;
import com.evolveum.midpoint.model.controller.FilterManager;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.schema.constants.ExpressionConstants;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueAssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueFilterType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InboundProcessor {
    public static final String PROCESS_INBOUND_HANDLING = String.valueOf(InboundProcessor.class.getName()) + ".processInbound";
    private static final Trace LOGGER = TraceManager.getTrace(InboundProcessor.class);
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private FilterManager<Filter> filterManager;
    @Autowired(required=true)
    private ValueConstructionFactory valueConstructionFactory;

    void processInbound(SyncContext context, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        OperationResult subResult = result.createSubresult(PROCESS_INBOUND_HANDLING);
        ObjectDelta userDelta = context.getUserSecondaryDelta();
        if (userDelta == null) {
            userDelta = new ObjectDelta(UserType.class, ChangeType.MODIFY);
            if (context.getUserOld() != null) {
                userDelta.setOid(context.getUserOld().getOid());
            }
            context.setUserSecondaryDelta((ObjectDelta<UserType>)userDelta);
        }
        if (ChangeType.DELETE.equals((Object)userDelta.getChangeType())) {
            return;
        }
        try {
            for (AccountSyncContext accountContext : context.getAccountContexts()) {
                ResourceAccountType rat = accountContext.getResourceAccountType();
                if (!accountContext.isDoReconciliation() && accountContext.getAccountSyncDelta() == null) {
                    LOGGER.trace("Skipping processing of inbound expressions for account {}: no reconciliation and no sync delta", (Object)rat);
                    continue;
                }
                RefinedAccountDefinition accountDefinition = context.getRefinedAccountDefinition(rat);
                if (accountDefinition == null) {
                    LOGGER.error("Definition for account type {} not found in the context, but it should be there, dumping context:\n{}", (Object)rat, (Object)context.dump());
                    throw new IllegalStateException("Definition for account type " + rat + " not found in the context, but it should be there");
                }
                if (accountContext.getAccountDelta() != null && ChangeType.DELETE.equals((Object)accountContext.getAccountDelta().getChangeType())) continue;
                this.processInboundExpressionsForAccount(context, accountContext, accountDefinition, result);
            }
            if (userDelta.isEmpty()) {
                context.setUserSecondaryDelta(null);
            }
        }
        finally {
            subResult.computeStatus();
        }
    }

    private void processInboundExpressionsForAccount(SyncContext context, AccountSyncContext accContext, RefinedAccountDefinition accountDefinition, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        if (accContext.getAccountSyncDelta() == null && accContext.getAccountOld() == null) {
            LOGGER.debug("Nothing to process in inbound, account sync delta and account old was null.");
            return;
        }
        ObjectDelta<UserType> userDelta = context.getUserSecondaryDelta();
        ObjectDelta<AccountShadowType> syncDelta = accContext.getAccountSyncDelta();
        PrismObject<AccountShadowType> oldAccount = accContext.getAccountOld();
        for (QName name : accountDefinition.getNamesOfAttributesWithInboundExpressions()) {
            PropertyDelta accountAttributeDelta = null;
            if (syncDelta != null && (accountAttributeDelta = syncDelta.findPropertyDelta(new PropertyPath(new QName[]{SchemaConstants.I_ATTRIBUTES}), name)) == null) {
                LOGGER.trace("Skipping inbound for {} in {}: Account sync delta exists, but doesn't have change for processed property.", (Object)name, (Object)accContext.getResourceAccountType());
                continue;
            }
            RefinedAttributeDefinition attrDef = accountDefinition.getAttributeDefinition(name);
            List inboundJaxbTypes = attrDef.getInboundAssignmentTypes();
            LOGGER.trace("Processing inbound for {} in {}; ({} expressions)", new Object[]{DebugUtil.prettyPrint((QName)name), accContext.getResourceAccountType(), inboundJaxbTypes != null ? inboundJaxbTypes.size() : 0});
            for (ValueAssignmentType inboundJaxbType : inboundJaxbTypes) {
                if (this.checkInitialSkip(inboundJaxbType, context.getUserNew())) {
                    LOGGER.debug("Skipping because of initial flag.");
                    continue;
                }
                PropertyDelta userPropertyDelta = null;
                if (syncDelta != null) {
                    LOGGER.debug("Processing inbound from account sync delta.");
                    userPropertyDelta = this.evaluateInboundExpressionFromDelta(inboundJaxbType, accountAttributeDelta, context.getUserNew(), result);
                } else if (oldAccount != null) {
                    if (!accContext.isFullAccount()) {
                        throw new SystemException("Attept to execute inbound expression on account shadow (not full account)");
                    }
                    LOGGER.debug("Processing inbound from account sync absolute state (oldAccount).");
                    PrismProperty oldAccountProperty = oldAccount.findProperty(new PropertyPath(new QName[]{AccountShadowType.F_ATTRIBUTES, name}));
                    userPropertyDelta = this.evaluateInboundExpressionFromAbsolute(inboundJaxbType, oldAccountProperty, context.getUserNew(), result);
                }
                if (userPropertyDelta != null && !userPropertyDelta.isEmpty()) {
                    LOGGER.trace("Created delta (from inbound expression) \n{}", new Object[]{userPropertyDelta.debugDump(3)});
                    userDelta.swallow(userPropertyDelta);
                    context.recomputeUserNew();
                    continue;
                }
                LOGGER.trace("Created delta (from inbound expression) was null or empty.");
            }
        }
        this.processCustomPropertyInbound(accountDefinition.getCredentialsInbound(), SchemaConstants.PATH_PASSWORD_VALUE, context.getUserNew(), accContext, accountDefinition, context, result);
        this.processCustomPropertyInbound(accountDefinition.getActivationInbound(), SchemaConstants.PATH_ACTIVATION_ENABLE, context.getUserNew(), accContext, accountDefinition, context, result);
    }

    private boolean checkInitialSkip(ValueAssignmentType inbound, PrismObject<UserType> newUser) {
        ValueConstructionType valueConstruction = inbound.getSource();
        if (valueConstruction == null) {
            return false;
        }
        boolean initial = valueConstruction.isInitial() == null ? false : valueConstruction.isInitial();
        PrismProperty property = newUser.findProperty(this.createUserPropertyPath(inbound));
        return initial && (property == null || property.isEmpty());
    }

    private <T> PropertyDelta<T> evaluateInboundExpressionFromAbsolute(ValueAssignmentType inbound, PrismProperty<T> oldAccountProperty, PrismObject<UserType> newUser, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        inbound.getValueFilter();
        if (oldAccountProperty != null && oldAccountProperty.hasRaw()) {
            throw new SystemException("Property " + oldAccountProperty + " has raw parsing state, such property cannot be used in inbound expressions");
        }
        PropertyPath targetUserPropertyPath = this.createUserPropertyPath(inbound);
        PrismProperty targetUserProperty = null;
        if (newUser != null) {
            targetUserProperty = newUser.findProperty(targetUserPropertyPath);
        }
        PrismPropertyDefinition targetPropertyDef = newUser.getDefinition().findPropertyDefinition(targetUserPropertyPath);
        PrismProperty sourceProperty = null;
        if (oldAccountProperty != null) {
            ValueConstructionType sourceValueConstructionType = inbound.getSource();
            ValueConstruction valueConstruction = null;
            valueConstruction = sourceValueConstructionType != null ? this.valueConstructionFactory.createValueConstruction(sourceValueConstructionType, (ItemDefinition)targetPropertyDef, "inbound expression for " + oldAccountProperty.getName()) : this.valueConstructionFactory.createDefaultValueConstruction((ItemDefinition)targetPropertyDef, "inbound expression for " + oldAccountProperty.getName());
            valueConstruction.setInput(oldAccountProperty);
            valueConstruction.setInputDelta(null);
            valueConstruction.setOutputDefinition((ItemDefinition)targetPropertyDef);
            valueConstruction.addVariableDefinition(ExpressionConstants.VAR_USER, newUser);
            valueConstruction.evaluate(result);
            valueConstruction.getOutputTriple();
            sourceProperty = (PrismProperty)valueConstruction.getOutput();
        }
        PropertyDelta delta = null;
        if (targetUserProperty != null) {
            LOGGER.trace("Simple property comparing user property {} to computed property {} ", new Object[]{targetUserProperty, sourceProperty});
            delta = targetUserProperty.diff(sourceProperty, targetUserPropertyPath);
            if (delta != null) {
                delta.setName(targetUserPropertyPath.last().getName());
                delta.setParentPath(targetUserPropertyPath.allExceptLast());
            }
        } else {
            if (sourceProperty != null) {
                LOGGER.trace("Adding user property because inbound say so (account doesn't contain that value)");
                delta = PropertyDelta.createDelta((PropertyPath)targetUserPropertyPath, (PrismObjectDefinition)newUser.getDefinition());
                delta.addValuesToAdd(sourceProperty.getClonedValues());
            }
            LOGGER.trace("We don't have to create delta, everything is alright.");
        }
        return delta;
    }

    private <T> PropertyDelta<T> evaluateInboundExpressionFromDelta(ValueAssignmentType inbound, PropertyDelta<T> accountAttributeDelta, PrismObject<UserType> newUser, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        PrismPropertyValue<T> filteredValue;
        List filters = inbound.getValueFilter();
        PropertyPath targetUserPropertyPath = this.createUserPropertyPath(inbound);
        PrismProperty targetUserProperty = newUser.findProperty(targetUserPropertyPath);
        PrismPropertyDefinition targetPropertyDef = newUser.getDefinition().findPropertyDefinition(targetUserPropertyPath);
        PropertyDelta delta = new PropertyDelta(targetUserPropertyPath, targetPropertyDef);
        PrismValueDeltaSetTriple triple = null;
        ValueConstructionType sourceValueConstructionType = inbound.getSource();
        ValueConstruction valueConstruction = null;
        valueConstruction = sourceValueConstructionType != null ? this.valueConstructionFactory.createValueConstruction(sourceValueConstructionType, (ItemDefinition)targetPropertyDef, "inbound expression for " + accountAttributeDelta.getName()) : this.valueConstructionFactory.createDefaultValueConstruction((ItemDefinition)targetPropertyDef, "inbound expression for " + accountAttributeDelta.getName());
        valueConstruction.setInput(null);
        valueConstruction.setInputDelta(accountAttributeDelta);
        valueConstruction.setOutputDefinition((ItemDefinition)targetPropertyDef);
        valueConstruction.addVariableDefinition(ExpressionConstants.VAR_USER, newUser);
        valueConstruction.evaluate(result);
        triple = valueConstruction.getOutputTriple();
        if (triple.getPlusSet() != null) {
            LOGGER.trace("Checking account sync property delta values to add");
            for (PrismPropertyValue value : triple.getPlusSet()) {
                filteredValue = this.filterValue(value, filters);
                if (targetUserProperty != null && targetUserProperty.hasRealValue(filteredValue)) continue;
                if (targetUserProperty != null && !targetUserProperty.getDefinition().isMultiValue() && !targetUserProperty.isEmpty()) {
                    ArrayList<PrismPropertyValue<T>> replace = new ArrayList<PrismPropertyValue<T>>();
                    replace.add(filteredValue);
                    delta.setValuesToReplace(replace);
                    continue;
                }
                delta.addValueToAdd(filteredValue);
            }
        }
        if (triple.getMinusSet() != null) {
            LOGGER.trace("Checking account sync property delta values to delete");
            for (PrismPropertyValue value : triple.getMinusSet()) {
                filteredValue = this.filterValue(value, filters);
                if (targetUserProperty != null && !targetUserProperty.hasRealValue(filteredValue)) continue;
                delta.addValueToDelete(filteredValue);
            }
        }
        return delta.getValues(Object.class).isEmpty() ? null : delta;
    }

    private PropertyPath createUserPropertyPath(ValueAssignmentType inbound) {
        PropertyPath path = new XPathHolder(inbound.getTarget()).toPropertyPath();
        List segments = path.getSegments();
        if (!segments.isEmpty() && SchemaConstants.I_USER.equals(((PropertyPathSegment)segments.get(0)).getName())) {
            segments.remove(0);
        }
        return path;
    }

    private <T> PrismPropertyValue<T> filterValue(PrismPropertyValue<T> propertyValue, List<ValueFilterType> filters) {
        PrismPropertyValue filteredValue = propertyValue.clone();
        filteredValue.setType(SourceType.INBOUND);
        if (filters == null || filters.isEmpty()) {
            return filteredValue;
        }
        for (ValueFilterType filter : filters) {
            Filter filterInstance = this.filterManager.getFilterInstance(filter.getType(), filter.getAny());
            filterInstance.apply(filteredValue);
        }
        return filteredValue;
    }

    private void processCustomPropertyInbound(ValueAssignmentType inbound, PropertyPath path, PrismObject<UserType> newUser, AccountSyncContext accContext, RefinedAccountDefinition accountDefinition, SyncContext context, OperationResult opResult) throws SchemaException {
        PrismProperty result;
        PropertyDelta primaryPropDelta;
        if (inbound == null || newUser == null) {
            return;
        }
        ValueConstructionType valueConstruction = inbound.getSource();
        boolean initial = valueConstruction.isInitial() == null ? false : valueConstruction.isInitial();
        PrismProperty property = newUser.findOrCreateProperty(path);
        if (initial && !property.isEmpty()) {
            return;
        }
        ObjectDelta<UserType> userPrimaryDelta = context.getUserPrimaryDelta();
        if (userPrimaryDelta != null && (primaryPropDelta = userPrimaryDelta.findPropertyDelta(path)) != null && primaryPropDelta.isReplace()) {
            return;
        }
        ObjectDelta<UserType> userSecondaryDelta = context.getUserSecondaryDelta();
        PropertyDelta delta = userSecondaryDelta.findPropertyDelta(path);
        if (delta != null) {
            userSecondaryDelta.getModifications().remove(delta);
        }
        if (accContext.getAccountNew() == null) {
            accContext.recomputeAccountNew();
            if (accContext.getAccountNew() == null) {
                String message = "Recomputing account " + accContext.getResourceAccountType() + " results in null new account. Something must be really broken.";
                LOGGER.error(message);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Account context:\n{}", (Object)accContext.dump());
                }
                throw new SystemException(message);
            }
        }
        PrismProperty input = accContext.getAccountNew().findProperty(path);
        try {
            ValueConstruction construction = this.valueConstructionFactory.createValueConstruction(valueConstruction, (ItemDefinition)property.getDefinition(), "Inbound value construction");
            construction.setInput((Item)input);
            construction.evaluate(opResult);
            result = (PrismProperty)construction.getOutput();
        }
        catch (SchemaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SchemaException(ex.getMessage(), (Throwable)ex);
        }
        delta = property.diff(result, path);
        if (delta != null && !delta.isEmpty()) {
            delta.setParentPath(path.allExceptLast());
            userSecondaryDelta.swallow((ItemDelta)delta);
        }
    }
}

