/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.api.PolicyViolationException;
import com.evolveum.midpoint.model.synchronizer.AccountConstruction;
import com.evolveum.midpoint.model.synchronizer.Assignment;
import com.evolveum.midpoint.model.synchronizer.AssignmentEvaluator;
import com.evolveum.midpoint.model.synchronizer.AssignmentPath;
import com.evolveum.midpoint.model.synchronizer.AssignmentPathSegment;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountSynchronizationSettingsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentPolicyEnforcementType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExclusionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class AssignmentProcessor {
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private ObjectResolver objectResolver;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private ValueConstructionFactory valueConstructionFactory;
    private static final Trace LOGGER = TraceManager.getTrace(AssignmentProcessor.class);

    public void processAssignmentsAccounts(SyncContext context, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException, PolicyViolationException {
        PrismContainer assignmentContainer;
        AssignmentPolicyEnforcementType assignmentPolicyEnforcement;
        AccountSynchronizationSettingsType accountSynchronizationSettings = context.getAccountSynchronizationSettings();
        if (accountSynchronizationSettings != null && (assignmentPolicyEnforcement = accountSynchronizationSettings.getAssignmentPolicyEnforcement()) == AssignmentPolicyEnforcementType.NONE) {
            LOGGER.trace("Assignment enforcement policy set to NONE, skipping assignment processing");
            for (AccountSyncContext accCtx : context.getAccountContexts()) {
                accCtx.setAssigned(true);
            }
            return;
        }
        ArrayList<PrismContainerValue<AssignmentType>> assignmentsOld = new ArrayList<PrismContainerValue<AssignmentType>>();
        if (context.getUserOld() != null && (assignmentContainer = context.getUserOld().findContainer(UserType.F_ASSIGNMENT)) != null) {
            assignmentsOld.addAll(assignmentContainer.getValues());
        }
        ContainerDelta<AssignmentType> assignmentDelta = context.getAssignmentDelta();
        LOGGER.trace("Assignment delta {}", (Object)assignmentDelta.dump());
        Collection changedAssignments = assignmentDelta.getValues(AssignmentType.class);
        AssignmentEvaluator assignmentEvaluator = new AssignmentEvaluator();
        assignmentEvaluator.setRepository(this.repositoryService);
        assignmentEvaluator.setUserOdo(context.getUserOdo());
        assignmentEvaluator.setObjectResolver(this.objectResolver);
        assignmentEvaluator.setPrismContext(this.prismContext);
        assignmentEvaluator.setValueConstructionFactory(this.valueConstructionFactory);
        HashMap<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>> zeroAccountMap = new HashMap<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>>();
        HashMap<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>> plusAccountMap = new HashMap<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>>();
        HashMap<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>> minusAccountMap = new HashMap<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>>();
        LOGGER.trace("Old assignments {}", (Object)SchemaDebugUtil.prettyPrint(assignmentsOld));
        LOGGER.trace("Changed assignments {}", (Object)SchemaDebugUtil.prettyPrint((Collection)changedAssignments));
        ObjectType source = null;
        if (context.getUserOld() != null) {
            source = (ObjectType)context.getUserOld().asObjectable();
        } else if (context.getUserNew() != null) {
            source = (ObjectType)context.getUserNew().asObjectable();
        }
        ArrayList<Assignment> evaluatedAssignmentsZero = new ArrayList<Assignment>();
        ArrayList<Assignment> evaluatedAssignmentsPlus = new ArrayList<Assignment>();
        Collection allAssignments = MiscUtil.union((Collection[])new Collection[]{assignmentsOld, changedAssignments});
        for (PrismContainerValue propertyValue : allAssignments) {
            AssignmentType assignmentType = (AssignmentType)propertyValue.asContainerable();
            boolean isAssignmentChanged = this.containsRealValue(changedAssignments, (PrismContainerValue<AssignmentType>)propertyValue);
            String assignmentPlacementDesc = isAssignmentChanged ? "delta for " + source : source.toString();
            LOGGER.trace("Processing assignment {}", (Object)SchemaDebugUtil.prettyPrint((AssignmentType)assignmentType));
            Assignment evaluatedAssignment = assignmentEvaluator.evaluate(assignmentType, source, assignmentPlacementDesc, result);
            context.rememberResources(evaluatedAssignment.getResources(result));
            if (isAssignmentChanged) {
                if (assignmentDelta.isValueToAdd((PrismValue)propertyValue)) {
                    if (this.containsRealValue(assignmentsOld, (PrismContainerValue<AssignmentType>)propertyValue)) {
                        this.collectToAccountMap(zeroAccountMap, evaluatedAssignment, result);
                        evaluatedAssignmentsZero.add(evaluatedAssignment);
                    }
                    this.collectToAccountMap(plusAccountMap, evaluatedAssignment, result);
                    evaluatedAssignmentsPlus.add(evaluatedAssignment);
                }
                if (!assignmentDelta.isValueToDelete((PrismValue)propertyValue)) continue;
                this.collectToAccountMap(minusAccountMap, evaluatedAssignment, result);
                continue;
            }
            this.collectToAccountMap(zeroAccountMap, evaluatedAssignment, result);
            evaluatedAssignmentsZero.add(evaluatedAssignment);
        }
        this.checkExclusions(context, evaluatedAssignmentsZero, evaluatedAssignmentsPlus);
        this.checkExclusions(context, evaluatedAssignmentsPlus, evaluatedAssignmentsPlus);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Account maps:\nZERO:\n{}\nPLUS:\n{}\nMINUS:\n{}\n", new Object[]{this.dumpAccountMap(zeroAccountMap), this.dumpAccountMap(plusAccountMap), this.dumpAccountMap(minusAccountMap)});
        }
        Collection allAccountTypes = MiscUtil.union((Collection[])new Collection[]{zeroAccountMap.keySet(), plusAccountMap.keySet(), minusAccountMap.keySet()});
        for (ResourceAccountType rat : allAccountTypes) {
            if (rat.getResourceOid() == null) {
                throw new IllegalStateException("Resource OID null in ResourceAccountType during assignment processing");
            }
            if (rat.getAccountType() == null) {
                throw new IllegalStateException("Account type is null in ResourceAccountType during assignment processing");
            }
            if (zeroAccountMap.containsKey(rat)) {
                AccountSyncContext accountSyncContext = context.getAccountSyncContext(rat);
                if (accountSyncContext == null) {
                    this.markPolicyDecision(context, rat, PolicyDecision.ADD);
                    context.getAccountSyncContext(rat).setAssigned(true);
                } else {
                    accountSyncContext.setAssigned(true);
                    this.markPolicyDecision(context, rat, PolicyDecision.KEEP);
                }
            } else {
                if (plusAccountMap.containsKey(rat) && minusAccountMap.containsKey(rat)) {
                    context.getAccountSyncContext(rat).setAssigned(true);
                    throw new UnsupportedOperationException("add+delete of account is not supported yet");
                }
                if (plusAccountMap.containsKey(rat)) {
                    if (this.accountExists(context, rat)) {
                        this.markPolicyDecision(context, rat, PolicyDecision.KEEP);
                    } else {
                        this.markPolicyDecision(context, rat, PolicyDecision.ADD);
                    }
                    context.getAccountSyncContext(rat).setAssigned(true);
                } else if (minusAccountMap.containsKey(rat)) {
                    context.getAccountSyncContext(rat).setAssigned(false);
                    this.markPolicyDecision(context, rat, PolicyDecision.DELETE);
                } else {
                    throw new IllegalStateException("Account " + rat + " went looney");
                }
            }
            PrismValueDeltaSetTriple accountDeltaSetTriple = new PrismValueDeltaSetTriple((Collection)zeroAccountMap.get(rat), (Collection)plusAccountMap.get(rat), (Collection)minusAccountMap.get(rat));
            context.getAccountSyncContext(rat).setAccountConstructionDeltaSetTriple((PrismValueDeltaSetTriple<PrismPropertyValue<AccountConstruction>>)accountDeltaSetTriple);
        }
        this.finishProplicyDecisions(context);
    }

    private void finishProplicyDecisions(SyncContext context) {
        for (AccountSyncContext accountContext : context.getAccountContexts()) {
            ObjectDelta<AccountShadowType> accountSyncDelta;
            if (accountContext.getPolicyDecision() != null || (accountSyncDelta = accountContext.getAccountSyncDelta()) == null) continue;
            if (accountSyncDelta.isDelete()) {
                accountContext.setPolicyDecision(PolicyDecision.UNLINK);
                continue;
            }
            accountContext.setPolicyDecision(PolicyDecision.DELETE);
        }
    }

    private boolean containsRealValue(Collection<PrismContainerValue<AssignmentType>> assignmentValuesCollection, PrismContainerValue<AssignmentType> assignmentValue) {
        for (PrismContainerValue<AssignmentType> colValue : assignmentValuesCollection) {
            if (!colValue.equalsRealValue(assignmentValue)) continue;
            return true;
        }
        return false;
    }

    public void processAssignmentsAccountValues(AccountSyncContext accountContext, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
    }

    private void collectToAccountMap(Map<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>> accountMap, Assignment evaluatedAssignment, OperationResult result) throws ObjectNotFoundException, SchemaException {
        for (AccountConstruction accountConstruction : evaluatedAssignment.getAccountConstructions()) {
            String resourceOid = accountConstruction.getResource(result).getOid();
            String accountType = accountConstruction.getAccountType();
            ResourceAccountType rat = new ResourceAccountType(resourceOid, accountType);
            Collection<Object> constructions = null;
            if (accountMap.containsKey(rat)) {
                constructions = accountMap.get(rat);
            } else {
                constructions = new ArrayList();
                accountMap.put(rat, constructions);
            }
            constructions.add(new PrismPropertyValue((Object)accountConstruction));
        }
    }

    private String dumpAccountMap(Map<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>> accountMap) {
        StringBuilder sb = new StringBuilder();
        Set<Map.Entry<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>>> entrySet = accountMap.entrySet();
        Iterator<Map.Entry<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>>> i = entrySet.iterator();
        while (i.hasNext()) {
            Map.Entry<ResourceAccountType, Collection<PrismPropertyValue<AccountConstruction>>> entry = i.next();
            sb.append(entry.getKey()).append(": ");
            sb.append(SchemaDebugUtil.prettyPrint(entry.getValue()));
            if (!i.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private boolean accountExists(SyncContext context, ResourceAccountType rat) {
        AccountSyncContext accountSyncContext = context.getAccountSyncContext(rat);
        if (accountSyncContext == null) {
            return false;
        }
        return accountSyncContext.getAccountOld() != null;
    }

    private void markPolicyDecision(SyncContext context, ResourceAccountType rat, PolicyDecision decision) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        AccountSyncContext accountSyncContext = context.getAccountSyncContext(rat);
        if (accountSyncContext == null) {
            accountSyncContext = context.createAccountSyncContext(rat);
        }
        if (accountSyncContext.getPolicyDecision() == null) {
            accountSyncContext.setPolicyDecision(decision);
        }
    }

    private void checkExclusions(SyncContext context, Collection<Assignment> assignmentsA, Collection<Assignment> assignmentsB) throws PolicyViolationException {
        for (Assignment assignmentA : assignmentsA) {
            this.checkExclusion(context, assignmentA, assignmentsB);
        }
    }

    private void checkExclusion(SyncContext context, Assignment assignmentA, Collection<Assignment> assignmentsB) throws PolicyViolationException {
        for (Assignment assignmentB : assignmentsB) {
            this.checkExclusion(context, assignmentA, assignmentB);
        }
    }

    private void checkExclusion(SyncContext context, Assignment assignmentA, Assignment assignmentB) throws PolicyViolationException {
        if (assignmentA == assignmentB) {
            return;
        }
        for (AccountConstruction constructionA : assignmentA.getAccountConstructions()) {
            for (AccountConstruction constructionB : assignmentB.getAccountConstructions()) {
                this.checkExclusion(constructionA, assignmentA, constructionB, assignmentB);
            }
        }
    }

    private void checkExclusion(AccountConstruction constructionA, Assignment assignmentA, AccountConstruction constructionB, Assignment assignmentB) throws PolicyViolationException {
        AssignmentPath pathA = constructionA.getAssignmentPath();
        AssignmentPath pathB = constructionB.getAssignmentPath();
        for (AssignmentPathSegment segmentA : pathA.getSegments()) {
            if (segmentA.getTarget() == null || !(segmentA.getTarget() instanceof RoleType)) continue;
            for (AssignmentPathSegment segmentB : pathB.getSegments()) {
                if (segmentB.getTarget() == null || !(segmentB.getTarget() instanceof RoleType)) continue;
                this.checkExclusion((RoleType)segmentA.getTarget(), (RoleType)segmentB.getTarget());
            }
        }
    }

    private void checkExclusion(RoleType roleA, RoleType roleB) throws PolicyViolationException {
        this.checkExclusionOneWay(roleA, roleB);
        this.checkExclusionOneWay(roleB, roleA);
    }

    private void checkExclusionOneWay(RoleType roleA, RoleType roleB) throws PolicyViolationException {
        for (ExclusionType exclusionA : roleA.getExclusion()) {
            ObjectReferenceType targetRef = exclusionA.getTargetRef();
            if (!roleB.getOid().equals(targetRef.getOid())) continue;
            throw new PolicyViolationException("Violation of SoD policy: " + roleA + " excludes " + roleB + ", they cannot be assigned at the same time");
        }
    }
}

