/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.security;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.model.security.RepositoryException;
import com.evolveum.midpoint.model.security.api.PrincipalUser;
import com.evolveum.midpoint.model.security.api.UserDetailsService;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.List;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Service(value="userDetailsService")
public class UserDetailsServiceImpl
implements UserDetailsService {
    private static final Trace LOGGER = TraceManager.getTrace(UserDetailsServiceImpl.class);
    @Autowired(required=true)
    private transient RepositoryService repositoryService;

    public PrincipalUser getUser(String principal) {
        PrincipalUser user = null;
        try {
            user = this.findByUsername(principal);
        }
        catch (Exception ex) {
            LOGGER.warn("Couldn't find user with name '{}', reason: {}.", new Object[]{principal, ex.getMessage()});
        }
        return user;
    }

    public void updateUser(PrincipalUser user) {
        try {
            this.save(user);
        }
        catch (RepositoryException ex) {
            LOGGER.warn("Couldn't save user '{}, ({})', reason: {}.", new Object[]{user.getFullName(), user.getOid(), ex.getMessage()});
        }
    }

    private PrincipalUser findByUsername(String username) throws SchemaException, ObjectNotFoundException {
        QueryType query = new QueryType();
        query.setFilter(this.createQuery(username));
        LOGGER.trace("Looking for user, query:\n" + DOMUtil.printDom((Node)query.getFilter()));
        List list = this.repositoryService.searchObjects(UserType.class, query, new PagingType(), new OperationResult("Find by username"));
        if (list == null) {
            return null;
        }
        LOGGER.trace("Users found: {}.", new Object[]{list.size()});
        if (list.size() == 0 || list.size() > 1) {
            return null;
        }
        return this.createUser((UserType)((PrismObject)list.get(0)).asObjectable());
    }

    private PrincipalUser createUser(UserType userType) {
        return new PrincipalUser(userType);
    }

    private Element createQuery(String username) throws SchemaException {
        return QueryUtil.createEqualFilter((Document)DOMUtil.getDocument(), null, (QName)ObjectType.F_NAME, (String)username);
    }

    private PrincipalUser save(PrincipalUser person) throws RepositoryException {
        try {
            UserType oldUserType = this.getUserByOid(person.getOid());
            PrismObject oldUser = oldUserType.asPrismObject();
            PrismObject newUser = person.getUser().asPrismObject();
            ObjectDelta delta = oldUser.diff(newUser);
            this.repositoryService.modifyObject(UserType.class, delta.getOid(), delta.getModifications(), new OperationResult(UserDetailsService.OPERATION_UPDATE_USER));
        }
        catch (Exception ex) {
            throw new RepositoryException(ex.getMessage(), ex);
        }
        return person;
    }

    private UserType getUserByOid(String oid) throws ObjectNotFoundException, SchemaException {
        ObjectType object = (ObjectType)this.repositoryService.getObject(UserType.class, oid, new OperationResult(UserDetailsService.OPERATION_GET_USER)).asObjectable();
        if (object != null && object instanceof UserType) {
            return (UserType)object;
        }
        return null;
    }
}

