/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.importer;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.common.crypto.EncryptionException;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.common.validator.EventHandler;
import com.evolveum.midpoint.common.validator.EventResult;
import com.evolveum.midpoint.common.validator.Validator;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.Visitable;
import com.evolveum.midpoint.prism.Visitor;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.schema.util.ConnectorTypeUtil;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.task.api.LightweightIdentifierGenerator;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ImportOptionsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class ObjectImporter {
    private static final Trace LOGGER = TraceManager.getTrace(ObjectImporter.class);
    private static final String OPERATION_RESOLVE_REFERENCE = String.valueOf(ObjectImporter.class.getName()) + ".resolveReference";
    @Autowired(required=true)
    private Protector protector;
    @Autowired(required=true)
    private LightweightIdentifierGenerator lightweightIdentifierGenerator;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private TaskManager taskManager;

    public void importObjects(InputStream input, final ImportOptionsType options, Task task, OperationResult parentResult, final RepositoryService repository) {
        EventHandler handler = new EventHandler(){

            public EventResult preMarshall(Element objectElement, Node postValidationTree, OperationResult objectResult) {
                return EventResult.cont();
            }

            public <T extends Objectable> EventResult postMarshall(PrismObject<T> prismObjectObjectable, Element objectElement, OperationResult objectResult) {
                LOGGER.debug("Importing object {}", prismObjectObjectable);
                Objectable objectable = prismObjectObjectable.asObjectable();
                if (!(objectable instanceof ObjectType)) {
                    String message = "Cannot process type " + objectable.getClass() + " as it is not a subtype of " + ObjectType.class;
                    objectResult.recordFatalError(message);
                    LOGGER.error("Import of object {} failed: {}", new Object[]{prismObjectObjectable, message});
                    return EventResult.skipObject();
                }
                ObjectType cfr_ignored_0 = (ObjectType)objectable;
                PrismObject<T> object = prismObjectObjectable;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("IMPORTING object:\n{}", (Object)object.dump());
                }
                ObjectImporter.this.resolveReferences(object, repository, options.isReferentialIntegrity() == null ? false : options.isReferentialIntegrity(), objectResult);
                objectResult.computeStatus();
                if (!objectResult.isAcceptable()) {
                    return EventResult.skipObject((String)objectResult.getMessage());
                }
                ObjectImporter.this.generateIdentifiers(object, repository, objectResult);
                objectResult.computeStatus();
                if (!objectResult.isAcceptable()) {
                    return EventResult.skipObject((String)objectResult.getMessage());
                }
                if (BooleanUtils.isTrue((Boolean)options.isValidateDynamicSchema())) {
                    ObjectImporter.this.validateWithDynamicSchemas(object, objectElement, repository, objectResult);
                }
                objectResult.computeStatus();
                if (!objectResult.isAcceptable()) {
                    return EventResult.skipObject((String)objectResult.getMessage());
                }
                if (BooleanUtils.isTrue((Boolean)options.isEncryptProtectedValues())) {
                    ObjectImporter.this.encryptValues(object, objectResult);
                }
                objectResult.computeStatus();
                if (!objectResult.isAcceptable()) {
                    return EventResult.skipObject((String)objectResult.getMessage());
                }
                try {
                    ObjectImporter.this.importObjectToRepository(object, options, repository, objectResult);
                    LOGGER.info("Imported object {}", object);
                }
                catch (SchemaException e) {
                    objectResult.recordFatalError("Schema violation: " + e.getMessage(), (Throwable)e);
                    LOGGER.error("Import of object {} failed: Schema violation: {}", new Object[]{object, e.getMessage(), e});
                }
                catch (ObjectAlreadyExistsException e) {
                    objectResult.recordFatalError("Object already exists: " + e.getMessage(), (Throwable)e);
                    LOGGER.error("Import of object {} failed: Object already exists: {}", new Object[]{object, e.getMessage(), e});
                    LOGGER.error("Object already exists", (Throwable)e);
                }
                catch (RuntimeException e) {
                    objectResult.recordFatalError("Unexpected problem: " + e.getMessage(), (Throwable)e);
                    LOGGER.error("Import of object {} failed: Unexpected problem: {}", new Object[]{object, e.getMessage(), e});
                }
                objectResult.recordSuccessIfUnknown();
                if (objectResult.isAcceptable()) {
                    return EventResult.cont();
                }
                return EventResult.skipObject((String)objectResult.getMessage());
            }

            public void handleGlobalError(OperationResult currentResult) {
            }
        };
        Validator validator = new Validator(this.prismContext, handler);
        validator.setVerbose(true);
        validator.setValidateSchema(BooleanUtils.isTrue((Boolean)options.isValidateStaticSchema()));
        if (options.getStopAfterErrors() != null) {
            validator.setStopAfterErrors(options.getStopAfterErrors().longValue());
        }
        if (options.isSummarizeErrors().booleanValue()) {
            parentResult.setSummarizeErrors(true);
        }
        if (options.isSummarizeSucceses().booleanValue()) {
            parentResult.setSummarizeSuccesses(true);
        }
        validator.validate(input, parentResult, "com.evolveum.midpoint.common.operation.import.object");
    }

    private <T extends ObjectType> void importObjectToRepository(PrismObject<T> object, ImportOptionsType options, RepositoryService repository, OperationResult objectResult) throws SchemaException, ObjectAlreadyExistsException {
        OperationResult result = objectResult.createSubresult(String.valueOf(ObjectImporter.class.getName()) + ".importObjectToRepository");
        try {
            repository.addObject(object, result);
            if (object.canRepresent(TaskType.class)) {
                this.taskManager.onTaskCreate(object.getOid(), result);
            }
            result.recordSuccess();
        }
        catch (ObjectAlreadyExistsException e) {
            if (BooleanUtils.isTrue((Boolean)options.isOverwrite())) {
                String deletedOid = this.deleteObject(object, repository, result);
                if (deletedOid != null) {
                    if (object.canRepresent(TaskType.class)) {
                        this.taskManager.onTaskDelete(deletedOid, result);
                    }
                    if (BooleanUtils.isTrue((Boolean)options.isKeepOid())) {
                        object.setOid(deletedOid);
                    }
                    repository.addObject(object, result);
                    if (object.canRepresent(TaskType.class)) {
                        this.taskManager.onTaskCreate(object.getOid(), result);
                    }
                    result.recordSuccess();
                }
                result.recordFatalError("Object already exists, cannot overwrite", (Throwable)e);
                throw e;
            }
            result.recordFatalError("Object already exists", (Throwable)e);
            throw e;
        }
    }

    private <T extends ObjectType> String deleteObject(PrismObject<T> object, RepositoryService repository, OperationResult objectResult) throws SchemaException {
        if (!StringUtils.isBlank((String)object.getOid())) {
            try {
                repository.deleteObject(object.getCompileTimeClass(), object.getOid(), objectResult);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                return null;
            }
            return object.getOid();
        }
        QueryType query = QueryUtil.createNameQuery((ObjectType)((ObjectType)object.asObjectable()));
        List objects = repository.searchObjects(object.getCompileTimeClass(), query, null, objectResult);
        if (objects.size() != 1) {
            return null;
        }
        String oidToDelete = ((PrismObject)objects.get(0)).getOid();
        try {
            repository.deleteObject(object.getCompileTimeClass(), oidToDelete, objectResult);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            return null;
        }
        return oidToDelete;
    }

    protected <T extends ObjectType> void validateWithDynamicSchemas(PrismObject<T> object, Element objectElement, RepositoryService repository, OperationResult objectResult) {
        if (object.canRepresent(ConnectorType.class)) {
            ConnectorType connector = (ConnectorType)object.asObjectable();
            this.checkSchema(connector.getSchema(), "connector", objectResult);
            objectResult.computeStatus("Connector schema error");
        } else if (object.canRepresent(ResourceType.class)) {
            PrismObject<T> resource = object;
            ResourceType resourceType = (ResourceType)resource.asObjectable();
            PrismContainer configurationContainer = ResourceTypeUtil.getConfigurationContainer(resource);
            if (configurationContainer == null || configurationContainer.isEmpty()) {
                objectResult.recordWarning("The resource has no configuration");
                return;
            }
            String connectorOid = resourceType.getConnectorRef().getOid();
            if (StringUtils.isBlank((String)connectorOid)) {
                objectResult.recordFatalError("The connector reference (connectorRef) is null or empty");
                return;
            }
            PrismObject connector = null;
            ConnectorType connectorType = null;
            try {
                connector = repository.getObject(ConnectorType.class, connectorOid, objectResult);
                connectorType = (ConnectorType)connector.asObjectable();
            }
            catch (ObjectNotFoundException e) {
                objectResult.recordFatalError("Connector (OID:" + connectorOid + ") referenced from the resource is not in the repository", (Throwable)e);
                return;
            }
            catch (SchemaException e) {
                objectResult.recordPartialError("Connector (OID:" + connectorOid + ") referenced from the resource has schema problems: " + e.getMessage(), (Throwable)e);
                LOGGER.error("Connector (OID:{}) referenced from the imported resource \"{}\" has schema problems: {}", new Object[]{connectorOid, resourceType.getName(), e.getMessage(), e});
                return;
            }
            Element connectorSchemaElement = ConnectorTypeUtil.getConnectorXsdSchema((PrismObject)connector);
            PrismSchema connectorSchema = null;
            if (connectorSchemaElement == null) {
                return;
            }
            try {
                connectorSchema = PrismSchema.parse((Element)connectorSchemaElement, (String)("schema for " + connector), (PrismContext)this.prismContext);
            }
            catch (SchemaException e) {
                objectResult.recordFatalError("Error parsing connector schema for " + connector + ": " + e.getMessage(), (Throwable)e);
                return;
            }
            QName configContainerQName = new QName(connectorType.getNamespace(), ResourceType.F_CONFIGURATION.getLocalPart());
            PrismContainerDefinition configContainerDef = connectorSchema.findContainerDefinitionByElementName(configContainerQName);
            if (configContainerDef == null) {
                objectResult.recordFatalError("Definition of configuration container " + configContainerQName + " not found in the schema of of " + connector);
                return;
            }
            try {
                configurationContainer.applyDefinition((ItemDefinition)configContainerDef);
            }
            catch (SchemaException e) {
                objectResult.recordFatalError("Configuration error in " + resource + ": " + e.getMessage(), (Throwable)e);
                return;
            }
            this.checkSchema(resourceType.getSchema(), "resource", objectResult);
            objectResult.computeStatus("Dynamic schema error");
        } else {
            object.canRepresent(ResourceObjectShadowType.class);
        }
    }

    private void checkSchema(XmlSchemaType dynamicSchema, String schemaName, OperationResult objectResult) {
        OperationResult result = objectResult.createSubresult(String.valueOf(ObjectImporter.class.getName()) + ".check" + StringUtils.capitalize((String)schemaName) + "Schema");
        Element xsdElement = ObjectTypeUtil.findXsdElement((XmlSchemaType)dynamicSchema);
        if (dynamicSchema == null || xsdElement == null) {
            result.recordStatus(OperationResultStatus.NOT_APPLICABLE, "Missing dynamic " + schemaName + " schema");
            return;
        }
        try {
            PrismSchema.parse((Element)xsdElement, (String)schemaName, (PrismContext)this.prismContext);
        }
        catch (SchemaException e) {
            result.recordFatalError("Error during " + schemaName + " schema integrity check: " + e.getMessage(), (Throwable)e);
            return;
        }
        result.recordSuccess();
    }

    private PrismContainer validateDynamicSchema(List<Object> contentElements, QName elementRef, XmlSchemaType dynamicSchema, String schemaName, OperationResult objectResult) {
        OperationResult result = objectResult.createSubresult(String.valueOf(ObjectImporter.class.getName()) + ".validate" + StringUtils.capitalize((String)schemaName) + "Schema");
        Element xsdElement = ObjectTypeUtil.findXsdElement((XmlSchemaType)dynamicSchema);
        if (xsdElement == null) {
            result.recordStatus(OperationResultStatus.NOT_APPLICABLE, "No " + schemaName + " schema present");
            return null;
        }
        PrismSchema schema = null;
        try {
            schema = PrismSchema.parse((Element)xsdElement, (String)schemaName, (PrismContext)this.prismContext);
        }
        catch (SchemaException e) {
            result.recordFatalError("Error during " + schemaName + " schema parsing: " + e.getMessage(), (Throwable)e);
            LOGGER.trace("Validation error: {}" + e.getMessage());
            return null;
        }
        PrismContainerDefinition cfr_ignored_0 = (PrismContainerDefinition)schema.findItemDefinition(elementRef, PrismContainerDefinition.class);
        PrismContainer propertyContainer = null;
        result.recordSuccess();
        return propertyContainer;
    }

    protected <T extends ObjectType> void resolveReferences(PrismObject<T> object, final RepositoryService repository, final boolean enforceReferentialIntegrity, final OperationResult result) {
        Visitor visitor = new Visitor(){

            public void visit(Visitable visitable) {
                if (!(visitable instanceof PrismReferenceValue)) {
                    return;
                }
                ObjectImporter.this.resolveRef((PrismReferenceValue)visitable, repository, enforceReferentialIntegrity, result);
            }
        };
        object.accept(visitor);
    }

    private void resolveRef(PrismReferenceValue refVal, RepositoryService repository, boolean enforceReferentialIntegrity, OperationResult parentResult) {
        PrismReferenceDefinition definition;
        PrismReference reference = (PrismReference)refVal.getParent();
        QName refName = reference.getName();
        OperationResult result = parentResult.createSubresult(OPERATION_RESOLVE_REFERENCE);
        result.addContext("item", (Object)refName);
        QName typeQName = null;
        if (refVal.getTargetType() != null) {
            typeQName = refVal.getTargetType();
        }
        if (typeQName == null && (definition = (PrismReferenceDefinition)refVal.getParent().getDefinition()) != null) {
            typeQName = definition.getTargetTypeName();
        }
        Class<ObjectType> type = ObjectType.class;
        if (typeQName != null && (type = this.prismContext.getSchemaRegistry().determineCompileTimeClass(typeQName)) == null) {
            result.recordWarning("Unknown type specified in reference or definition of reference " + refName + ": " + typeQName);
            type = ObjectType.class;
        }
        Element filter = refVal.getFilter();
        if (!StringUtils.isBlank((String)refVal.getOid())) {
            if (filter != null) {
                result.appendDetail("Both OID and filter for property " + refName);
                result.recordPartialError("Both OID and filter for property " + refName);
                refVal.setFilter(null);
            }
            PrismObject object = null;
            try {
                object = repository.getObject((Class)type, refVal.getOid(), result);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                String message = "Reference " + refName + " refers to a non-existing object " + refVal.getOid();
                if (enforceReferentialIntegrity) {
                    LOGGER.error(message);
                    result.recordFatalError(message);
                } else {
                    LOGGER.warn(message);
                    result.recordWarning(message);
                }
            }
            catch (SchemaException e) {
                result.recordPartialError("Schema error while trying to retrieve object " + refVal.getOid() + " : " + e.getMessage(), (Throwable)e);
                LOGGER.error("Schema error while trying to retrieve object " + refVal.getOid() + " : " + e.getMessage(), (Throwable)e);
            }
            if (object != null && refVal.getType() != null && !object.getClass().equals(type)) {
                result.recordWarning("Type mismatch on property " + refName + ": declared:" + refVal.getType() + ", actual: " + object.getClass());
            }
            result.recordSuccessIfUnknown();
            parentResult.computeStatus();
            return;
        }
        if (filter == null) {
            result.recordFatalError("Neither OID nor filter for property " + refName + ": cannot resolve reference");
            return;
        }
        LOGGER.trace("Resolving using filter {}", (Object)DOMUtil.serializeDOMToString((Node)filter));
        NodeList childNodes = filter.getChildNodes();
        if (childNodes.getLength() == 0) {
            result.recordFatalError("OID not specified and filter is empty for property " + refName);
            return;
        }
        QueryType query = new QueryType();
        query.setFilter(filter);
        List objects = null;
        QName objectType = refVal.getTargetType();
        if (objectType == null) {
            result.recordFatalError("Missing definition of type of reference " + refName);
            return;
        }
        try {
            objects = repository.searchObjects(type, query, null, result);
        }
        catch (SchemaException e) {
            result.recordFatalError("Repository schema error during resolution of reference " + refName, (Throwable)e);
            return;
        }
        catch (SystemException e) {
            result.recordFatalError("Repository system error during resolution of reference " + refName, (Throwable)e);
            return;
        }
        if (objects.isEmpty()) {
            result.recordFatalError("Repository reference " + refName + " cannot be resolved: filter matches no object");
            return;
        }
        if (objects.size() > 1) {
            result.recordFatalError("Repository reference " + refName + " cannot be resolved: filter matches " + objects.size() + " objects");
            return;
        }
        String oid = ((PrismObject)objects.get(0)).getOid();
        refVal.setOid(oid);
        result.recordSuccessIfUnknown();
    }

    private <T extends ObjectType> void generateIdentifiers(PrismObject<T> object, RepositoryService repository, OperationResult objectResult) {
        TaskType task;
        if (object.canRepresent(TaskType.class) && ((task = (TaskType)object.asObjectable()).getTaskIdentifier() == null || task.getTaskIdentifier().isEmpty())) {
            task.setTaskIdentifier(this.lightweightIdentifierGenerator.generate().toString());
        }
    }

    private <T extends ObjectType> void encryptValues(final PrismObject<T> object, OperationResult objectResult) {
        final OperationResult result = objectResult.createSubresult(String.valueOf(ObjectImporter.class.getName()) + ".encryptValues");
        Visitor visitor = new Visitor(){

            public void visit(Visitable visitable) {
                if (!(visitable instanceof PrismPropertyValue)) {
                    return;
                }
                PrismPropertyValue pval = (PrismPropertyValue)visitable;
                ObjectImporter.this.encryptValue(object, pval, result);
            }
        };
        object.accept(visitor);
        result.recordSuccessIfUnknown();
    }

    private <T extends ObjectType> void encryptValue(PrismObject<T> object, PrismPropertyValue pval, OperationResult result) {
        Itemable item = pval.getParent();
        if (item == null) {
            return;
        }
        ItemDefinition itemDef = item.getDefinition();
        if (itemDef == null || itemDef.getTypeName() == null) {
            return;
        }
        if (!itemDef.getTypeName().equals(ProtectedStringType.COMPLEX_TYPE)) {
            return;
        }
        QName propName = item.getName();
        PrismPropertyValue psPval = pval;
        ProtectedStringType ps = (ProtectedStringType)psPval.getValue();
        if (ps.getClearValue() != null) {
            try {
                LOGGER.info("Encrypting cleartext value for field " + propName + " while importing " + object);
                this.protector.encrypt(ps);
            }
            catch (EncryptionException e) {
                LOGGER.info("Faild to encrypt cleartext value for field " + propName + " while importing " + object);
                result.recordFatalError("Faild to encrypt value for field " + propName + ": " + e.getMessage(), (Throwable)e);
                return;
            }
        }
    }
}

