/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.expr;

import com.evolveum.midpoint.common.expression.Expression;
import com.evolveum.midpoint.common.expression.ExpressionEvaluator;
import com.evolveum.midpoint.common.expression.ExpressionFactory;
import com.evolveum.midpoint.common.expression.xpath.XPathExpressionEvaluator;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.ModelObjectResolver;
import com.evolveum.midpoint.model.controller.ModelController;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExpressionHandler {
    @Autowired(required=true)
    private ModelController model;
    @Autowired(required=true)
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private ExpressionFactory expressionFactory;
    @Autowired(required=true)
    private ModelObjectResolver modelObjectResolver;
    @Autowired(required=true)
    private PrismContext prismContext;
    private XPathExpressionEvaluator xpathEvaluator = null;

    private ModelController getModel() {
        if (this.model == null) {
            throw new IllegalStateException("Model controller is null. Please set model  property before using expression handler.");
        }
        return this.model;
    }

    public String evaluateExpression(ResourceObjectShadowType shadow, ExpressionType expressionType, String shortDesc, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Validate.notNull((Object)shadow, (String)"Resource object shadow must not be null.");
        Validate.notNull((Object)expressionType, (String)"Expression must not be null.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        ResourceType resource = this.resolveResource(shadow, result);
        Map<QName, Object> variables = ExpressionHandler.getDefaultXPathVariables(null, shadow, resource);
        Expression expression = this.expressionFactory.createExpression(expressionType, shortDesc);
        expression.addVariableDefinitions(variables);
        PrismPropertyValue value = expression.evaluateScalar(String.class, result);
        return value != null ? (String)value.getValue() : null;
    }

    public boolean evaluateConfirmationExpression(UserType user, ResourceObjectShadowType shadow, ExpressionType expressionType, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Validate.notNull((Object)user, (String)"User must not be null.");
        Validate.notNull((Object)shadow, (String)"Resource object shadow must not be null.");
        Validate.notNull((Object)expressionType, (String)"Expression must not be null.");
        Validate.notNull((Object)result, (String)"Operation result must not be null.");
        ResourceType resource = this.resolveResource(shadow, result);
        Map<QName, Object> variables = ExpressionHandler.getDefaultXPathVariables(user, shadow, resource);
        Expression expression = this.expressionFactory.createExpression(expressionType, "Confiration expression for " + resource.asPrismObject());
        expression.addVariableDefinitions(variables);
        String expressionResult = (String)expression.evaluateScalar(String.class, result).getValue();
        return Boolean.valueOf(expressionResult);
    }

    private ResourceType resolveResource(ResourceObjectShadowType shadow, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        if (shadow.getResource() != null) {
            return shadow.getResource();
        }
        ObjectReferenceType ref = shadow.getResourceRef();
        if (ref == null) {
            throw new ExpressionEvaluationException("Resource shadow object " + shadow + " doesn't have defined resource.");
        }
        if (ref.getOid() == null) {
            throw new ExpressionEvaluationException("Resource shadow object " + shadow + " defines null resource OID.");
        }
        return this.modelObjectResolver.getObject(ResourceType.class, ref.getOid(), result);
    }

    public static Map<QName, Object> getDefaultXPathVariables(UserType user, ResourceObjectShadowType shadow, ResourceType resource) {
        HashMap<QName, Object> variables = new HashMap<QName, Object>();
        if (user != null) {
            variables.put(SchemaConstants.I_USER, user.asPrismObject());
        }
        if (shadow != null) {
            variables.put(SchemaConstants.I_ACCOUNT, shadow.asPrismObject());
        }
        if (resource != null) {
            variables.put(SchemaConstants.I_RESOURCE, resource.asPrismObject());
        }
        return variables;
    }

    public ObjectType resolveRef(ObjectReferenceType ref, String contextDescription, OperationResult result) throws ObjectNotFoundException, SchemaException {
        Class type = ObjectType.class;
        if (ref.getType() != null) {
            ObjectTypes objectTypeType = ObjectTypes.getObjectTypeFromTypeQName((QName)ref.getType());
            type = objectTypeType.getClassDefinition();
        }
        return (ObjectType)this.repositoryService.getObject(type, ref.getOid(), result).asObjectable();
    }

    public ValueConstructionFactory createValueConstructionFactory(ObjectResolver resolver) {
        ExpressionFactory expressionFactory = new ExpressionFactory(this.prismContext);
        this.registerEvaluators(expressionFactory);
        expressionFactory.setObjectResolver(resolver);
        ValueConstructionFactory valueConstructionFactory = new ValueConstructionFactory();
        valueConstructionFactory.setExpressionFactory(expressionFactory);
        valueConstructionFactory.setObjectResolver(resolver);
        valueConstructionFactory.setPrismContext(this.prismContext);
        return valueConstructionFactory;
    }

    public void registerEvaluators(ExpressionFactory expressionFactory) {
        if (this.xpathEvaluator == null) {
            this.xpathEvaluator = new XPathExpressionEvaluator(this.prismContext);
        }
        expressionFactory.registerEvaluator(XPathExpressionEvaluator.XPATH_LANGUAGE_URL, (ExpressionEvaluator)this.xpathEvaluator);
    }
}

