/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.exception.CommonException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelObjectResolver
implements ObjectResolver {
    @Autowired(required=true)
    private transient ProvisioningService provisioning;
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private transient RepositoryService cacheRepositoryService;
    @Autowired(required=true)
    private transient PrismContext prismContext;
    private static final Trace LOGGER = TraceManager.getTrace(ModelObjectResolver.class);

    public <T extends ObjectType> T resolve(ObjectReferenceType ref, Class<T> expectedType, String contextDescription, OperationResult result) throws ObjectNotFoundException, SchemaException {
        String oid = ref.getOid();
        Class typeClass = null;
        QName typeQName = ref.getType();
        if (typeQName != null) {
            typeClass = this.prismContext.getSchemaRegistry().determineCompileTimeClass(typeQName);
        }
        if (typeClass != null && expectedType.isAssignableFrom(typeClass)) {
            expectedType = typeClass;
        }
        return this.getObject(expectedType, oid, result);
    }

    public PrismObject<?> resolve(PrismReferenceValue refVal, String string, OperationResult result) throws ObjectNotFoundException {
        String oid = refVal.getOid();
        Class typeClass = ObjectType.class;
        QName typeQName = refVal.getTargetType();
        if (typeQName == null && refVal.getParent() != null && refVal.getParent().getDefinition() != null) {
            PrismReferenceDefinition refDef = (PrismReferenceDefinition)refVal.getParent().getDefinition();
            typeQName = refDef.getTargetTypeName();
        }
        if (typeQName != null) {
            typeClass = this.prismContext.getSchemaRegistry().determineCompileTimeClass(typeQName);
        }
        return this.getObject(typeClass, oid, result).asPrismObject();
    }

    public <T extends ObjectType> T getObject(Class<T> clazz, String oid, OperationResult result) throws ObjectNotFoundException {
        ObjectType objectType = null;
        try {
            try {
                PrismObject object = null;
                if (ObjectTypes.isClassManagedByProvisioning(clazz)) {
                    object = this.provisioning.getObject(clazz, oid, result);
                    if (object == null) {
                        throw new SystemException("Got null result from provisioning.getObject while looking for " + clazz.getSimpleName() + " with OID " + oid + "; using provisioning implementation " + this.provisioning.getClass().getName());
                    }
                } else {
                    object = this.cacheRepositoryService.getObject(clazz, oid, result);
                    if (object == null) {
                        throw new SystemException("Got null result from repository.getObject while looking for " + clazz.getSimpleName() + " with OID " + oid + "; using repository implementation " + this.cacheRepositoryService.getClass().getName());
                    }
                }
                if (!clazz.isInstance(objectType = (ObjectType)object.asObjectable())) {
                    throw new ObjectNotFoundException("Bad object type returned for referenced oid '" + oid + "'. Expected '" + clazz + "', but was '" + (objectType == null ? "null" : objectType.getClass()) + "'.");
                }
            }
            catch (SystemException ex) {
                throw ex;
            }
            catch (ObjectNotFoundException ex) {
                throw ex;
            }
            catch (CommonException ex) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Error resolving object with oid {}", (Throwable)ex, (Object[])new Object[]{oid});
                result.recordFatalError("Couldn't get object with oid '" + oid + "': " + ex.getOperationResultMessage(), (Throwable)ex);
                throw new SystemException("Error resolving object with oid '" + oid + "': " + ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Error resolving object with oid {}, expected type was {}.", (Throwable)ex, (Object[])new Object[]{oid, clazz});
                throw new SystemException("Error resolving object with oid '" + oid + "': " + ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            result.computeStatus();
        }
        return (T)objectType;
    }
}

