/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.model.api.hooks.ChangeHook;
import com.evolveum.midpoint.model.api.hooks.HookRegistry;
import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.repo.sql.SqlRepositoryConfiguration;
import com.evolveum.midpoint.repo.sql.SqlRepositoryFactory;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.WfConfiguration;
import com.evolveum.midpoint.wf.WfHook;
import com.evolveum.midpoint.wf.WorkItem;
import com.evolveum.midpoint.wf.activiti.ActivitiEngine;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.activiti.engine.FormService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.TaskService;
import org.activiti.engine.form.FormProperty;
import org.activiti.engine.form.FormType;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.GroupQuery;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowManager
implements BeanFactoryAware {
    private static final transient Trace LOGGER = TraceManager.getTrace(WorkflowManager.class);
    @Autowired(required=true)
    ActivitiEngine activitiEngine;
    @Autowired(required=true)
    private HookRegistry hookRegistry;
    @Autowired(required=true)
    WfHook wfHook;
    @Autowired(required=true)
    PrismContext prismContext;
    @Autowired(required=true)
    MidpointConfiguration midpointConfiguration;
    private WfConfiguration wfConfiguration;
    private BeanFactory beanFactory;
    private static final QName WORK_ITEM_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "WorkItem");
    private static final QName WORK_ITEM_TASK_ID = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "taskId");
    private static final QName WORK_ITEM_TASK_NAME = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "taskName");
    private static final QName WORK_ITEM_ASSIGNEE = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "assignee");
    private static final QName WORK_ITEM_CANDIDATES = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "candidates");

    @PostConstruct
    public void initialize() throws Exception {
        SqlRepositoryConfiguration sqlConfig;
        this.wfConfiguration = new WfConfiguration();
        try {
            SqlRepositoryFactory sqlRepositoryFactory = (SqlRepositoryFactory)this.beanFactory.getBean("sqlRepositoryFactory");
            sqlConfig = sqlRepositoryFactory.getSqlConfiguration();
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.debug("SqlRepositoryFactory is not available, Activiti database configuration (if any) will be taken from 'workflow' configuration section only.");
            LOGGER.trace("Reason is", (Throwable)e);
            sqlConfig = null;
        }
        this.wfConfiguration.initialize(this.midpointConfiguration, sqlConfig);
        if (!this.wfConfiguration.isEnabled()) {
            LOGGER.info("Workflow management is not enabled.");
        } else {
            this.activitiEngine.initialize(this.wfConfiguration);
            LOGGER.trace("Registering workflow hook");
            this.hookRegistry.registerChangeHook("http://midpoint.evolveum.com/model/workflow-hook-1", (ChangeHook)this.wfHook);
        }
    }

    public int countWorkItemsAssignedToUser(String user, OperationResult parentResult) {
        TaskService taskService = this.activitiEngine.getTaskService();
        TaskQuery tq = taskService.createTaskQuery();
        tq.taskAssignee(user);
        return (int)tq.count();
    }

    public List<WorkItem> listWorkItemsAssignedToUser(String user, int first, int count, OperationResult parentResult) {
        TaskService taskService = this.activitiEngine.getTaskService();
        TaskQuery tq = taskService.createTaskQuery();
        tq.taskAssignee(user);
        List tasks = tq.listPage(first, count);
        return this.tasksToWorkItems(tasks);
    }

    private List<WorkItem> tasksToWorkItems(List<Task> tasks) {
        ArrayList<WorkItem> retval = new ArrayList<WorkItem>();
        for (Task task : tasks) {
            retval.add(this.taskToWorkItem(task));
        }
        return retval;
    }

    private WorkItem taskToWorkItem(Task task) {
        WorkItem wi = new WorkItem();
        wi.setTaskId(task.getId());
        wi.setAssignee(task.getAssignee());
        wi.setName(task.getName());
        wi.setProcessId(task.getProcessInstanceId());
        wi.setCandidates(this.getCandidatesAsString(task));
        return wi;
    }

    public int countWorkItemsAssignableToUser(String user, OperationResult parentResult) {
        List<String> groups = this.groupsForUser(user);
        if (groups.isEmpty()) {
            return 0;
        }
        TaskService taskService = this.activitiEngine.getTaskService();
        TaskQuery tq = taskService.createTaskQuery();
        tq.taskCandidateGroupIn(groups);
        return (int)tq.count();
    }

    public List<WorkItem> listWorkItemsAssignableToUser(String user, int first, int count, OperationResult parentResult) {
        ArrayList<Task> tasks;
        List<String> groups = this.groupsForUser(user);
        if (groups.isEmpty()) {
            tasks = new ArrayList();
        } else {
            TaskService taskService = this.activitiEngine.getTaskService();
            TaskQuery tq = taskService.createTaskQuery();
            tq.taskCandidateGroupIn(groups);
            tasks = tq.listPage(first, count);
        }
        LOGGER.trace("Activiti tasks assignable to " + user + ": " + tasks);
        return this.tasksToWorkItems(tasks);
    }

    private List<String> groupsForUser(String user) {
        IdentityService identityService = this.activitiEngine.getIdentityService();
        GroupQuery gq = identityService.createGroupQuery();
        gq.groupMember(user);
        ArrayList<String> groupNames = new ArrayList<String>();
        List groups = gq.list();
        LOGGER.trace("Activiti groups for " + user + ":");
        for (Group g : groups) {
            LOGGER.trace(" - group: id = " + g.getId() + ", name = " + g.getName());
            groupNames.add(g.getId());
        }
        return groupNames;
    }

    public void claimWorkItem(WorkItem workItem, String userId, OperationResult result) {
        TaskService taskService = this.activitiEngine.getTaskService();
        taskService.claim(workItem.getTaskId(), userId);
        result.recordSuccess();
    }

    public void releaseWorkItem(WorkItem workItem, OperationResult result) {
        TaskService taskService = this.activitiEngine.getTaskService();
        taskService.claim(workItem.getTaskId(), null);
        result.recordSuccess();
    }

    public PrismObject<? extends ObjectType> getWorkItemPrism(String taskId) throws SchemaException {
        String candidates;
        Task task = (Task)this.activitiEngine.getTaskService().createTaskQuery().taskId(taskId).singleResult();
        if (task == null) {
            return null;
        }
        ComplexTypeDefinition ctd = new ComplexTypeDefinition(WORK_ITEM_NAME, WORK_ITEM_NAME, this.prismContext);
        ctd.createPropertyDefinifion(WORK_ITEM_TASK_ID, DOMUtil.XSD_STRING);
        ctd.createPropertyDefinifion(WORK_ITEM_TASK_NAME, DOMUtil.XSD_STRING);
        ctd.createPropertyDefinifion(WORK_ITEM_ASSIGNEE, DOMUtil.XSD_STRING);
        ctd.createPropertyDefinifion(WORK_ITEM_CANDIDATES, DOMUtil.XSD_STRING);
        TaskFormData data = this.activitiEngine.getFormService().getTaskFormData(task.getId());
        for (FormProperty formProperty : data.getFormProperties()) {
            QName ptype;
            QName pname = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "WI_" + formProperty.getId());
            FormType t = formProperty.getType();
            String ts = t.getName();
            if ("string".equals(ts)) {
                ptype = DOMUtil.XSD_STRING;
            } else if ("boolean".equals(ts)) {
                ptype = DOMUtil.XSD_BOOLEAN;
            } else if ("long".equals(ts)) {
                ptype = DOMUtil.XSD_LONG;
            } else if ("date".equals(ts)) {
                ptype = new QName("http://www.w3.org/2001/XMLSchema", "date", "xsd");
            } else if ("enum".equals(ts)) {
                ptype = DOMUtil.XSD_INT;
            } else {
                LOGGER.warn("Unknown Activiti type: " + ts);
                continue;
            }
            ctd.createPropertyDefinifion(pname, ptype);
        }
        ctd.setObjectMarker(true);
        PrismObjectDefinition prismObjectDefinition = new PrismObjectDefinition(WORK_ITEM_NAME, ctd, this.prismContext, ObjectType.class);
        PrismObject instance = prismObjectDefinition.instantiate();
        instance.findOrCreateProperty(WORK_ITEM_TASK_ID).setValue(new PrismPropertyValue((Object)taskId));
        instance.findOrCreateProperty(WORK_ITEM_TASK_NAME).setValue(new PrismPropertyValue((Object)task.getName()));
        if (task.getAssignee() != null) {
            instance.findOrCreateProperty(WORK_ITEM_ASSIGNEE).setValue(new PrismPropertyValue((Object)task.getAssignee()));
        }
        if ((candidates = this.getCandidatesAsString(task)) != null) {
            instance.findOrCreateProperty(WORK_ITEM_CANDIDATES).setValue(new PrismPropertyValue((Object)candidates));
        }
        for (FormProperty formProperty : data.getFormProperties()) {
            QName pname = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "WI_" + formProperty.getId());
            instance.findOrCreateProperty(pname).setValue(new PrismPropertyValue((Object)formProperty.getValue()));
        }
        return instance;
    }

    private List<String> getCandidates(Task task) {
        ArrayList<String> retval = new ArrayList<String>();
        TaskService taskService = this.activitiEngine.getTaskService();
        List ils = taskService.getIdentityLinksForTask(task.getId());
        for (IdentityLink il : ils) {
            if (!"candidate".equals(il.getType())) continue;
            if (il.getGroupId() != null) {
                retval.add("G:" + il.getGroupId());
            }
            if (il.getUserId() == null) continue;
            retval.add("U:" + il.getUserId());
        }
        return retval;
    }

    private String getCandidatesAsString(Task task) {
        StringBuffer retval = new StringBuffer();
        boolean first = true;
        for (String c : this.getCandidates(task)) {
            if (first) {
                first = false;
            } else {
                retval.append(", ");
            }
            retval.append(c);
        }
        return retval.toString();
    }

    public void saveWorkItemPrism(PrismObject object, OperationResult result) {
        String taskId = (String)object.getPropertyRealValue(WORK_ITEM_TASK_ID, String.class);
        LOGGER.trace("Saving work item " + taskId);
        FormService formService = this.activitiEngine.getFormService();
        HashMap<String, String> propertiesToSubmit = new HashMap<String, String>();
        TaskFormData data = this.activitiEngine.getFormService().getTaskFormData(taskId);
        for (FormProperty formProperty : data.getFormProperties()) {
            if (!formProperty.isWritable()) continue;
            QName propertyName = new QName("http://midpoint.evolveum.com/xml/ns/public/common/common-2", "WI_" + formProperty.getId());
            Object value = object.getPropertyRealValue(propertyName, Object.class);
            LOGGER.trace("Writable property " + formProperty.getId() + " has a value of " + value);
            if (value == null) continue;
            propertiesToSubmit.put(formProperty.getId(), value.toString());
        }
        formService.submitTaskFormData(taskId, propertiesToSubmit);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public WfConfiguration getWfConfiguration() {
        return this.wfConfiguration;
    }

    public boolean isEnabled() {
        return this.wfConfiguration.isEnabled();
    }
}

