/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.polystring.PolyString;
import org.apache.commons.lang.StringUtils;

public class MidPointFunctions {
    public static final String NAME_SEPARATOR = " ";
    private PrismContext prismContext;

    public MidPointFunctions(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public static String lc(String orig) {
        return StringUtils.lowerCase((String)orig);
    }

    public static String uc(String orig) {
        return StringUtils.upperCase((String)orig);
    }

    public static String trim(String orig) {
        return StringUtils.trim((String)orig);
    }

    public String concatName(String ... components) {
        if (components == null || components.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < components.length) {
            String component = components[i];
            if (component != null) {
                sb.append(MidPointFunctions.trim(component));
                if (i < components.length - 1) {
                    sb.append(NAME_SEPARATOR);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String norm(String orig) {
        PolyString polyString = new PolyString(orig);
        polyString.recompute(this.prismContext.getDefaultPolyStringNormalizer());
        return polyString.getNorm();
    }
}

