/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.ROperationResultStatusType;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LocalizedMessageType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ParamsType;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Type;

@Entity
public class ROperationResult
implements Serializable {
    private RObject owner;
    private String ownerOid;
    private Long ownerId;
    private String operation;
    private ROperationResultStatusType status;
    private Long token;
    private String messageCode;
    private String message;
    private String details;
    private String localizedMessage;
    private String params;
    private String partialResults;

    @ForeignKey(name="fk_result_owner")
    @MapsId(value="owner")
    @ManyToOne(fetch=FetchType.LAZY)
    @PrimaryKeyJoinColumns(value={@PrimaryKeyJoinColumn(name="owner_oid", referencedColumnName="oid"), @PrimaryKeyJoinColumn(name="owner_id", referencedColumnName="id")})
    public RObject getOwner() {
        return this.owner;
    }

    @Id
    @Column(name="owner_id")
    public Long getOwnerId() {
        if (this.ownerId == null && this.owner != null) {
            this.ownerId = this.owner.getId();
        }
        return this.ownerId;
    }

    @Id
    @Column(name="owner_oid", length=36)
    public String getOwnerOid() {
        if (this.ownerOid == null && this.owner != null) {
            this.ownerOid = this.owner.getOid();
        }
        return this.ownerOid;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getParams() {
        return this.params;
    }

    @Type(type="org.hibernate.type.MaterializedClobType")
    public String getPartialResults() {
        return this.partialResults;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public ROperationResultStatusType getStatus() {
        return this.status;
    }

    @Column(nullable=true)
    public Long getToken() {
        return this.token;
    }

    public void setOwner(RObject owner) {
        this.owner = owner;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getDetails() {
        return this.details;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getMessage() {
        return this.message;
    }

    public String getMessageCode() {
        return this.messageCode;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getOperation() {
        return this.operation;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerOid(String ownerOid) {
        this.ownerOid = ownerOid;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public void setLocalizedMessage(String localizedMessage) {
        this.localizedMessage = localizedMessage;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setPartialResults(String partialResults) {
        this.partialResults = partialResults;
    }

    public void setStatus(ROperationResultStatusType status) {
        this.status = status;
    }

    public void setToken(Long token) {
        this.token = token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ROperationResult that = (ROperationResult)o;
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.localizedMessage != null ? !this.localizedMessage.equals(that.localizedMessage) : that.localizedMessage != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.messageCode != null ? !this.messageCode.equals(that.messageCode) : that.messageCode != null) {
            return false;
        }
        if (this.operation != null ? !this.operation.equals(that.operation) : that.operation != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.partialResults != null ? !this.partialResults.equals(that.partialResults) : that.partialResults != null) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
    }

    public int hashCode() {
        int result = this.operation != null ? this.operation.hashCode() : 0;
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + (this.messageCode != null ? this.messageCode.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.details != null ? this.details.hashCode() : 0);
        result = 31 * result + (this.localizedMessage != null ? this.localizedMessage.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 31 * result + (this.partialResults != null ? this.partialResults.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(ROperationResult repo, OperationResultType jaxb, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        jaxb.setDetails(repo.getDetails());
        jaxb.setMessage(repo.getMessage());
        jaxb.setMessageCode(repo.getMessageCode());
        jaxb.setOperation(repo.getOperation());
        if (repo.getStatus() != null) {
            jaxb.setStatus(repo.getStatus().getStatus());
        }
        jaxb.setToken(repo.getToken());
        try {
            jaxb.setLocalizedMessage(RUtil.toJAXB(OperationResultType.class, new PropertyPath(new QName[]{OperationResultType.F_LOCALIZED_MESSAGE}), repo.getLocalizedMessage(), LocalizedMessageType.class, prismContext));
            jaxb.setParams(RUtil.toJAXB(OperationResultType.class, new PropertyPath(new QName[]{OperationResultType.F_PARAMS}), repo.getParams(), ParamsType.class, prismContext));
            if (StringUtils.isNotEmpty((String)repo.getPartialResults())) {
                OperationResultType result = RUtil.toJAXB(repo.getPartialResults(), OperationResultType.class, prismContext);
                jaxb.getPartialResults().addAll(result.getPartialResults());
            }
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(OperationResultType jaxb, ROperationResult repo, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        repo.setDetails(jaxb.getDetails());
        repo.setMessage(jaxb.getMessage());
        repo.setMessageCode(jaxb.getMessageCode());
        repo.setOperation(jaxb.getOperation());
        repo.setStatus(ROperationResultStatusType.toRepoType(jaxb.getStatus()));
        repo.setToken(jaxb.getToken());
        try {
            repo.setLocalizedMessage(RUtil.toRepo(jaxb.getLocalizedMessage(), prismContext));
            repo.setParams(RUtil.toRepo(jaxb.getParams(), prismContext));
            if (!jaxb.getPartialResults().isEmpty()) {
                OperationResultType result = new OperationResultType();
                result.getPartialResults().addAll(jaxb.getPartialResults());
                repo.setPartialResults(RUtil.toRepo(result, prismContext));
            }
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public OperationResultType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        OperationResultType result = new OperationResultType();
        ROperationResult.copyToJAXB(this, result, prismContext);
        return result;
    }
}

