/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.schema.DomToSchemaProcessor;
import com.evolveum.midpoint.prism.schema.SchemaToDomProcessor;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class PrismSchema
implements Dumpable,
DebugDumpable {
    private static final long serialVersionUID = 5068618465625931984L;
    private static final Trace LOGGER = TraceManager.getTrace(PrismSchema.class);
    protected String namespace;
    protected Collection<Definition> definitions;
    protected PrismContext prismContext;

    protected PrismSchema(PrismContext prismContext) {
        this.prismContext = prismContext;
        this.definitions = new ArrayList<Definition>();
    }

    public PrismSchema(String namespace, PrismContext prismContext) {
        if (StringUtils.isEmpty((String)namespace)) {
            throw new IllegalArgumentException("Namespace can't be null or empty.");
        }
        this.namespace = namespace;
        this.prismContext = prismContext;
        this.definitions = new ArrayList<Definition>();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Collection<Definition> getDefinitions() {
        if (this.definitions == null) {
            this.definitions = new HashSet<Definition>();
        }
        return this.definitions;
    }

    public <T extends Definition> Collection<T> getDefinitions(Class<T> type) {
        HashSet<Definition> defs = new HashSet<Definition>();
        for (Definition def : this.getDefinitions()) {
            if (!type.isAssignableFrom(def.getClass())) continue;
            defs.add(def);
        }
        return defs;
    }

    public void add(Definition def) {
        this.definitions.add(def);
    }

    protected PrismContext getPrismContext() {
        return this.prismContext;
    }

    public static PrismSchema parse(Element element, String shortDescription, PrismContext prismContext) throws SchemaException {
        return PrismSchema.parse(element, prismContext.getSchemaRegistry(), new PrismSchema(prismContext), shortDescription, prismContext);
    }

    public static PrismSchema parse(Element element, EntityResolver resolver, String shortDescription, PrismContext prismContext) throws SchemaException {
        return PrismSchema.parse(element, resolver, new PrismSchema(prismContext), shortDescription, prismContext);
    }

    protected static PrismSchema parse(Element element, PrismSchema schema, String shortDescription, PrismContext prismContext) throws SchemaException {
        return PrismSchema.parse(element, prismContext.getSchemaRegistry(), schema, shortDescription, prismContext);
    }

    protected static PrismSchema parse(Element element, EntityResolver resolver, PrismSchema schema, String shortDescription, PrismContext prismContext) throws SchemaException {
        if (element == null) {
            throw new IllegalArgumentException("Schema DOM element must not be null.");
        }
        DomToSchemaProcessor processor = new DomToSchemaProcessor();
        processor.setEntityResolver(resolver);
        processor.setPrismContext(prismContext);
        processor.setShortDescription(shortDescription);
        return processor.parseDom(schema, element);
    }

    public Document serializeToXsd() throws SchemaException {
        SchemaToDomProcessor processor = new SchemaToDomProcessor();
        processor.setPrismContext(this.prismContext);
        return processor.parseSchema(this);
    }

    public PrismContainerDefinition findContainerDefinitionByType(QName typeName) {
        return this.findContainerDefinitionByType(typeName, PrismContainerDefinition.class);
    }

    public <X extends Objectable> PrismObjectDefinition<X> findObjectDefinitionByType(QName typeName) {
        return this.findContainerDefinitionByType(typeName, PrismObjectDefinition.class);
    }

    public <X extends Objectable> PrismObjectDefinition<X> findObjectDefinitionByElementName(QName elementName) {
        return this.findContainerDefinitionByElementName(elementName, PrismObjectDefinition.class);
    }

    public <T extends Objectable> PrismObjectDefinition<T> findObjectDefinitionByType(QName typeName, Class<T> type) {
        return this.findContainerDefinitionByType(typeName, PrismObjectDefinition.class);
    }

    public <T extends Objectable> PrismObjectDefinition<T> findObjectDefinitionByCompileTimeClass(Class<T> type) {
        for (Definition def : this.getDefinitions()) {
            PrismObjectDefinition objDef;
            if (!(def instanceof PrismObjectDefinition) || !type.equals((objDef = (PrismObjectDefinition)def).getCompileTimeClass())) continue;
            return objDef;
        }
        return null;
    }

    private <T extends PrismContainerDefinition> T findContainerDefinitionByType(QName typeName, Class<T> type) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName must be supplied");
        }
        for (Definition definition : this.definitions) {
            if (!type.isAssignableFrom(definition.getClass()) || !typeName.equals(definition.getTypeName())) continue;
            return (T)((PrismContainerDefinition)definition);
        }
        return null;
    }

    public PrismContainerDefinition findContainerDefinitionByElementName(QName elementName) {
        return this.findContainerDefinitionByElementName(elementName, PrismContainerDefinition.class);
    }

    private <T extends PrismContainerDefinition> T findContainerDefinitionByElementName(QName elementName, Class<T> type) {
        if (elementName == null) {
            throw new IllegalArgumentException("elementName must be supplied");
        }
        for (Definition definition : this.definitions) {
            if (!type.isAssignableFrom(definition.getClass()) || !elementName.equals(definition.getDefaultName())) continue;
            return (T)((PrismContainerDefinition)definition);
        }
        return null;
    }

    public PrismPropertyDefinition findPropertyDefinitionByElementName(QName elementName) {
        return this.findPropertyDefinitionByElementName(elementName, PrismPropertyDefinition.class);
    }

    private <T extends PrismPropertyDefinition> T findPropertyDefinitionByElementName(QName elementName, Class<T> type) {
        if (elementName == null) {
            throw new IllegalArgumentException("elementName must be supplied");
        }
        for (Definition definition : this.definitions) {
            if (!type.isAssignableFrom(definition.getClass()) || !elementName.equals(definition.getDefaultName())) continue;
            return (T)((PrismPropertyDefinition)definition);
        }
        return null;
    }

    public ComplexTypeDefinition findComplexTypeDefinition(QName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName must be supplied");
        }
        for (Definition definition : this.definitions) {
            if (!(definition instanceof ComplexTypeDefinition) || !typeName.equals(definition.getTypeName())) continue;
            return (ComplexTypeDefinition)definition;
        }
        return null;
    }

    public <T extends ItemDefinition> T findItemDefinition(QName definitionName, Class<T> definitionType) {
        if (definitionName == null) {
            throw new IllegalArgumentException("definitionName must be supplied");
        }
        for (Definition definition : this.definitions) {
            ItemDefinition idef;
            if (!definitionType.isAssignableFrom(definition.getClass()) || !definitionName.equals((idef = (ItemDefinition)definition).getName())) continue;
            return (T)idef;
        }
        return null;
    }

    public <T extends ItemDefinition> T findItemDefinition(String localName, Class<T> definitionType) {
        if (localName == null) {
            throw new IllegalArgumentException("localName must be supplied");
        }
        for (Definition definition : this.definitions) {
            ItemDefinition idef;
            if (!definitionType.isAssignableFrom(definition.getClass()) || !localName.equals((idef = (ItemDefinition)definition).getName().getLocalPart())) continue;
            return (T)idef;
        }
        return null;
    }

    public <T extends ItemDefinition> T findItemDefinitionByType(QName typeName, Class<T> definitionType) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName must be supplied");
        }
        for (Definition definition : this.definitions) {
            ItemDefinition idef;
            if (!definitionType.isAssignableFrom(definition.getClass()) || !typeName.equals((idef = (ItemDefinition)definition).getTypeName())) continue;
            return (T)idef;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.definitions.isEmpty();
    }

    public PrismContainerDefinition createPropertyContainerDefinition(String localTypeName) {
        QName typeName = new QName(this.getNamespace(), localTypeName);
        QName name = new QName(this.getNamespace(), this.toElementName(localTypeName));
        ComplexTypeDefinition cTypeDef = new ComplexTypeDefinition(name, typeName, this.prismContext);
        PrismContainerDefinition def = new PrismContainerDefinition(name, cTypeDef, this.prismContext);
        this.definitions.add(cTypeDef);
        this.definitions.add(def);
        return def;
    }

    public PrismContainerDefinition createPropertyContainerDefinition(String localElementName, String localTypeName) {
        QName typeName = new QName(this.getNamespace(), localTypeName);
        QName name = new QName(this.getNamespace(), localElementName);
        ComplexTypeDefinition cTypeDef = this.findComplexTypeDefinition(typeName);
        if (cTypeDef == null) {
            cTypeDef = new ComplexTypeDefinition(name, typeName, this.prismContext);
            this.definitions.add(cTypeDef);
        }
        PrismContainerDefinition def = new PrismContainerDefinition(name, cTypeDef, this.prismContext);
        this.definitions.add(def);
        return def;
    }

    public ComplexTypeDefinition createComplexTypeDefinition(QName typeName) {
        ComplexTypeDefinition cTypeDef = new ComplexTypeDefinition(this.toElementQName(typeName), typeName, this.prismContext);
        this.definitions.add(cTypeDef);
        return cTypeDef;
    }

    public PrismPropertyDefinition createPropertyDefinition(String localName, QName typeName) {
        QName name = new QName(this.getNamespace(), localName);
        return this.createPropertyDefinition(name, typeName);
    }

    public PrismPropertyDefinition createPropertyDefinition(String localName, String localTypeName) {
        QName name = new QName(this.getNamespace(), localName);
        QName typeName = new QName(this.getNamespace(), localTypeName);
        return this.createPropertyDefinition(name, typeName);
    }

    public PrismPropertyDefinition createPropertyDefinition(QName name, QName typeName) {
        PrismPropertyDefinition def = new PrismPropertyDefinition(name, name, typeName, this.prismContext);
        this.definitions.add(def);
        return def;
    }

    protected String toElementName(String localTypeName) {
        String elementName = StringUtils.uncapitalize((String)localTypeName);
        if (elementName.endsWith("Type")) {
            return elementName.substring(0, elementName.length() - 4);
        }
        return elementName;
    }

    protected QName toElementQName(QName qname) {
        return new QName(qname.getNamespaceURI(), this.toElementName(qname.getLocalPart()));
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.toString()).append("\n");
        Iterator<Definition> i2 = this.definitions.iterator();
        while (i2.hasNext()) {
            Definition def = i2.next();
            sb.append(def.debugDump(indent + 1));
            if (!i2.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public String dump() {
        return this.debugDump(0);
    }

    public String toString() {
        return "Schema(ns=" + this.namespace + ")";
    }
}

