/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.Visitor;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.dom.ElementPrismContainerImpl;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;

public class PrismContainerValue<T extends Containerable>
extends PrismValue
implements Dumpable,
DebugDumpable {
    private List<Item<?>> items = new ArrayList();
    private String id;
    private List<Object> rawElements = null;
    private T containerable = null;

    public PrismContainerValue() {
    }

    public PrismContainerValue(SourceType type, Objectable source, PrismContainerable container, String id) {
        super(type, source, container);
        this.id = id;
    }

    public List<Item<?>> getItems() {
        return this.items;
    }

    public Item<?> getNextItem(Item<?> referenceItem) {
        Iterator<Item<?>> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item<?> item = iterator.next();
            if (item != referenceItem) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        throw new IllegalArgumentException("Item " + referenceItem + " is not part of " + this);
    }

    public Item<?> getPreviousItem(Item<?> referenceItem) {
        Item<?> lastItem = null;
        for (Item<?> item : this.items) {
            if (item == referenceItem) {
                return lastItem;
            }
            lastItem = item;
        }
        throw new IllegalArgumentException("Item " + referenceItem + " is not part of " + this);
    }

    public Set<PrismProperty<?>> getProperties() {
        HashSet properties = new HashSet();
        for (Item<?> item : this.getItems()) {
            if (!(item instanceof PrismProperty)) continue;
            properties.add((PrismProperty)item);
        }
        return properties;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public PrismContainerable<T> getParent() {
        Itemable parent = super.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof PrismContainerable)) {
            throw new IllegalStateException("Expected that parent of " + PrismContainerValue.class.getName() + " will be " + PrismContainerable.class.getName() + ", but it is " + parent.getClass().getName());
        }
        return (PrismContainerable)parent;
    }

    void setParent(PrismContainerable container) {
        super.setParent(container);
    }

    public PrismContainer<T> getContainer() {
        Itemable parent = super.getParent();
        if (parent == null) {
            return null;
        }
        if (!(parent instanceof PrismContainer)) {
            throw new IllegalStateException("Expected that parent of " + PrismContainerValue.class.getName() + " will be " + PrismContainer.class.getName() + ", but it is " + parent.getClass().getName());
        }
        return (PrismContainer)super.getParent();
    }

    void setParent(PrismContainer<T> container) {
        super.setParent(container);
    }

    @Override
    public PropertyPath getPath(PropertyPath pathPrefix) {
        Itemable parent = this.getParent();
        PropertyPath parentPath = PropertyPath.EMPTY_PATH;
        if (parent != null) {
            parentPath = this.getParent().getPath(pathPrefix);
        }
        if (parentPath == null || parentPath.isEmpty()) {
            return parentPath;
        }
        PropertyPathSegment mySegment = new PropertyPathSegment(this.getParent().getName(), this.getId());
        return parentPath.allExceptLast().subPath(mySegment);
    }

    public T getValue() {
        return this.asContainerable();
    }

    public List<Object> getRawElements() {
        if (this.rawElements == null) {
            this.rawElements = this.createElement();
        }
        return this.rawElements;
    }

    private List<Object> createElement() {
        return new ArrayList<Object>();
    }

    public T asContainerable() {
        Itemable parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Cannot represent container value witout a parent as containerable; value: " + this);
        }
        Class clazz = parent.getCompileTimeClass();
        if (clazz == null) {
            throw new SystemException("Unknown compile time class of container '" + parent.getName() + "'.");
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new SystemException("Can't create instance of class '" + clazz.getSimpleName() + "', it's abstract.");
        }
        return this.asContainerable(clazz);
    }

    public T asContainerable(Class<T> clazz) {
        if (this.containerable != null) {
            return this.containerable;
        }
        try {
            this.containerable = (Containerable)clazz.newInstance();
            this.containerable.setupContainerValue(this);
            return this.containerable;
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException("Couldn't create jaxb object instance of '" + clazz + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Collection<QName> getPropertyNames() {
        HashSet<QName> names = new HashSet<QName>();
        for (PrismProperty<?> prop : this.getProperties()) {
            names.add(prop.getName());
        }
        return names;
    }

    public void add(Item<?> item) throws SchemaException {
        if (item.getName() == null) {
            throw new IllegalArgumentException("Cannot add item without a name to value of container " + this.getParent());
        }
        if (this.findItem(item.getName(), Item.class) != null) {
            throw new IllegalArgumentException("Item " + item.getName() + " is already present in " + this.getClass().getSimpleName());
        }
        item.setParent(this);
        PrismContext prismContext = this.getPrismContext();
        if (prismContext != null) {
            item.setPrismContext(prismContext);
        }
        if (this.getParent() != null && this.getParent().getDefinition() != null && item.getDefinition() == null) {
            item.applyDefinition(this.determineItemDefinition(item.getName(), this.getParent().getDefinition()), false);
        }
        this.items.add(item);
    }

    public void addReplaceExisting(Item<?> item) throws SchemaException {
        Item existingItem = this.findItem(item.getName(), Item.class);
        if (existingItem != null) {
            this.items.remove(existingItem);
            existingItem.setParent(null);
        }
        this.add(item);
    }

    public void remove(Item<?> item) {
        Validate.notNull(item, (String)"Item must not be null.");
        Item existingItem = this.findItem(item.getName(), Item.class);
        if (existingItem != null) {
            this.items.remove(existingItem);
            existingItem.setParent(null);
        }
    }

    public void removeAll() {
        Iterator<Item<?>> iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item<?> item = iterator.next();
            item.setParent(null);
            iterator.remove();
        }
    }

    public void addAll(Collection<? extends Item<?>> itemsToAdd) throws SchemaException {
        for (Item<?> item : itemsToAdd) {
            this.add(item);
        }
    }

    public void addAllReplaceExisting(Collection<? extends Item<?>> itemsToAdd) {
        for (Item<?> item : itemsToAdd) {
            Item existingItem = this.findItem(item.getName(), Item.class);
            if (existingItem == null) continue;
            this.items.remove(existingItem);
        }
        this.items.addAll(itemsToAdd);
    }

    public void replace(Item<?> oldItem, Item<?> newItem) throws SchemaException {
        this.remove(oldItem);
        this.add(newItem);
    }

    void addItemPathsToList(PropertyPath basePath, Collection<PropertyPath> list) {
        for (Item<?> item : this.items) {
            if (item instanceof PrismProperty) {
                list.add(basePath.subPath(item.getName()));
                continue;
            }
            if (!(item instanceof PrismContainer)) continue;
            ((PrismContainer)item).addItemPathsToList(basePath, list);
        }
    }

    public void clear() {
        this.items.clear();
    }

    public <X> PrismProperty<X> findProperty(QName propertyQName) {
        return this.findItem(propertyQName, PrismProperty.class);
    }

    public <X> PrismProperty<X> findProperty(PrismPropertyDefinition propertyDefinition) {
        if (propertyDefinition == null) {
            throw new IllegalArgumentException("No property definition");
        }
        return this.findProperty(propertyDefinition.getName());
    }

    public <X extends Containerable> PrismContainer<X> findContainer(QName containerName) {
        return this.findItem(containerName, PrismContainer.class);
    }

    public PrismReference findReference(QName elementName) {
        return this.findItem(elementName, PrismReference.class);
    }

    public PrismReference findReferenceByCompositeObjectElementName(QName elementName) {
        for (Item<?> item : this.items) {
            PrismReference ref;
            PrismReferenceDefinition refDef;
            if (!(item instanceof PrismReference) || (refDef = (ref = (PrismReference)item).getDefinition()) == null || !elementName.equals(refDef.getCompositeObjectElementName())) continue;
            return ref;
        }
        return null;
    }

    public <I extends Item<?>> I findItem(QName itemName, Class<I> type) {
        try {
            return this.findCreateItem(itemName, type, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Item<?> findItem(QName itemName) {
        try {
            return this.findCreateItem(itemName, Item.class, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Item<?> findItem(PropertyPath itemPath) {
        try {
            return this.findCreateItem(itemPath, Item.class, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    <I extends Item<?>> I findCreateItem(QName itemName, Class<I> type, ItemDefinition itemDefinition, boolean create) throws SchemaException {
        for (Item<?> item : this.items) {
            if (!itemName.equals(item.getName())) continue;
            if (type.isAssignableFrom(item.getClass())) {
                return (I)item;
            }
            if (create) {
                throw new IllegalStateException("The " + type.getSimpleName() + " cannot be created because " + item.getClass().getSimpleName() + " with the same name exists (" + item.getName() + ")");
            }
            return null;
        }
        if (create) {
            return this.createSubItem(itemName, type, itemDefinition);
        }
        return null;
    }

    public <I extends Item<?>> I findItem(ItemDefinition itemDefinition, Class<I> type) {
        if (itemDefinition == null) {
            throw new IllegalArgumentException("No item definition");
        }
        return this.findItem(itemDefinition.getName(), type);
    }

    <I extends Item<?>> I findCreateItem(PropertyPath propPath, Class<I> type, ItemDefinition itemDefinition, boolean create) throws SchemaException {
        PropertyPathSegment first = propPath.first();
        PropertyPath rest = propPath.rest();
        for (Item<?> item : this.items) {
            if (!first.getName().equals(item.getName())) continue;
            if (rest.isEmpty()) {
                if (type.isAssignableFrom(item.getClass())) {
                    return (I)item;
                }
                if (create) {
                    throw new SchemaException("The " + type.getSimpleName() + " cannot be created because " + item.getClass().getSimpleName() + " with the same name exists (" + item.getName() + ")");
                }
                return null;
            }
            if (item instanceof PrismContainer) {
                return ((PrismContainer)item).findCreateItem(propPath, type, itemDefinition, create);
            }
            if (create) {
                throw new SchemaException("The " + type.getSimpleName() + " cannot be created because " + item.getClass().getSimpleName() + " with the same name exists (" + item.getName() + ")");
            }
            if (type.isAssignableFrom(item.getClass())) {
                return (I)item;
            }
            return null;
        }
        if (create) {
            if (rest.isEmpty()) {
                return this.createSubItem(first.getName(), type, itemDefinition);
            }
            PrismContainer subItem = this.createSubItem(first.getName(), PrismContainer.class, null);
            return subItem.findCreateItem(propPath, type, itemDefinition, create);
        }
        return null;
    }

    private <I extends Item<?>> I createSubItem(QName name, Class<I> type, ItemDefinition itemDefinition) throws SchemaException {
        Item<Object> newItem = null;
        if (itemDefinition == null && this.getParent() != null && this.getParent().getDefinition() != null && (itemDefinition = this.determineItemDefinition(name, this.getParent().getDefinition())) == null) {
            throw new SchemaException("No definition for item " + name + " in " + this.getParent());
        }
        if (itemDefinition != null) {
            newItem = itemDefinition.instantiate(name);
            if (newItem instanceof PrismObject) {
                throw new IllegalStateException("PrismObject instantiated as a subItem in " + this + " from definition " + itemDefinition);
            }
        } else {
            newItem = Item.createNewDefinitionlessItem(name, type);
            if (newItem instanceof PrismObject) {
                throw new IllegalStateException("PrismObject instantiated as a subItem in " + this + " as definitionless instance of class " + type);
            }
        }
        if (type.isAssignableFrom(newItem.getClass())) {
            this.add(newItem);
            return (I)newItem;
        }
        throw new IllegalStateException("The " + type.getSimpleName() + " cannot be created because the item should be of type " + newItem.getClass().getSimpleName() + " (" + newItem.getName() + ")");
    }

    public <T extends Containerable> PrismContainer<T> findOrCreateContainer(QName containerName) throws SchemaException {
        return this.findCreateItem(containerName, PrismContainer.class, null, true);
    }

    public PrismReference findOrCreateReference(QName referenceName) throws SchemaException {
        return this.findCreateItem(referenceName, PrismReference.class, null, true);
    }

    public Item<?> findOrCreateItem(QName containerName) throws SchemaException {
        return this.findCreateItem(containerName, Item.class, null, true);
    }

    public <X extends Item> X findOrCreateItem(QName containerName, Class<X> type) throws SchemaException {
        return this.findCreateItem(containerName, type, null, true);
    }

    public <X> PrismProperty<X> findOrCreateProperty(QName propertyQName) throws SchemaException {
        PrismProperty property = this.findItem(propertyQName, PrismProperty.class);
        if (property != null) {
            return property;
        }
        return this.createProperty(propertyQName);
    }

    public <X> PrismProperty<X> findOrCreateProperty(PrismPropertyDefinition propertyDef) throws SchemaException {
        PrismProperty property = this.findItem(propertyDef.getName(), PrismProperty.class);
        if (property != null) {
            return property;
        }
        return this.createProperty(propertyDef);
    }

    public <X extends Containerable> PrismContainer<X> createContainer(QName containerName) throws SchemaException {
        if (this.getParent().getDefinition() == null) {
            throw new IllegalStateException("No definition of container " + containerName);
        }
        PrismContainerDefinition containerDefinition = this.getParent().getDefinition().findContainerDefinition(containerName);
        if (containerDefinition == null) {
            throw new IllegalArgumentException("No definition of container '" + containerName + "' in " + this.getParent().getDefinition());
        }
        Item container = containerDefinition.instantiate();
        this.add(container);
        return container;
    }

    public <X> PrismProperty<X> createProperty(QName propertyName) throws SchemaException {
        PrismPropertyDefinition propertyDefinition = null;
        if (this.getParent() != null && this.getParent().getDefinition() != null && (propertyDefinition = this.getParent().getDefinition().findPropertyDefinition(propertyName)) == null && !this.getParent().getDefinition().isRuntimeSchema) {
            throw new IllegalArgumentException("No definition for property " + propertyName + " in " + this.getParent());
        }
        PrismProperty property = null;
        property = propertyDefinition == null ? new PrismProperty(propertyName) : propertyDefinition.instantiate();
        this.add(property);
        return property;
    }

    public <X> PrismProperty<X> createProperty(PrismPropertyDefinition propertyDefinition) throws SchemaException {
        PrismProperty property = propertyDefinition.instantiate();
        this.add(property);
        return property;
    }

    @Override
    public void accept(Visitor visitor) {
        super.accept(visitor);
        for (Item<?> item : this.getItems()) {
            item.accept(visitor);
        }
    }

    @Override
    protected Element createDomElement() {
        return new ElementPrismContainerImpl(this);
    }

    public boolean equivalent(PrismContainerValue<?> other) {
        return this.equalsRealValue(other);
    }

    @Override
    public boolean equalsRealValue(PrismValue thisValue, PrismValue value) {
        if (value instanceof PrismContainerValue && thisValue instanceof PrismContainerValue) {
            return this.equalsRealValue((PrismContainerValue)thisValue, (PrismContainerValue)value);
        }
        return false;
    }

    public boolean equalsRealValue(PrismContainerValue<T> thisValue, PrismContainerValue<T> otherValue) {
        return this.equalsItems(thisValue, otherValue, true);
    }

    @Override
    public boolean representsSameValue(PrismValue other) {
        if (other instanceof PrismContainerValue) {
            return this.representsSameValue((PrismContainerValue)other);
        }
        return false;
    }

    public boolean representsSameValue(PrismContainerValue<T> other) {
        PrismContainerDefinition definition;
        if (this.getParent() != null && (definition = this.getParent().getDefinition()) != null && definition.isSingleValue()) {
            return true;
        }
        if (other.getParent() != null && (definition = other.getParent().getDefinition()) != null && definition.isSingleValue()) {
            return true;
        }
        if (this.getId() != null && other.getId() != null) {
            return this.getId().equals(other.getId());
        }
        return false;
    }

    @Override
    void diffMatchingRepresentation(PrismValue otherValue, PropertyPath pathPrefix, Collection<? extends ItemDelta> deltas, boolean ignoreMetadata) {
        if (!(otherValue instanceof PrismContainerValue)) {
            throw new IllegalStateException("Comparing incompatible values " + this + " - " + otherValue);
        }
        this.diffRepresentation((PrismContainerValue)otherValue, pathPrefix, deltas, ignoreMetadata);
    }

    void diffRepresentation(PrismContainerValue<T> otherValue, PropertyPath pathPrefix, Collection<? extends ItemDelta> deltas, boolean ignoreMetadata) {
        PrismContainerValue<T> thisValue = this;
        if (this.rawElements != null || otherValue.rawElements != null) {
            try {
                if (this.rawElements == null) {
                    otherValue = this.parseRawElementsToNewValue(otherValue, thisValue);
                } else if (otherValue.rawElements == null) {
                    thisValue = this.parseRawElementsToNewValue(thisValue, otherValue);
                }
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException("Error parsing the value of container " + this.getParent() + " using the 'other' definition " + "during a compare: " + e.getMessage(), e);
            }
        }
        this.diffItems(thisValue, otherValue, pathPrefix, deltas, ignoreMetadata);
    }

    @Override
    public boolean isRaw() {
        return this.rawElements != null;
    }

    private PrismContainerValue<T> parseRawElementsToNewValue(PrismContainerValue<T> origCVal, PrismContainerValue<T> definitionSource) throws SchemaException {
        List<Object> rawElements = origCVal.rawElements;
        if (definitionSource.getParent() == null || definitionSource.getParent().getDefinition() == null) {
            throw new IllegalArgumentException("Attempt to use container " + origCVal.getParent() + " values in a raw parsing state (raw elements) with parsed value that has no definition");
        }
        PrismContainerDefinition definition = definitionSource.getParent().getDefinition();
        Collection<Item<?>> parsedItems = this.parseRawElementsToItems(rawElements, definition);
        PrismContainerValue<T> newCVal = new PrismContainerValue<T>();
        newCVal.setParent((PrismContainerable)origCVal.getParent());
        newCVal.addAll(parsedItems);
        return newCVal;
    }

    private Collection<? extends Item<?>> parseRawElementsToItems(List<Object> rawElements, PrismContainerDefinition<T> definition) throws SchemaException {
        PrismDomProcessor domProcessor = definition.getPrismContext().getPrismDomProcessor();
        Collection<Item<?>> parsedItems = domProcessor.parseContainerItems(definition, rawElements);
        return parsedItems;
    }

    boolean equalsItems(PrismContainerValue<T> other, boolean ignoreMetadata) {
        return this.equalsItems(this, other, ignoreMetadata);
    }

    boolean equalsItems(PrismContainerValue<T> thisValue, PrismContainerValue<T> other, boolean ignoreMetadata) {
        ArrayList deltas = new ArrayList();
        this.diffItems(thisValue, other, PropertyPath.EMPTY_PATH, deltas, ignoreMetadata);
        return deltas.isEmpty();
    }

    void diffItems(PrismContainerValue<T> thisValue, PrismContainerValue<T> other, PropertyPath pathPrefix, Collection<? extends ItemDelta> deltas, boolean ignoreMetadata) {
        for (Item<?> thisItem : thisValue.getItems()) {
            Item<?> otherItem = other.findItem(thisItem.getName());
            thisItem.diffInternal(otherItem, pathPrefix, deltas, ignoreMetadata);
        }
        for (Item<?> otherItem : other.getItems()) {
            Item<?> thisItem = thisValue.findItem(otherItem.getName());
            if (thisItem != null) continue;
            ItemDelta<?> itemDelta = otherItem.createDelta(otherItem.getPath(pathPrefix));
            itemDelta.addValuesToAdd(otherItem.getClonedValues());
            if (itemDelta.isEmpty()) continue;
            deltas.add(itemDelta);
        }
    }

    @Override
    public void applyDefinition(ItemDefinition definition, boolean force) throws SchemaException {
        if (!(definition instanceof PrismContainerDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to container " + this);
        }
        this.applyDefinition((PrismContainerDefinition)definition, force);
    }

    public void applyDefinition(PrismContainerDefinition definition, boolean force) throws SchemaException {
        if (this.rawElements != null) {
            Collection<Item<?>> parsedItems = this.parseRawElementsToItems(this.rawElements, definition);
            this.addAll(parsedItems);
            this.rawElements = null;
        }
        for (Item<?> item : this.items) {
            ItemDefinition itemDefinition;
            if (item.getDefinition() != null && !force || (itemDefinition = this.determineItemDefinition(item.getName(), definition)) == null && item.getDefinition() != null && item.getDefinition().isDynamic()) continue;
            item.applyDefinition(itemDefinition);
        }
    }

    private ItemDefinition determineItemDefinition(QName itemName, PrismContainerDefinition<T> containerDefinition) throws SchemaException {
        ItemDefinition itemDefinition = containerDefinition.findItemDefinition(itemName);
        if (itemDefinition == null) {
            if (containerDefinition.isRuntimeSchema()) {
                PrismContext prismContext = this.getPrismContext();
                if (prismContext != null) {
                    itemDefinition = prismContext.getSchemaRegistry().resolveGlobalItemDefinition(itemName);
                }
            } else {
                throw new SchemaException("No definition for item " + itemName + " in " + this.getParent());
            }
        }
        return itemDefinition;
    }

    public void revive(PrismContext prismContext) {
        for (Item<?> item : this.items) {
            item.revive(prismContext);
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public void checkConsistenceInternal(Itemable rootItem, PropertyPath parentPath) {
        PropertyPath myPath = this.getPath(parentPath);
        if (this.items == null && this.rawElements == null) {
            throw new IllegalStateException("Neither items nor raw elements specified in container value " + this + " (" + myPath + " in " + rootItem + ")");
        }
        if (this.items != null && this.rawElements != null) {
            throw new IllegalStateException("Both items and raw elements specified in container value " + this + " (" + myPath + " in " + rootItem + ")");
        }
        if (this.items != null) {
            for (Item<?> item : this.items) {
                if (item == null) {
                    throw new IllegalStateException("Null item in container value " + this + " (" + myPath + " in " + rootItem + ")");
                }
                if (item.getParent() == null) {
                    throw new IllegalStateException("No parent for item " + item + " in container value " + this + " (" + myPath + " in " + rootItem + ")");
                }
                if (item.getParent() != this) {
                    throw new IllegalStateException("Wrong parent for item " + item + " in container value " + this + " (" + myPath + " in " + rootItem + "), " + "bad parent: " + item.getParent());
                }
                item.checkConsistenceInternal(rootItem, myPath);
            }
        }
    }

    public void assertDefinitions(String sourceDescription) throws SchemaException {
        this.assertDefinitions(false, sourceDescription);
    }

    public void assertDefinitions(boolean tolerateRaw, String sourceDescription) throws SchemaException {
        for (Item<?> item : this.getItems()) {
            item.assertDefinitions(tolerateRaw, "value(" + this.getId() + ") in " + sourceDescription);
        }
    }

    @Override
    public PrismContainerValue<T> clone() {
        PrismContainerValue<T> clone = new PrismContainerValue<T>(this.getType(), this.getSource(), (PrismContainerable)this.getParent(), this.getId());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PrismContainerValue<T> clone) {
        super.copyValues(clone);
        clone.id = this.id;
        for (Item<?> item : this.items) {
            Item clonedItem = item.clone();
            clonedItem.setParent(clone);
            clone.items.add(clonedItem);
        }
        clone.rawElements = this.rawElements;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.items == null ? 0 : MiscUtil.unorderedCollectionHashcode(this.items));
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismContainerValue other = (PrismContainerValue)obj;
        return this.equals((PrismValue)this, (PrismValue)other);
    }

    @Override
    public boolean equals(PrismValue thisValue, PrismValue otherValue) {
        if (thisValue instanceof PrismContainerValue && otherValue instanceof PrismContainerValue) {
            return this.equals((PrismContainerValue)thisValue, (PrismContainerValue)otherValue);
        }
        return false;
    }

    public boolean equals(PrismContainerValue<T> thisValue, PrismContainerValue<T> otherValue) {
        if (thisValue.id == null ? otherValue.id != null : !thisValue.id.equals(otherValue.id)) {
            return false;
        }
        return !(thisValue.items == null ? otherValue.items != null : !this.equalsItems(thisValue, otherValue, false));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PCV(");
        sb.append(this.getId());
        if (this.rawElements != null) {
            sb.append(", ");
            sb.append(this.rawElements.size());
            sb.append(" raw elements");
        }
        sb.append("):");
        sb.append(this.getItems());
        return sb.toString();
    }

    public String dump() {
        return this.debugDump();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append("PCV").append(": ").append(DebugUtil.prettyPrint((Object)this.getId()));
        Iterator<Item<?>> i2 = this.getItems().iterator();
        if (i2.hasNext()) {
            sb.append("\n");
        }
        while (i2.hasNext()) {
            Item<?> item = i2.next();
            sb.append(item.debugDump(indent + 1));
            if (!i2.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

