/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.resource;

import java.io.InputStream;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.jaxrx.core.ResponseBuilder;
import org.jaxrx.core.Systems;
import org.jaxrx.resource.AResource;

@Path(value="/")
public final class JaxRxResource
extends AResource {
    @GET
    @Produces(value={"application/xml"})
    public StreamingOutput getRoot() {
        ArrayList<String> resources = new ArrayList<String>();
        resources.addAll(Systems.getSystems().keySet());
        return ResponseBuilder.buildDOMResponse(resources);
    }

    @Path(value="/{system}")
    @GET
    @Produces(value={"application/xml"})
    public StreamingOutput getSystem(@PathParam(value="system") String system) {
        Systems.getInstance(system);
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("jax-rx");
        return ResponseBuilder.buildDOMResponse(resources);
    }

    @Path(value="/{system}/jax-rx")
    @GET
    public Response getResource(@PathParam(value="system") String system, @Context UriInfo uri, @Context HttpHeaders headers) {
        return this.getResource(system, uri, "", headers);
    }

    @Path(value="/{system}/jax-rx")
    @POST
    @Consumes(value={"application/query+xml"})
    public Response postQuery(@PathParam(value="system") String system, InputStream input, @Context HttpHeaders headers) {
        return this.postQuery(system, input, "", headers);
    }
}

