/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Commands;
import org.basex.core.cmd.Check;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.DBNode;
import org.basex.query.item.DBNodeSeq;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Seq;
import org.basex.query.item.Uri;
import org.basex.query.item.Value;
import org.basex.query.util.Err;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class QueryResources {
    private final QueryContext ctx;
    private Data[] data = new Data[1];
    private int datas;
    private Value[] coll = new Value[1];
    private byte[][] collName = new byte[1][];
    private int colls;

    QueryResources(QueryContext qc) {
        this.ctx = qc;
    }

    void compile(Nodes nodes) throws QueryException {
        Data d = nodes.data;
        if (!this.ctx.context.perm(1, d.meta)) {
            Err.PERMNO.thrw(null, new Object[]{Commands.CmdPerm.READ});
        }
        this.ctx.value = d.empty() ? Empty.SEQ : DBNodeSeq.get(new IntList(nodes.list), d, nodes.root, nodes.root);
        this.addCollection(nodes.root ? this.ctx.value : DBNodeSeq.get(d.doc(), d, true, true), Token.token(d.meta.name));
        this.addData(d);
    }

    void close() throws IOException {
        int d = this.ctx.nodes != null ? 1 : 0;
        while (d < this.datas) {
            Close.close(this.data[d], this.ctx.context);
            ++d;
        }
        this.datas = 0;
    }

    public Data data(byte[] name, InputInfo ii) throws QueryException {
        String in = Token.string(name);
        int d = 0;
        while (d < this.datas) {
            if (this.data[d].meta.name.equals(in)) {
                return this.data[d];
            }
            ++d;
        }
        try {
            return this.addData(Open.open(in, this.ctx.context));
        }
        catch (IOException ex) {
            throw Err.NODB.thrw(ii, in);
        }
    }

    public Data data(byte[] input, boolean col, InputInfo ii) throws QueryException {
        String in = Token.string(input);
        int d = 0;
        while (d < this.datas) {
            if (this.data[d].meta.name.equals(in)) {
                return this.data[d];
            }
            ++d;
        }
        IO io = IO.get(in);
        int d2 = 0;
        while (d2 < this.datas) {
            if (IO.get(this.data[d2].meta.original).eq(io)) {
                return this.data[d2];
            }
            ++d2;
        }
        Data d22 = this.doc(in, this.ctx.baseURI == Uri.EMPTY, col, ii);
        if (d22 == null) {
            d22 = this.doc(this.ctx.base().merge(in).path(), true, col, ii);
        }
        return this.addData(d22);
    }

    public Value collection(byte[] input, InputInfo ii) throws QueryException {
        int c = 0;
        if (input == null) {
            if (this.colls == 0) {
                Err.NODEFCOLL.thrw(ii, new Object[0]);
            }
        } else {
            if (Token.contains(input, 60) || Token.contains(input, 92)) {
                Err.COLLINV.thrw(ii, new Object[]{input});
            }
            while (c < this.colls && !Token.eq(this.collName[c], input)) {
                ++c;
            }
            if (c == this.colls) {
                int s = Token.indexOf(input, 47);
                if (s == -1) {
                    this.addCollection(this.data(input, true, ii), Token.EMPTY);
                } else {
                    this.addCollection(this.data(Token.substring(input, 0, s), true, ii), Token.substring(input, s + 1));
                }
            }
        }
        return this.coll[c];
    }

    public void addCollection(byte[] name, byte[][] inputs) throws QueryException {
        int ns = inputs.length;
        Item[] nodes = new DBNode[ns];
        int n = 0;
        while (n < ns) {
            nodes[n] = new DBNode(this.data(inputs[n], true, null), 0, 0);
            ++n;
        }
        this.addCollection(Seq.get(nodes, ns), name);
    }

    private void addCollection(Data d, byte[] path) {
        this.addCollection(DBNodeSeq.get(d.doc(Token.string(path)), d, true, path.length == 0), Token.token(d.meta.name));
    }

    private Data doc(String path, boolean err, boolean col, InputInfo ii) throws QueryException {
        try {
            return Check.check(this.ctx.context, path);
        }
        catch (IOException ex) {
            if (err) {
                (col ? Err.NOCOLL : Err.NODOC).thrw(ii, ex);
            }
            return null;
        }
    }

    private Data addData(Data d) {
        if (this.datas == this.data.length) {
            Data[] tmp = new Data[Array.newSize(this.datas)];
            System.arraycopy(this.data, 0, tmp, 0, this.datas);
            this.data = tmp;
        }
        this.data[this.datas++] = d;
        return d;
    }

    private void addCollection(Value nodes, byte[] name) {
        if (this.colls == this.coll.length) {
            this.coll = Arrays.copyOf(this.coll, this.colls << 1);
            this.collName = Array.copyOf(this.collName, this.colls << 1);
        }
        this.coll[this.colls] = nodes;
        this.collName[this.colls++] = name;
    }
}

