/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXFileChooser;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.TableLayout;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.Language;
import org.basex.util.list.StringList;

final class DialogFT
extends BaseXBack {
    private static final int F_LANG = 0;
    private static final int F_WILD = 1;
    private static final int F_STEM = 2;
    private static final int F_CASE = 3;
    private static final int F_DIA = 4;
    private static final int F_SCORE = 5;
    private static final int F_STOP = 6;
    private static final int FLAGS = 7;
    private final Dialog dialog;
    private final BaseXCheckBox[] check = new BaseXCheckBox[7];
    private final BaseXLabel[] labels = new BaseXLabel[7];
    private final BaseXCombo language;
    private final BaseXCombo scoring;
    private final BaseXTextField swpath;
    private final BaseXButton swbrowse;

    DialogFT(Dialog d, boolean create) {
        this.dialog = d;
        this.layout(new TableLayout(create ? 9 : 16, 1));
        Prop prop = d.gui.context.prop;
        this.add(new BaseXLabel(Text.FTINDEXINFO, true, false));
        String sw = prop.get(Prop.STOPWORDS);
        String[] cb = new String[]{Text.CREATELN, Text.CREATEWC, Text.CREATEST, Text.CREATECS, Text.CREATEDC, Text.CREATESCT, Text.CREATESW};
        String[] desc = new String[]{Text.FTLANGINFO, Text.WCINDEXINFO, Text.FTSTEMINFO, Text.FTCSINFO, Text.FTDCINFO, Text.FTSCINFO, Text.FTSWINFO};
        boolean[] val = new boolean[]{!prop.get(Prop.LANGUAGE).isEmpty(), prop.is(Prop.WILDCARDS), prop.is(Prop.STEMMING), prop.is(Prop.CASESENS), prop.is(Prop.DIACRITICS), prop.num(Prop.SCORING) > 0, !sw.isEmpty()};
        int f = 0;
        while (f < this.check.length) {
            this.check[f] = new BaseXCheckBox(cb[f], val[f], create ? 1 : 0, d);
            if (!create) {
                this.labels[f] = new BaseXLabel(desc[f], true, false);
            } else {
                this.check[f].setToolTipText(desc[f]);
            }
            ++f;
        }
        BaseXBack b1 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        b1.add(this.check[0]);
        StringList langs = new StringList();
        for (Language l : FTLexer.languages()) {
            langs.add(l.toString());
        }
        this.language = new BaseXCombo(d, langs.toArray());
        Language ln = Language.get(prop.get(Prop.LANGUAGE));
        this.language.setSelectedItem((ln == null ? Language.DEFAULT : ln).toString());
        b1.add(this.language);
        this.add(b1);
        if (!create) {
            this.add(this.labels[0]);
        }
        int f2 = 1;
        while (f2 < 5) {
            this.add(this.check[f2]);
            if (!create) {
                this.add(this.labels[f2]);
            }
            ++f2;
        }
        BaseXBack b2 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        b2.add(this.check[5]);
        this.scoring = new BaseXCombo(d, Text.CREATESCT1, Text.CREATESCT2);
        b2.add(this.scoring);
        this.add(b2);
        if (!create) {
            this.add(this.labels[5]);
        }
        this.add(this.check[6]);
        BaseXBack b3 = new BaseXBack(new TableLayout(1, 2, 8, 0));
        this.swpath = new BaseXTextField(sw.isEmpty() ? d.gui.gprop.get(GUIProp.STOPPATH) : sw, d);
        b3.add(this.swpath);
        this.swbrowse = new BaseXButton(Text.BUTTONBROWSE, d);
        this.swbrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogFT.this.chooseStop();
            }
        });
        b3.add(this.swbrowse);
        this.add(b3);
        if (!create) {
            this.add(this.labels[6]);
        }
    }

    void chooseStop() {
        GUIProp gprop = this.dialog.gui.gprop;
        BaseXFileChooser fc = new BaseXFileChooser(Text.CREATETITLE, gprop.get(GUIProp.STOPPATH), this.dialog.gui);
        IOFile file = fc.select(BaseXFileChooser.Mode.FOPEN);
        if (file != null) {
            this.swpath.setText(file.path());
            gprop.set(GUIProp.STOPPATH, file.path());
        }
    }

    void action(boolean ftx) {
        boolean exists;
        int f = 0;
        while (f < this.check.length) {
            this.check[f].setEnabled(ftx);
            if (this.labels[f] != null) {
                this.labels[f].setEnabled(ftx);
            }
            ++f;
        }
        this.language.setEnabled(ftx && this.check[0].isSelected());
        this.scoring.setEnabled(ftx && this.check[5].isSelected());
        this.swbrowse.setEnabled(ftx && this.check[6].isSelected());
        this.swpath.setEnabled(ftx && this.check[6].isSelected());
        String sw = this.swpath.getText().trim();
        IO file = IO.get(sw);
        boolean bl = exists = !sw.isEmpty() && file.exists();
        if (exists) {
            this.dialog.gui.gprop.set(GUIProp.STOPPATH, sw);
        }
    }

    void close() {
        GUI gui = this.dialog.gui;
        gui.set(Prop.LANGUAGE, this.check[0].isSelected() ? Language.get(this.language.getSelectedItem().toString()).name() : "");
        gui.set(Prop.STEMMING, this.check[2].isSelected());
        gui.set(Prop.CASESENS, this.check[3].isSelected());
        gui.set(Prop.DIACRITICS, this.check[4].isSelected());
        gui.set(Prop.WILDCARDS, this.check[1].isSelected());
        gui.set(Prop.SCORING, this.check[5].isSelected() ? this.scoring.getSelectedIndex() + 1 : 0);
        gui.set(Prop.STOPWORDS, this.check[6].isSelected() ? this.swpath.getText() : "");
    }
}

