/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.basex.build.xml.XMLParser;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class HTMLParser
extends XMLParser {
    private static final Class<?> READER = Reflect.find("org.ccil.cowan.tagsoup.Parser");
    private static final Constructor<?> WRITER = Reflect.find(Reflect.find("org.ccil.cowan.tagsoup.XMLWriter"), Writer.class);

    public static boolean available() {
        return READER != null;
    }

    public HTMLParser(IO source, String target, Prop pr) throws IOException {
        super(HTMLParser.toXML(source), target, pr);
    }

    private static IO toXML(IO io) {
        if (READER == null) {
            return io;
        }
        try {
            byte[] content = io.content();
            ArrayInput ai = new ArrayInput(content);
            String enc = ai.encoding();
            content = ai.token().toArray();
            byte[] encoding = Token.token("charset=");
            int cs = Token.indexOf(content, encoding);
            if (cs > 0) {
                int ce = cs += encoding.length;
                while (++ce < content.length && content[ce] > 40) {
                }
                enc = Token.string(Token.substring(content, cs, ce));
            }
            InputSource is = new InputSource(new ByteArrayInputStream(content));
            is.setEncoding(Token.supported(enc) ? Token.normEncoding(enc, null) : "UTF-8");
            StringWriter sw = new StringWriter();
            XMLReader reader = (XMLReader)Reflect.get(READER);
            reader.setContentHandler((ContentHandler)Reflect.get(WRITER, sw));
            reader.parse(is);
            return new IOContent(Token.token(sw.toString()), io.name());
        }
        catch (Exception ex) {
            Util.debug(ex);
            return io;
        }
    }
}

