/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.audit.api;

import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

public class AuditEventRecord {
    private Long timestamp;
    private String eventIdentifier;
    private String sessionIdentifier;
    private String taskIdentifier;
    private String taskOID;
    private String hostIdentifier;
    private PrismObject<UserType> initiator;
    private PrismObject<? extends ObjectType> target;
    private PrismObject<UserType> targetOwner;
    private AuditEventType eventType;
    private AuditEventStage eventStage;
    private Collection<ObjectDelta<?>> deltas = new ArrayList();
    private String channel;
    private OperationResultStatus outcome;
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public AuditEventRecord() {
    }

    public AuditEventRecord(AuditEventType eventType) {
        this.eventType = eventType;
    }

    public AuditEventRecord(AuditEventType eventType, AuditEventStage eventStage) {
        this.eventType = eventType;
        this.eventStage = eventStage;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void clearTimestamp() {
        this.timestamp = null;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public void setEventIdentifier(String eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
    }

    public String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    public void setSessionIdentifier(String sessionIdentifier) {
        this.sessionIdentifier = sessionIdentifier;
    }

    public String getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public void setTaskIdentifier(String taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    public String getTaskOID() {
        return this.taskOID;
    }

    public void setTaskOID(String taskOID) {
        this.taskOID = taskOID;
    }

    public String getHostIdentifier() {
        return this.hostIdentifier;
    }

    public void setHostIdentifier(String hostIdentifier) {
        this.hostIdentifier = hostIdentifier;
    }

    public PrismObject<UserType> getInitiator() {
        return this.initiator;
    }

    public void setInitiator(PrismObject<UserType> initiator) {
        this.initiator = initiator;
    }

    public PrismObject<? extends ObjectType> getTarget() {
        return this.target;
    }

    public void setTarget(PrismObject<? extends ObjectType> target) {
        this.target = target;
    }

    public PrismObject<UserType> getTargetOwner() {
        return this.targetOwner;
    }

    public void setTargetOwner(PrismObject<UserType> targetOwner) {
        this.targetOwner = targetOwner;
    }

    public AuditEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(AuditEventType eventType) {
        this.eventType = eventType;
    }

    public AuditEventStage getEventStage() {
        return this.eventStage;
    }

    public void setEventStage(AuditEventStage eventStage) {
        this.eventStage = eventStage;
    }

    public Collection<ObjectDelta<?>> getDeltas() {
        return this.deltas;
    }

    public void addDelta(ObjectDelta<?> delta) {
        this.deltas.add(delta);
    }

    public void addDeltas(Collection<ObjectDelta<? extends ObjectType>> deltasToAdd) {
        this.deltas.addAll(deltasToAdd);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void clearDeltas() {
        this.deltas.clear();
    }

    public OperationResultStatus getOutcome() {
        return this.outcome;
    }

    public void setOutcome(OperationResultStatus outcome) {
        this.outcome = outcome;
    }

    public void setResult(OperationResult result) {
        this.outcome = result.getStatus();
    }

    public String toString() {
        return "AUDIT[" + AuditEventRecord.formatTimestamp(this.timestamp) + " eid=" + this.eventIdentifier + " sid=" + this.sessionIdentifier + ", tid=" + this.taskIdentifier + " toid=" + this.taskOID + ", hid=" + this.hostIdentifier + ", I=" + AuditEventRecord.formatObject(this.initiator) + ", T=" + AuditEventRecord.formatObject(this.target) + ", TO=" + AuditEventRecord.formatObject(this.targetOwner) + ", et=" + (Object)((Object)this.eventType) + ", es=" + (Object)((Object)this.eventStage) + ", D=" + this.deltas + ", ch=" + this.channel + "o=" + this.outcome + "]";
    }

    private static String formatTimestamp(Long timestamp) {
        if (timestamp == null) {
            return "null";
        }
        return TIMESTAMP_FORMAT.format(new Date(timestamp));
    }

    private static String formatObject(PrismObject<? extends ObjectType> object) {
        if (object == null) {
            return "null";
        }
        return object.toString();
    }
}

