/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserManager
extends AbstractManager {
    public User createNewUser(String userId) {
        return new UserEntity(userId);
    }

    public void insertUser(User user) {
        this.getDbSqlSession().insert((PersistentObject)((Object)user));
    }

    public void updateUser(User updatedUser) {
        UserEntity persistentUser = this.findUserById(updatedUser.getId());
        persistentUser.update((UserEntity)updatedUser);
    }

    public UserEntity findUserById(String userId) {
        return (UserEntity)this.getDbSqlSession().selectOne("selectUserById", userId);
    }

    public void deleteUser(String userId) {
        UserEntity user = this.findUserById(userId);
        if (user != null) {
            if (user.getPictureByteArrayId() != null) {
                this.getDbSqlSession().delete(ByteArrayEntity.class, user.getPictureByteArrayId());
            }
            List identityInfos = this.getDbSqlSession().selectList("selectIdentityInfoByUserId", userId);
            for (IdentityInfoEntity identityInfo : identityInfos) {
                this.getIdentityInfoManager().deleteIdentityInfo(identityInfo);
            }
            this.getDbSqlSession().delete("deleteMembershipsByUserId", (Object)userId);
            this.getDbSqlSession().delete("deleteUser", (Object)userId);
        }
    }

    public List<User> findUserByQueryCriteria(Object query, Page page) {
        return this.getDbSqlSession().selectList("selectUserByQueryCriteria", query, page);
    }

    public long findUserCountByQueryCriteria(Object query) {
        return (Long)this.getDbSqlSession().selectOne("selectUserCountByQueryCriteria", query);
    }

    public List<Group> findGroupsByUser(String userId) {
        return this.getDbSqlSession().selectList("selectGroupsByUserId", userId);
    }

    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("key", key);
        return (IdentityInfoEntity)this.getDbSqlSession().selectOne("selectIdentityInfoByUserIdAndKey", parameters);
    }

    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("type", type);
        return this.getDbSqlSession().getSqlSession().selectList("selectIdentityInfoKeysByUserIdAndType", parameters);
    }

    public Boolean checkPassword(String userId, String password) {
        UserEntity user = this.findUserById(userId);
        if (user != null && password != null && password.equals(user.getPassword())) {
            return true;
        }
        return false;
    }
}

