/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.interceptor;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtaTransactionInterceptor
extends CommandInterceptor {
    private static final Logger LOGGER = Logger.getLogger(JtaTransactionInterceptor.class.getName());
    private final TransactionManager transactionManager;
    private final boolean requiresNew;

    public JtaTransactionInterceptor(TransactionManager transactionManager, boolean requiresNew) {
        this.transactionManager = transactionManager;
        this.requiresNew = requiresNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Command<T> command) {
        T t;
        Transaction oldTx = null;
        try {
            T result;
            boolean isNew;
            boolean existing = this.isExisting();
            boolean bl = isNew = !existing || this.requiresNew;
            if (existing && this.requiresNew) {
                oldTx = this.doSuspend();
            }
            if (isNew) {
                this.doBegin();
            }
            try {
                result = this.next.execute(command);
            }
            catch (RuntimeException ex) {
                this.doRollback(isNew);
                throw ex;
            }
            catch (Error err) {
                this.doRollback(isNew);
                throw err;
            }
            catch (Exception ex) {
                this.doRollback(isNew);
                throw new UndeclaredThrowableException(ex, "TransactionCallback threw undeclared checked exception");
            }
            if (isNew) {
                this.doCommit();
            }
            t = result;
            this.doResume(oldTx);
        }
        catch (Throwable throwable) {
            this.doResume(oldTx);
            throw throwable;
        }
        return t;
    }

    private void doBegin() {
        try {
            this.transactionManager.begin();
        }
        catch (NotSupportedException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to begin transaction", e);
        }
    }

    private boolean isExisting() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to retrieve transaction status", e);
        }
    }

    private Transaction doSuspend() {
        try {
            return this.transactionManager.suspend();
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to suspend transaction", e);
        }
    }

    private void doResume(Transaction tx) {
        if (tx != null) {
            try {
                this.transactionManager.resume(tx);
            }
            catch (SystemException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
            catch (InvalidTransactionException e) {
                throw new TransactionException("Unable to resume transaction", e);
            }
        }
    }

    private void doCommit() {
        try {
            this.transactionManager.commit();
        }
        catch (HeuristicMixedException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (HeuristicRollbackException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (RollbackException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (SystemException e) {
            throw new TransactionException("Unable to commit transaction", e);
        }
        catch (RuntimeException e) {
            this.doRollback(true);
            throw e;
        }
        catch (Error e) {
            this.doRollback(true);
            throw e;
        }
    }

    private void doRollback(boolean isNew) {
        try {
            if (isNew) {
                this.transactionManager.rollback();
            } else {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            LOGGER.log(Level.FINE, "Error when rolling back transaction", e);
        }
    }

    private static class TransactionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private TransactionException() {
        }

        private TransactionException(String s) {
            super(s);
        }

        private TransactionException(String s, Throwable throwable) {
            super(s, throwable);
        }

        private TransactionException(Throwable throwable) {
            super(throwable);
        }
    }
}

