/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.jaxrx;

import com.sun.jersey.core.spi.factory.ResponseBuilderImpl;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import org.basex.BaseXServer;
import org.basex.api.jaxrx.BXJaxRx;
import org.basex.core.MainProp;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.server.ClientSession;
import org.basex.util.Args;
import org.basex.util.Base64;
import org.basex.util.Util;
import org.jaxrx.JettyServer;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.ResourcePath;

public final class JaxRxServer
extends BaseXServer {
    static final String USER = "org.basex.user";
    static final String PASSWORD = "org.basex.password";
    static final String SERVERPORT = "org.basex.serverport";
    static final String JAXRXPATH = "org.basex.jaxrxpath";
    static final String LOCAL = "org.basex.jaxrx.local";
    static final String SERIALIZER = "org.jaxrx.parameter.output";
    static final String JAXRX = "JAX-RX";
    private JettyServer jetty;
    private String user;
    private String pass;

    public static void main(String[] args) {
        new JaxRxServer(args);
    }

    public JaxRxServer(String ... args) {
        super(args);
        if (!this.success || this.service) {
            return;
        }
        this.set(JAXRXPATH, this.context.mprop.get(MainProp.JAXRXPATH), false);
        this.set(SERVERPORT, this.context.mprop.num(MainProp.SERVERPORT), false);
        this.set(SERIALIZER, this.context.prop.get(Prop.SERIALIZER), false);
        String p = this.pass;
        if (this.user != null) {
            while (p == null) {
                Util.out((Object)(String.valueOf(Text.SERVERPW) + ": "), (Object[])new Object[0]);
                p = this.password();
            }
        }
        this.set(USER, this.user == null ? "" : this.user, this.user != null);
        this.set(PASSWORD, p == null ? "" : p, p != null);
        try {
            if (!System.getProperty(USER).isEmpty()) {
                JaxRxServer.login(null).close();
            }
        }
        catch (Exception ex) {
            Util.errln((Object)ex.getMessage(), (Object[])new Object[0]);
            this.quit(false);
            return;
        }
        this.set("org.jaxrx.systemName", Text.NAMELC, false);
        this.set("org.jaxrx.systemPath", BXJaxRx.class.getName(), false);
        try {
            this.jetty = new JettyServer(this.context.mprop.num(MainProp.JAXRXPORT));
            Util.outln((Object)("JAX-RX " + Text.SERVERSTART), (Object[])new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Util.server((Exception)ex);
        }
    }

    public void quit(boolean u) {
        super.quit(u);
        if (this.jetty != null) {
            this.jetty.stop();
        }
    }

    public void stop() {
        this.quit(false);
    }

    private void set(String key, Object value, boolean force) {
        if (force || System.getProperty(key) == null) {
            System.setProperty(key, value.toString());
        }
    }

    static ClientSession login(ResourcePath path) throws Exception {
        String[] id = JaxRxServer.updateIdentity(path);
        if (id == null) {
            id = new String[]{System.getProperty(USER), System.getProperty(PASSWORD)};
        }
        int p = Integer.parseInt(System.getProperty(SERVERPORT));
        return new ClientSession("localhost", p, id[0], id[1]);
    }

    private static String[] updateIdentity(ResourcePath path) {
        Iterator iterator;
        if (path == null) {
            return null;
        }
        HttpHeaders headers = path.getHttpHeaders();
        List authorization = headers.getRequestHeader("Authorization");
        if (authorization != null && (iterator = authorization.iterator()).hasNext()) {
            String value = (String)iterator.next();
            String[] values = value.split(" ");
            if (values[0].equalsIgnoreCase("basic")) {
                String[] cred = Base64.decode((String)values[1]).split(":", 2);
                if (cred.length < 2) {
                    ResponseBuilderImpl rb = new ResponseBuilderImpl();
                    rb.header("WWW-Authenticate", (Object)"Basic ");
                    rb.status(401);
                    rb.entity((Object)"No password specified.");
                    throw new JaxRxException(rb.build());
                }
                return cred;
            }
            throw new JaxRxException(500, "Unsupported authorization mode.");
        }
        return null;
    }

    public boolean parseArguments(String[] args) {
        Args arg = new Args(args, (Object)this, Text.JAXRXINFO, Util.info((Object)Text.CONSOLE, (Object[])new Object[]{JAXRX}));
        boolean daemon = false;
        StringBuilder serial = new StringBuilder();
        while (arg.more()) {
            if (arg.dash()) {
                char c = arg.next();
                if (c == 'D') {
                    daemon = true;
                    continue;
                }
                if (c == 'j') {
                    this.context.mprop.set(MainProp.JAXRXPORT, arg.num());
                    continue;
                }
                if (c == 'p') {
                    this.set(SERVERPORT, arg.num(), true);
                    continue;
                }
                if (c == 'P') {
                    this.pass = arg.string();
                    continue;
                }
                if (c == 's') {
                    this.service = !daemon;
                    continue;
                }
                if (c == 'S') {
                    if (serial.length() != 0) {
                        serial.append(',');
                    }
                    serial.append(arg);
                    this.set(SERIALIZER, serial, true);
                    continue;
                }
                if (c == 'U') {
                    this.user = arg.string();
                    continue;
                }
                if (c == 'z') {
                    this.quiet = true;
                    continue;
                }
                arg.check(false);
                continue;
            }
            arg.check(false);
            if (!arg.string().equalsIgnoreCase("stop")) continue;
            JaxRxServer.stop((int)this.context.mprop.num(MainProp.SERVERPORT), (int)this.context.mprop.num(MainProp.EVENTPORT));
            return false;
        }
        return arg.finish();
    }
}

