/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.transaction.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.transaction.Transaction;
import org.apache.ibatis.transaction.TransactionException;

public class JdbcTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog(JdbcTransaction.class);
    protected Connection connection;

    public JdbcTransaction(Connection connection, boolean desiredAutoCommit) {
        this.connection = connection;
        this.setDesiredAutoCommit(desiredAutoCommit);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void commit() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (!this.connection.getAutoCommit()) {
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        this.resetAutoCommit();
        this.connection.close();
    }

    protected void setDesiredAutoCommit(boolean desiredAutoCommit) {
        try {
            if (this.connection.getAutoCommit() != desiredAutoCommit) {
                this.connection.setAutoCommit(desiredAutoCommit);
            }
        }
        catch (SQLException e) {
            throw new TransactionException("Error configuring AutoCommit.  Your driver may not support getAutoCommit() or setAutoCommit(). Requested setting: " + desiredAutoCommit + ".  Cause: " + e, e);
        }
    }

    protected void resetAutoCommit() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.debug("Error resetting autocommit to true before closing the connection.  Cause: " + e);
        }
    }
}

