/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration.commands;

import java.io.File;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.MigrationReader;
import org.apache.ibatis.migration.commands.BaseCommand;

public class BootstrapCommand
extends BaseCommand {
    public BootstrapCommand(File repository, String environment, boolean force) {
        super(repository, environment, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String ... params) {
        block7: {
            try {
                if (this.changelogExists() && !this.force) {
                    this.printStream.println("For your safety, the bootstrap SQL script will only run before migrations are applied (i.e. before the changelog exists).  If you're certain, you can run it using the --force option.");
                    break block7;
                }
                File bootstrap = this.scriptFile("bootstrap.sql");
                if (bootstrap.exists()) {
                    this.printStream.println(this.horizontalLine("Applying: bootstrap.sql", 80));
                    ScriptRunner runner = this.getScriptRunner();
                    try {
                        runner.runScript(new MigrationReader(this.scriptFileReader(bootstrap), false, this.environmentProperties()));
                    }
                    finally {
                        runner.closeConnection();
                    }
                    this.printStream.println();
                    break block7;
                }
                this.printStream.println("Error, could not run bootstrap.sql.  The file does not exist.");
            }
            catch (Exception e) {
                throw new MigrationException("Error running bootstrapper.  Cause: " + e, e);
            }
        }
    }
}

