/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.migration;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.ibatis.migration.MigrationException;
import org.apache.ibatis.migration.commands.BootstrapCommand;
import org.apache.ibatis.migration.commands.DownCommand;
import org.apache.ibatis.migration.commands.InitializeCommand;
import org.apache.ibatis.migration.commands.NewCommand;
import org.apache.ibatis.migration.commands.PendingCommand;
import org.apache.ibatis.migration.commands.ScriptCommand;
import org.apache.ibatis.migration.commands.StatusCommand;
import org.apache.ibatis.migration.commands.UpCommand;
import org.apache.ibatis.migration.commands.VersionCommand;

public class CommandLine {
    private static final String PATH_PREFIX = "--path=";
    private static final String ENV_PREFIX = "--env=";
    private static final String FORCE = "--force";
    private static final String TRACE = "--trace";
    private static final String HELP = "--help";
    private static final String TEMPLATE_PREFIX = "--template=";
    private static final String INIT = "init";
    private static final String BOOTSTRAP = "bootstrap";
    private static final String NEW = "new";
    private static final String UP = "up";
    private static final String DOWN = "down";
    private static final String PENDING = "pending";
    private static final String SCRIPT = "script";
    private static final String VERSION = "version";
    private static final String STATUS = "status";
    private static final Set<String> KNOWN_COMMANDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("init", "new", "up", "version", "down", "pending", "status", "bootstrap", "script")));
    private PrintStream printStream = System.out;
    private File repository;
    private String environment;
    private String template;
    private boolean force;
    private boolean trace;
    private String command;
    private String params;
    private String parseError;
    private boolean help;

    public CommandLine(String[] args) {
        this.parse(args);
        this.validate();
    }

    public void setPrintStream(PrintStream out) {
        this.printStream = out;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        block9: {
            boolean error = false;
            try {
                if (this.help) {
                    this.printUsage();
                    break block9;
                }
                if (this.parseError != null) {
                    error = true;
                    this.printError();
                    this.printUsage();
                    break block9;
                }
                try {
                    this.runCommand();
                }
                catch (Exception e) {
                    error = true;
                    this.printStream.println("\nERROR: " + e.getMessage());
                    if (this.trace) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                this.printStream.flush();
                if (error) {
                    System.exit(1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runCommand() {
        this.printStream.println("------------------------------------------------------------------------");
        this.printStream.printf("MyBatis Migrations - %s%n", this.command);
        this.printStream.println("------------------------------------------------------------------------");
        long start = System.currentTimeMillis();
        int exit = 0;
        try {
            try {
                if (INIT.equals(this.command)) {
                    new InitializeCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (BOOTSTRAP.equals(this.command)) {
                    new BootstrapCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (NEW.equals(this.command)) {
                    new NewCommand(this.repository, this.environment, this.template, this.force).execute(this.params);
                } else if (STATUS.equals(this.command)) {
                    new StatusCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (UP.equals(this.command)) {
                    new UpCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (VERSION.equals(this.command)) {
                    new VersionCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (PENDING.equals(this.command)) {
                    new PendingCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (DOWN.equals(this.command)) {
                    new DownCommand(this.repository, this.environment, this.force).execute(this.params);
                } else if (SCRIPT.equals(this.command)) {
                    new ScriptCommand(this.repository, this.environment, this.force).execute(this.params);
                } else {
                    String match = null;
                    for (String knownCommand : KNOWN_COMMANDS) {
                        if (!knownCommand.startsWith(this.command)) continue;
                        if (match != null) {
                            throw new MigrationException("Ambiguous command shortcut: " + this.command);
                        }
                        match = knownCommand;
                    }
                    if (match == null) throw new MigrationException("Attempt to execute unknown command: " + this.command);
                    this.command = match;
                    this.runCommand();
                }
                Object var8_7 = null;
                this.printStream.println("------------------------------------------------------------------------");
            }
            catch (Throwable t) {
                exit = -1;
                t.printStackTrace(this.printStream);
                Object var8_8 = null;
                this.printStream.println("------------------------------------------------------------------------");
                this.printStream.printf("MyBatis Migrations %s%n", exit < 0 ? "FAILURE" : "SUCCESS");
                this.printStream.printf("Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
                this.printStream.printf("Finished at: %s%n", new Date());
                Runtime runtime = Runtime.getRuntime();
                int megaUnit = 0x100000;
                this.printStream.printf("Final Memory: %sM/%sM%n", (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L);
                this.printStream.println("------------------------------------------------------------------------");
                System.exit(exit);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.printStream.println("------------------------------------------------------------------------");
            this.printStream.printf("MyBatis Migrations %s%n", exit < 0 ? "FAILURE" : "SUCCESS");
            this.printStream.printf("Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
            this.printStream.printf("Finished at: %s%n", new Date());
            Runtime runtime = Runtime.getRuntime();
            int megaUnit = 0x100000;
            this.printStream.printf("Final Memory: %sM/%sM%n", (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L);
            this.printStream.println("------------------------------------------------------------------------");
            System.exit(exit);
            throw throwable;
        }
        this.printStream.printf("MyBatis Migrations %s%n", exit < 0 ? "FAILURE" : "SUCCESS");
        this.printStream.printf("Total time: %ss%n", (System.currentTimeMillis() - start) / 1000L);
        this.printStream.printf("Finished at: %s%n", new Date());
        Runtime runtime = Runtime.getRuntime();
        int megaUnit = 0x100000;
        this.printStream.printf("Final Memory: %sM/%sM%n", (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L, runtime.totalMemory() / 0x100000L);
        this.printStream.println("------------------------------------------------------------------------");
        System.exit(exit);
    }

    private void parse(String[] args) {
        for (String arg : args) {
            if (arg.startsWith(PATH_PREFIX) && arg.length() > PATH_PREFIX.length()) {
                this.repository = new File(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith(ENV_PREFIX) && arg.length() > ENV_PREFIX.length()) {
                this.environment = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith(TEMPLATE_PREFIX) && arg.length() > TEMPLATE_PREFIX.length()) {
                this.template = arg.split("=")[1];
                continue;
            }
            if (arg.startsWith(TRACE)) {
                this.trace = true;
                continue;
            }
            if (arg.startsWith(FORCE)) {
                this.force = true;
                continue;
            }
            if (arg.startsWith(HELP)) {
                this.help = true;
                continue;
            }
            if (this.command == null) {
                this.command = arg;
                continue;
            }
            if (this.params == null) {
                this.params = arg;
                continue;
            }
            this.params = this.params + " ";
            this.params = this.params + arg;
        }
    }

    private void validate() {
        if (this.repository == null) {
            this.repository = new File("./");
        }
        if (this.environment == null) {
            this.environment = "development";
        }
        if (this.repository.exists() && !this.repository.isDirectory()) {
            this.parseError = "Migrations path must be a directory: " + this.repository.getAbsolutePath();
        } else {
            this.repository = new File(this.repository.getAbsolutePath());
            if (this.command == null) {
                this.parseError = "No command specified.";
            }
        }
    }

    private void printError() {
        this.printStream.println(this.parseError);
        this.printStream.flush();
    }

    private void printUsage() {
        this.printStream.println();
        this.printStream.println("Usage: migrate command [parameter] [--path=<directory>] [--env=<environment>] [--template=<path to custom template>]");
        this.printStream.println();
        this.printStream.println("--path=<directory>   Path to repository.  Default current working directory.");
        this.printStream.println("--env=<environment>  Environment to configure. Default environment is 'development'.");
        this.printStream.println("--template=<template>  Path to custom template for creating new sql scripts.");
        this.printStream.println("--force              Forces script to continue even if SQL errors are encountered.");
        this.printStream.println("--help               Displays this usage message.");
        this.printStream.println("--trace              Shows additional error details (if any).");
        this.printStream.println();
        this.printStream.println("Commands:");
        this.printStream.println("  init               Creates (if necessary) and initializes a migration path.");
        this.printStream.println("  bootstrap          Runs the bootstrap SQL script (see scripts/bootstrap.sql for more).");
        this.printStream.println("  new <description>  Creates a new migration with the provided description.");
        this.printStream.println("  up [n]             Run unapplied migrations, ALL by default, or 'n' specified.");
        this.printStream.println("  down [n]           Undoes migrations applied to the database. ONE by default or 'n' specified.");
        this.printStream.println("  version <version>  Migrates the database up or down to the specified version.");
        this.printStream.println("  pending            Force executes pending migrations out of order (not recommended).");
        this.printStream.println("  status             Prints the changelog from the database if the changelog table exists.");
        this.printStream.println("  script <v1> <v2>   Generates a delta migration script from version v1 to v2 (undo if v1 > v2).");
        this.printStream.println("");
        this.printStream.println("  * Shortcuts are accepted by using the first few (unambiguous) letters of each command..");
        this.printStream.println();
        this.printStream.flush();
    }
}

