/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import org.basex.util.Array;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenSet;

public class TokenMap
extends TokenSet {
    private byte[][] values = new byte[8][];

    public final void add(byte[] key, byte[] val) {
        int i = this.add(key);
        this.values[Math.abs((int)i)] = val;
    }

    public final byte[] get(byte[] key) {
        return key != null ? this.values[this.id(key)] : null;
    }

    public final byte[] value(int p) {
        return this.values[p];
    }

    @Override
    protected final void rehash() {
        super.rehash();
        this.values = Array.copyOf(this.values, this.size << 1);
    }

    @Override
    public final String toString() {
        TokenBuilder tb = new TokenBuilder("TokenMap[");
        byte[][] ks = this.keys();
        int i = 0;
        while (i < ks.length) {
            tb.add(ks[i]).add(" = ").add(this.get(ks[i]));
            if (i < ks.length - 1) {
                tb.add(", ");
            }
            ++i;
        }
        return tb.add(93).toString();
    }
}

