/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import java.util.HashMap;
import java.util.Map;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.up.DatabaseUpdates;
import org.basex.query.up.primitives.UpdatePrimitive;

public abstract class ContextModifier {
    private final Map<Data, DatabaseUpdates> pendingUpdates = new HashMap<Data, DatabaseUpdates>();

    abstract void add(UpdatePrimitive var1, QueryContext var2) throws QueryException;

    protected final void add(UpdatePrimitive p) throws QueryException {
        Data data = p.data;
        DatabaseUpdates dbp = this.pendingUpdates.get(data);
        if (dbp == null) {
            dbp = new DatabaseUpdates(data);
            this.pendingUpdates.put(data, dbp);
        }
        dbp.add(p);
    }

    final void applyUpdates(QueryContext ctx) throws QueryException {
        for (DatabaseUpdates c : this.pendingUpdates.values()) {
            c.check();
        }
        for (DatabaseUpdates c : this.pendingUpdates.values()) {
            c.apply(ctx);
        }
    }

    final int size() {
        int s = 0;
        for (DatabaseUpdates c : this.pendingUpdates.values()) {
            s += c.nodes.size();
        }
        return s;
    }
}

