/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.item.ANode;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeCache;
import org.basex.query.iter.ValueIter;
import org.basex.query.path.AxisStep;
import org.basex.query.path.Path;
import org.basex.query.util.Err;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;

public final class MixedPath
extends Path {
    public MixedPath(InputInfo ii, Expr r, Expr ... s) {
        super(ii, r, s);
    }

    @Override
    protected Expr compPath(QueryContext ctx) throws QueryException {
        Path e;
        Expr[] exprArray = this.step;
        int n = this.step.length;
        int n2 = 0;
        while (n2 < n) {
            Expr s = exprArray[n2];
            this.checkUp(s, ctx);
            ++n2;
        }
        AxisStep v = this.voidStep(this.step);
        if (v != null) {
            Err.COMPSELF.thrw(this.input, v);
        }
        int s = 0;
        while (s != this.step.length) {
            this.step[s] = this.step[s].comp(ctx);
            if (this.step[s].empty()) {
                return Empty.SEQ;
            }
            ++s;
        }
        this.optSteps(ctx);
        Data data = ctx.data();
        if (data != null && ctx.value.type == NodeType.DOC && (e = this.children(ctx, data)) != this) {
            return ((Expr)e).comp(ctx);
        }
        this.size = this.size(ctx);
        this.type = SeqType.get(this.step[this.step.length - 1].type().type, this.size);
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value v = this.root != null ? this.root.value(ctx) : this.checkCtx(ctx);
        Value c = ctx.value;
        long cs = ctx.size;
        long cp = ctx.pos;
        ctx.value = v;
        Iter ir = this.eval(ctx);
        ctx.value = c;
        ctx.size = cs;
        ctx.pos = cp;
        return ir;
    }

    private Iter eval(QueryContext ctx) throws QueryException {
        ValueIter res = ctx.value.iter();
        int el = this.step.length;
        int ex = 0;
        while (ex < el) {
            Item it;
            Expr e = this.step[ex];
            boolean last = ex + 1 == el;
            ItemCache ic = new ItemCache();
            ctx.size = ((Iter)res).size();
            ctx.pos = 1L;
            boolean nodes = false;
            while ((it = ((Iter)res).next()) != null) {
                Item i;
                if (!it.node()) {
                    Err.NODESPATH.thrw(this.input, this, it.type);
                }
                ctx.value = it;
                Iter ir = ctx.iter(e);
                while ((i = ir.next()) != null) {
                    if (ic.size() == 0L) {
                        nodes = i.node();
                    } else if (last && nodes != i.node()) {
                        Err.EVALNODESVALS.thrw(this.input, new Object[0]);
                    }
                    ic.add(i);
                }
                ++ctx.pos;
            }
            if (nodes) {
                Item it2;
                NodeCache nc = new NodeCache().random();
                while ((it2 = ic.next()) != null) {
                    nc.add((ANode)it2);
                }
                res = nc.finish().cache();
            } else {
                res = ic;
            }
            ++ex;
        }
        return res;
    }

    @Override
    public int count(Var v) {
        int c = 0;
        Expr[] exprArray = this.step;
        int n = this.step.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            c += e.count(v);
            ++n2;
        }
        return c + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        Expr[] exprArray = this.step;
        int n = this.step.length;
        int n2 = 0;
        while (n2 < n) {
            Expr e = exprArray[n2];
            if (e.uses(Expr.Use.VAR)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Expr remove(Var v) {
        int e = 0;
        while (e != this.step.length) {
            this.step[e] = this.step[e].remove(v);
            ++e;
        }
        return super.remove(v);
    }
}

