/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.math.BigDecimal;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.item.Atm;
import org.basex.query.item.B64;
import org.basex.query.item.Bln;
import org.basex.query.item.DSim;
import org.basex.query.item.DTd;
import org.basex.query.item.Dat;
import org.basex.query.item.Date;
import org.basex.query.item.Dbl;
import org.basex.query.item.Dec;
import org.basex.query.item.Dtm;
import org.basex.query.item.Dur;
import org.basex.query.item.Flt;
import org.basex.query.item.Hex;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Jav;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Str;
import org.basex.query.item.Tim;
import org.basex.query.item.Type;
import org.basex.query.item.Uri;
import org.basex.query.item.YMd;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

public enum AtomType implements Type
{
    ITEM("item", null, Token.EMPTY, false, false, false, false, false),
    AAT("anyAtomicType", ITEM, QueryText.XSURI, false, false, false, false, false){

        @Override
        public Atm e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Atm(it.atom(ii));
        }

        @Override
        public Atm e(Object o, InputInfo ii) {
            return new Atm(Token.token(o.toString()));
        }
    }
    ,
    ATM("untypedAtomic", AAT, QueryText.XSURI, false, true, true, false, false){

        @Override
        public Atm e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Atm(it.atom(ii));
        }

        @Override
        public Atm e(Object o, InputInfo ii) {
            return new Atm(Token.token(o.toString()));
        }
    }
    ,
    STR("string", AAT, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Str.get(it.atom(ii));
        }

        @Override
        public Str e(Object o, InputInfo ii) {
            return Str.get(o);
        }
    }
    ,
    NST("normalizedString", STR, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(it.atom(ii), this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    TOK("token", NST, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(Token.norm(it.atom(ii)), this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    LAN("language", TOK, QueryText.XSURI, false, false, true, false, false){
        final Pattern pat = Pattern.compile("[A-Za-z]{1,8}(-[A-Za-z0-9]{1,8})*");

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.atom(ii));
            if (!this.pat.matcher(Token.string(v)).matches()) {
                this.error(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    NMT("NMTOKEN", TOK, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.atom(ii));
            if (!XMLToken.isNMToken(v)) {
                this.error(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    NAM("Name", TOK, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] v = Token.norm(it.atom(ii));
            if (!XMLToken.isName(v)) {
                this.error(it, ii);
            }
            return new Str(v, this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    NCN("NCName", NAM, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    ID("ID", NCN, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    IDR("IDREF", NCN, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    ENT("ENTITY", NCN, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Str e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return new Str(this.checkName(it, ii), this);
        }

        @Override
        public Str e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    FLT("float", AAT, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Flt e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Flt.get(this.checkNum(it, ii).flt(ii));
        }

        @Override
        public Flt e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    DBL("double", AAT, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Dbl e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Dbl.get(this.checkNum(it, ii).dbl(ii));
        }

        @Override
        public Dbl e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    DEC("decimal", AAT, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Dec e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return Dec.get(this.checkNum(it, ii).dec(ii));
        }

        @Override
        public Dec e(Object o, InputInfo ii) {
            return Dec.get(new BigDecimal(o.toString()));
        }
    }
    ,
    ITR("integer", DEC, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return Itr.get(this.checkLong(o, 0L, 0L, ii));
        }
    }
    ,
    NPI("nonPositiveInteger", ITR, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, Long.MIN_VALUE, 0L, ii), this);
        }
    }
    ,
    NIN("negativeInteger", NPI, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, Long.MIN_VALUE, -1L, ii), this);
        }
    }
    ,
    LNG("long", ITR, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.date() ? new Itr((Date)it) : this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, 0L, 0L, ii), this);
        }
    }
    ,
    INT("int", LNG, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, Integer.MIN_VALUE, Integer.MAX_VALUE, ii), this);
        }
    }
    ,
    SHR("short", INT, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, -32768L, 32767L, ii), this);
        }
    }
    ,
    BYT("byte", SHR, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, -128L, 127L, ii), this);
        }
    }
    ,
    NNI("nonNegativeInteger", ITR, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, 0L, Long.MAX_VALUE, ii), this);
        }
    }
    ,
    ULN("unsignedLong", NNI, QueryText.XSURI, true, false, false, false, false){
        final BigDecimal max = new BigDecimal(Long.MAX_VALUE).multiply(BigDecimal.valueOf(2L)).add(BigDecimal.ONE);

        @Override
        public Dec e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            BigDecimal v = this.checkNum(it, ii).dec(ii);
            if (v.signum() < 0 || v.compareTo(this.max) > 0 || it.str() && Token.contains(it.atom(ii), 46)) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            return new Dec(v, this);
        }

        @Override
        public Dec e(Object o, InputInfo ii) {
            return new Dec(Token.token(o.toString()));
        }
    }
    ,
    UIN("unsignedInt", ULN, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, 0L, 0xFFFFFFFFL, ii), this);
        }
    }
    ,
    USH("unsignedShort", UIN, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, 0L, 65535L, ii), this);
        }
    }
    ,
    UBY("unsignedByte", USH, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, 0L, 255L, ii), this);
        }
    }
    ,
    PIN("positiveInteger", NNI, QueryText.XSURI, true, false, false, false, false){

        @Override
        public Itr e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return this.e(it, ii);
        }

        @Override
        public Itr e(Object o, InputInfo ii) throws QueryException {
            return new Itr(this.checkLong(o, 1L, Long.MAX_VALUE, ii), this);
        }
    }
    ,
    DUR("duration", AAT, QueryText.XSURI, false, false, false, true, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.dur() ? new Dur((Dur)it) : (29.str(it) ? new Dur(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    YMD("yearMonthDuration", DUR, QueryText.XSURI, false, false, false, true, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.dur() ? new YMd((Dur)it) : (30.str(it) ? new YMd(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    DTD("dayTimeDuration", DUR, QueryText.XSURI, false, false, false, true, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.dur() ? new DTd((Dur)it) : (31.str(it) ? new DTd(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    DTM("dateTime", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == LNG ? new Dtm((Itr)it, ii) : (it.type == DAT ? new Dtm((Date)it) : (32.str(it) ? new Dtm(it.atom(ii), ii) : this.error(it, ii)));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    DAT("date", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM ? new Dat((Date)it) : (33.str(it) ? new Dat(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    TIM("time", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM ? new Tim((Date)it) : (34.str(it) ? new Tim(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    YMO("gYearMonth", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new DSim((Date)it, this) : (35.str(it) ? new DSim(it.atom(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    YEA("gYear", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new DSim((Date)it, this) : (36.str(it) ? new DSim(it.atom(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    MDA("gMonthDay", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new DSim((Date)it, this) : (37.str(it) ? new DSim(it.atom(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    DAY("gDay", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new DSim((Date)it, this) : (38.str(it) ? new DSim(it.atom(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    MON("gMonth", AAT, QueryText.XSURI, false, false, false, false, true){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == DTM || it.type == DAT ? new DSim((Date)it, this) : (39.str(it) ? new DSim(it.atom(ii), this, ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return this.e(Str.get(o), null, ii);
        }
    }
    ,
    BLN("boolean", AAT, QueryText.XSURI, false, false, false, false, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.num() ? Bln.get(it.bool(ii)) : (40.str(it) ? Bln.get(Bln.parse(it.atom(ii), ii)) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) {
            return Bln.get((Boolean)o);
        }
    }
    ,
    B64("base64Binary", AAT, QueryText.XSURI, false, false, false, false, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == HEX ? new B64((Hex)it) : (41.str(it) ? new B64(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return new B64((byte[])o, ii);
        }
    }
    ,
    HEX("hexBinary", AAT, QueryText.XSURI, false, false, false, false, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            return it.type == B64 ? new Hex((B64)it) : (42.str(it) ? new Hex(it.atom(ii), ii) : this.error(it, ii));
        }

        @Override
        public Item e(Object o, InputInfo ii) throws QueryException {
            return new Hex((byte[])o, ii);
        }
    }
    ,
    URI("anyURI", AAT, QueryText.XSURI, false, false, true, false, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            Uri u;
            if (!it.str()) {
                this.error(it, ii);
            }
            if (!(u = Uri.uri(it.atom(ii))).valid()) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            return u;
        }

        @Override
        public Item e(Object o, InputInfo ii) {
            return Uri.uri(Token.token(o.toString()));
        }
    }
    ,
    QNM("QName", AAT, QueryText.XSURI, false, false, false, false, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
            byte[] s;
            if (it.type != STR) {
                this.error(it, ii);
            }
            if ((s = Token.trim(it.atom(ii))).length == 0) {
                Err.QNMINV.thrw(ii, new Object[]{s});
            }
            try {
                return new QNm(s, ctx, ii);
            }
            catch (QueryException ex) {
                Err.NSDECL.thrw(ii, new Object[]{s});
                return null;
            }
        }

        @Override
        public Item e(Object o, InputInfo ii) {
            return new QNm((QName)o);
        }
    }
    ,
    NOT("NOTATION", null, QueryText.XSURI, false, false, false, false, false),
    EMP("empty-sequence", null, Token.EMPTY, false, false, false, false, false),
    SEQ("sequence", null, Token.EMPTY, false, false, false, false, false),
    JAVA("java", null, Token.EMPTY, true, true, true, false, false){

        @Override
        public Item e(Item it, QueryContext ctx, InputInfo ii) {
            return new Jav(it);
        }

        @Override
        public Item e(Object o, InputInfo ii) {
            return new Jav(o);
        }
    };

    public final byte[] nam;
    private final byte[] uri;
    public final boolean num;
    public final Type par;
    public final boolean unt;
    public final boolean str;
    public final boolean dur;
    public final boolean dat;
    private SeqType seq;

    @Override
    public boolean dat() {
        return this.dat;
    }

    @Override
    public boolean dur() {
        return this.dur;
    }

    @Override
    public boolean num() {
        return this.num;
    }

    @Override
    public boolean str() {
        return this.str;
    }

    @Override
    public boolean unt() {
        return this.unt;
    }

    @Override
    public final boolean func() {
        return false;
    }

    @Override
    public byte[] nam() {
        return this.nam;
    }

    @Override
    public final boolean map() {
        return false;
    }

    @Override
    public Item e(Item it, QueryContext ctx, InputInfo ii) throws QueryException {
        return it.type != this ? this.error(it, ii) : it;
    }

    @Override
    public Item e(Object o, InputInfo ii) throws QueryException {
        Util.notexpected(o);
        return null;
    }

    private AtomType(String nm, Type pr, byte[] ur, boolean n2, boolean u, boolean s, boolean d, boolean t) {
        this.nam = Token.token(nm);
        this.par = pr;
        this.uri = ur;
        this.num = n2;
        this.unt = u;
        this.str = s;
        this.dur = d;
        this.dat = t;
    }

    @Override
    public SeqType seq() {
        if (this.seq == null) {
            this.seq = new SeqType(this);
        }
        return this.seq;
    }

    Item checkNum(Item it, InputInfo ii) throws QueryException {
        return it.type == URI || !it.str() && !it.num() && !it.unt() && it.type != BLN ? this.error(it, ii) : it;
    }

    long checkLong(Object o, long min, long max, InputInfo ii) throws QueryException {
        double d;
        Item it = o instanceof Item ? (Item)o : Str.get(o.toString());
        this.checkNum(it, ii);
        if (it.type == DBL || it.type == FLT) {
            double d2 = it.dbl(ii);
            if (Double.isNaN(d2) || d2 == Double.POSITIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY) {
                Err.value(ii, this, it);
            }
            if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                Err.INTRANGE.thrw(ii, d2);
            }
            if (min != max && (d2 < (double)min || d2 > (double)max)) {
                Err.FUNCAST.thrw(ii, this, it);
            }
            return (long)d2;
        }
        long l = it.itr(ii);
        if (min == max && ((d = it.dbl(ii)) < -9.223372036854776E18 || d > 9.223372036854776E18)) {
            Err.FUNCAST.thrw(ii, this, it);
        }
        if (min != max && (l < min || l > max)) {
            Err.FUNCAST.thrw(ii, this, it);
        }
        return l;
    }

    static boolean str(Item it) {
        return (it.str() || it.unt()) && it.type != URI;
    }

    byte[] checkName(Item it, InputInfo ii) throws QueryException {
        byte[] v = Token.norm(it.atom(ii));
        if (!XMLToken.isNCName(v)) {
            this.error(it, ii);
        }
        return v;
    }

    Item error(Item it, InputInfo ii) throws QueryException {
        Err.cast(ii, this, it);
        return null;
    }

    @Override
    public final boolean instance(Type t) {
        return this == t || this.par != null && this.par.instance(t);
    }

    @Override
    public final boolean node() {
        return false;
    }

    public static AtomType find(QNm type, boolean atom) {
        if (atom ^ type.uri() == Uri.EMPTY) {
            byte[] ln = type.ln();
            byte[] uri = type.uri().atom();
            AtomType[] atomTypeArray = AtomType.values();
            int n = atomTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AtomType t = atomTypeArray[n2];
                if (t != SEQ && t != JAVA && Token.eq(ln, t.nam) && Token.eq(uri, t.uri)) {
                    return t;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder();
        if (this.uri == QueryText.XSURI) {
            tb.add(QueryText.XS);
            tb.add(58);
        }
        tb.add(this.nam);
        if (this.uri != QueryText.XSURI) {
            tb.add("()");
        }
        return tb.toString();
    }

    /* synthetic */ AtomType(String string, int n, String string2, Type type, byte[] byArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, AtomType atomType) {
        this(string2, type, byArray, bl, bl2, bl3, bl4, bl5);
    }
}

