/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXNode;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.NodeCache;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class ANode
extends Item {
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOC, NodeType.ELM, NodeType.TXT, NodeType.ATT, NodeType.COM, NodeType.PI};
    private static int sid;
    public final int id = ++sid;
    protected byte[] val;
    protected ANode par;

    protected ANode(NodeType t) {
        super(t);
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return true;
    }

    @Override
    public byte[] atom(InputInfo ii) {
        return this.val;
    }

    public final byte[] atom() {
        return this.atom(null);
    }

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        return !it.unt() ? it.eq(ii, this) : Token.eq(this.atom(), it.atom(ii));
    }

    @Override
    public final int diff(InputInfo ii, Item it) throws QueryException {
        return !it.unt() ? -it.diff(ii, this) : Token.diff(this.atom(), it.atom(ii));
    }

    public abstract ANode copy();

    public byte[] nname() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public QNm qname(QNm nm) {
        return this.qname();
    }

    public Atts ns() {
        return null;
    }

    public final Atts nsScope() {
        return this.nsScope(true);
    }

    public final Atts nsScope(boolean nsInherit) {
        Atts ns = new Atts();
        ANode n = this;
        do {
            Atts nns = n.ns();
            if (!nsInherit) {
                return nns;
            }
            if (nns == null) continue;
            int a = nns.size - 1;
            while (a >= 0) {
                byte[] key = nns.key[a];
                if (!ns.contains(key)) {
                    ns.add(key, nns.val[a]);
                }
                --a;
            }
        } while ((n = n.parent()) != null && n.type == NodeType.ELM);
        return ns;
    }

    public final byte[] uri(byte[] pref, QueryContext ctx) {
        Atts at = this.ns();
        if (at != null) {
            int i = at.get(pref);
            if (i != -1) {
                return at.val[i];
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(pref, ctx);
            }
        }
        return (byte[])(pref.length == 0 ? Token.EMPTY : null);
    }

    public byte[] base() {
        return Token.EMPTY;
    }

    public abstract boolean is(ANode var1);

    public abstract int diff(ANode var1);

    public ANode finish() {
        return this;
    }

    public abstract ANode parent();

    public void parent(ANode p) {
        this.par = p;
    }

    public byte[] attribute(QNm name) {
        ANode node;
        AxisIter ai = this.attributes();
        do {
            if ((node = ai.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.atom();
    }

    public abstract AxisIter anc();

    public abstract AxisIter ancOrSelf();

    public abstract AxisIter attributes();

    public abstract AxisMoreIter children();

    public abstract AxisIter descendant();

    public abstract AxisIter descOrSelf();

    public abstract AxisIter foll();

    public abstract AxisIter follSibl();

    public abstract AxisIter par();

    public final AxisIter prec() {
        return new AxisIter(){
            private NodeCache nc;

            @Override
            public ANode next() {
                if (this.nc == null) {
                    this.nc = new NodeCache();
                    ANode n = ANode.this;
                    ANode p = n.parent();
                    while (p != null) {
                        if (n.type != NodeType.ATT) {
                            ANode c;
                            NodeCache tmp = new NodeCache();
                            AxisMoreIter ai = p.children();
                            while ((c = ai.next()) != null && !c.is(n)) {
                                tmp.add(c.finish());
                                ANode.this.addDesc(c.children(), tmp);
                            }
                            long t = tmp.size() - 1L;
                            while (t >= 0L) {
                                this.nc.add(tmp.get(t));
                                --t;
                            }
                        }
                        n = p;
                        p = p.parent();
                    }
                }
                return this.nc.next();
            }
        };
    }

    public final AxisIter precSibl() {
        return new AxisIter(){
            private NodeCache nc;
            private long c;

            @Override
            public ANode next() {
                if (this.nc == null) {
                    ANode n;
                    ANode r = ANode.this.parent();
                    if (r == null) {
                        return null;
                    }
                    this.nc = new NodeCache();
                    AxisMoreIter ai = r.children();
                    while ((n = ai.next()) != null && !n.is(ANode.this)) {
                        this.nc.add(n.finish());
                    }
                    this.c = this.nc.size();
                }
                return this.c > 0L ? this.nc.get(--this.c) : null;
            }
        };
    }

    public final AxisMoreIter self() {
        return new AxisMoreIter(){
            private boolean more = true;

            @Override
            public boolean more() {
                return this.more;
            }

            @Override
            public ANode next() {
                return (this.more ^= true) ? null : ANode.this;
            }
        };
    }

    protected final void addDesc(AxisMoreIter ch, NodeCache nc) {
        ANode n;
        while ((n = ch.next()) != null) {
            nc.add(n.finish());
            this.addDesc(n.children(), nc);
        }
    }

    public static int kind(NodeType t) {
        switch (t) {
            case DOC: {
                return 0;
            }
            case ELM: {
                return 1;
            }
            case TXT: {
                return 2;
            }
            case ATT: {
                return 3;
            }
            case COM: {
                return 4;
            }
            case PI: {
                return 5;
            }
        }
        throw Util.notexpected(new Object[0]);
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public final BXNode toJava() {
        switch (this.ndType()) {
            case DOC: {
                return new BXDoc(this);
            }
            case ELM: {
                return new BXElem(this);
            }
            case TXT: {
                return new BXText(this);
            }
            case ATT: {
                return new BXAttr(this);
            }
            case COM: {
                return new BXComm(this);
            }
            case PI: {
                return new BXPI(this);
            }
        }
        return null;
    }

    public final NodeType ndType() {
        return (NodeType)this.type;
    }
}

