/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.Empty;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Seq;
import org.basex.query.item.SeqType;
import org.basex.query.item.Type;
import org.basex.query.item.Value;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.NodeCache;
import org.basex.query.iter.ValueIter;
import org.basex.query.util.ItemSet;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public final class FNSeq
extends FuncCall {
    public FNSeq(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case HEAD: {
                return this.head(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case INDEXOF: {
                return this.indexOf(ctx);
            }
            case DISTINCT: {
                return this.distinctValues(ctx);
            }
            case INSBEF: {
                return this.insertBefore(ctx);
            }
            case REVERSE: {
                return this.reverse(ctx);
            }
            case REMOVE: {
                return this.remove(ctx);
            }
            case SUBSEQ: {
                return this.subsequence(ctx);
            }
            case TAIL: {
                return this.tail(ctx);
            }
            case OUTERMOST: {
                return this.most(ctx, true);
            }
            case INNERMOST: {
                return this.most(ctx, false);
            }
        }
        return super.iter(ctx);
    }

    private Iter most(QueryContext ctx, boolean outer) throws QueryException {
        Item it;
        Iter iter = this.expr[0].iter(ctx);
        NodeCache nc = new NodeCache().random();
        while ((it = iter.next()) != null) {
            nc.add(this.checkNode(it));
        }
        int len = (int)nc.size();
        if (len < 2) {
            return nc;
        }
        if (nc.dbnodes()) {
            DBNode fst = (DBNode)nc.get(outer ? 0 : len - 1);
            Data data = fst.data;
            ANode[] nodes = (ANode[])nc.item.clone();
            if (outer) {
                nc.size(0);
                DBNode dummy = new DBNode(fst.data, 0);
                NodeCache src = new NodeCache(nodes, len);
                int next = 0;
                while (next < len) {
                    DBNode nd = (DBNode)nodes[next];
                    dummy.pre = nd.pre + data.size(nd.pre, data.kind(nd.pre));
                    int p = src.binarySearch(dummy, next + 1, len - next - 1);
                    nc.add(nd);
                    int n = next = p < 0 ? -p - 1 : p;
                }
            } else {
                nc.item[0] = fst;
                nc.size(1);
                int before = fst.pre;
                int i = len - 1;
                while (i-- != 0) {
                    DBNode nd = (DBNode)nodes[i];
                    if (nd.pre + data.size(nd.pre, data.kind(nd.pre)) > before) continue;
                    nc.add(nd);
                    before = nd.pre;
                }
                Array.reverse(nc.item, 0, (int)nc.size());
            }
            return nc;
        }
        NodeCache out = new NodeCache(new ANode[len], 0);
        int i = 0;
        while (i < len) {
            block10: {
                ANode a;
                ANode nd = nc.item[i];
                AxisIter ax = outer ? nd.anc() : nd.descendant();
                while ((a = ax.next()) != null) {
                    if (nc.indexOf(a, false) == -1) {
                        continue;
                    }
                    break block10;
                }
                out.add(nc.item[i]);
            }
            ++i;
        }
        return out;
    }

    @Override
    public Expr cmp(QueryContext ctx) {
        if (this.def == Function.INDEXOF || this.def == Function.INSBEF) {
            return this;
        }
        Type t = this.expr[0].type().type;
        SeqType.Occ o = SeqType.Occ.ZM;
        if (this.def == Function.HEAD) {
            o = SeqType.Occ.ZO;
        }
        if (this.def == Function.SUBSEQ && this.expr[0].type().one()) {
            o = SeqType.Occ.ZO;
        }
        this.type = SeqType.get(t, o);
        return this;
    }

    private Item head(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        return e.type().zeroOrOne() ? e.item(ctx, this.input) : e.iter(ctx).next();
    }

    private Iter tail(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        if (e.type().zeroOrOne()) {
            return Empty.ITER;
        }
        final Iter ir = e.iter(ctx);
        if (ir.next() == null) {
            return Empty.ITER;
        }
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                return ir.next();
            }
        };
    }

    private Iter indexOf(QueryContext ctx) throws QueryException {
        final Item it = this.checkItem(this.expr[1], ctx);
        if (this.expr.length == 3) {
            this.checkColl(this.expr[2], ctx);
        }
        return new Iter(ctx){
            final Iter ir;
            int c;
            {
                this.ir = FNSeq.this.expr[0].iter(queryContext);
            }

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = this.ir.next()) == null) {
                        return null;
                    }
                    ++this.c;
                } while (!i.comparable(it) || !CmpV.Op.EQ.e(FNSeq.this.input, i, it));
                return Itr.get(this.c);
            }
        };
    }

    private Iter distinctValues(final QueryContext ctx) throws QueryException {
        if (this.expr.length == 2) {
            this.checkColl(this.expr[1], ctx);
        }
        return new Iter(){
            final ItemSet map = new ItemSet();
            final Iter ir;
            {
                this.ir = FNSeq.this.expr[0].iter(queryContext);
            }

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = this.ir.next()) == null) {
                        return null;
                    }
                    ctx.checkStop();
                } while (!this.map.index(FNSeq.this.input, i = FNSeq.this.atom(i)));
                return i;
            }
        };
    }

    private Iter insertBefore(QueryContext ctx) throws QueryException {
        return new Iter(ctx){
            final long pos;
            final Iter iter;
            final Iter ins;
            long p;
            boolean last;
            {
                this.pos = Math.max(1L, FNSeq.this.checkItr(FNSeq.this.expr[1], queryContext));
                this.iter = FNSeq.this.expr[0].iter(queryContext);
                this.ins = FNSeq.this.expr[2].iter(queryContext);
                this.p = this.pos;
            }

            @Override
            public Item next() throws QueryException {
                if (this.last) {
                    return this.p > 0L ? this.ins.next() : null;
                }
                boolean sub = this.p == 0L || --this.p == 0L;
                Item i = (sub ? this.ins : this.iter).next();
                if (i != null) {
                    return i;
                }
                if (sub) {
                    --this.p;
                } else {
                    this.last = true;
                }
                return this.next();
            }
        };
    }

    private Iter remove(QueryContext ctx) throws QueryException {
        return new Iter(ctx){
            final long pos;
            final Iter iter;
            long c;
            {
                this.pos = FNSeq.this.checkItr(FNSeq.this.expr[1], queryContext);
                this.iter = FNSeq.this.expr[0].iter(queryContext);
            }

            @Override
            public Item next() throws QueryException {
                return ++this.c != this.pos || this.iter.next() != null ? this.iter.next() : null;
            }
        };
    }

    private Iter subsequence(QueryContext ctx) throws QueryException {
        double ds = this.checkDbl(this.expr[1], ctx);
        if (Double.isNaN(ds)) {
            return Empty.ITER;
        }
        final long s = StrictMath.round(ds);
        long l = Long.MAX_VALUE;
        if (this.expr.length > 2) {
            double dl = this.checkDbl(this.expr[2], ctx);
            if (Double.isNaN(dl)) {
                return Empty.ITER;
            }
            l = s + StrictMath.round(dl);
        }
        final long e = l;
        final Iter iter = ctx.iter(this.expr[0]);
        long max = iter.size();
        return max != -1L ? new Iter(e, max){
            long c;
            long m;
            {
                this.c = Math.max(1L, l);
                this.m = Math.min(l2, l3 + 1L);
            }

            @Override
            public Item next() throws QueryException {
                return this.c < this.m ? iter.get(this.c++ - 1L) : null;
            }

            @Override
            public Item get(long i) throws QueryException {
                return iter.get(this.c + i - 1L);
            }

            @Override
            public long size() {
                return Math.max(0L, this.m - this.c);
            }

            @Override
            public boolean reset() {
                this.c = Math.max(1L, s);
                return true;
            }
        } : new Iter(){
            long c;

            @Override
            public Item next() throws QueryException {
                Item i;
                do {
                    if ((i = iter.next()) != null && ++this.c < e) continue;
                    return null;
                } while (this.c < s);
                return i;
            }
        };
    }

    private ValueIter reverse(QueryContext ctx) throws QueryException {
        final Value val = ctx.value(this.expr[0]);
        final ValueIter iter = val.iter();
        return val.size() == 1L ? iter : new ValueIter(){
            final long s;
            long c;
            {
                this.c = this.s = valueIter.size();
            }

            @Override
            public Item next() {
                return --this.c >= 0L ? iter.get(this.c) : null;
            }

            @Override
            public Item get(long i) {
                return iter.get(this.s - i - 1L);
            }

            @Override
            public long size() {
                return this.s;
            }

            @Override
            public boolean reset() {
                this.c = this.s;
                return true;
            }

            @Override
            public Value finish() {
                Object[] arr = new Item[(int)val.size()];
                int written = val.writeTo((Item[])arr, 0);
                Array.reverse(arr, 0, written);
                return Seq.get((Item[])arr, written);
            }
        };
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 && (this.def == Function.HEAD || this.def == Function.TAIL) || super.uses(u);
    }
}

