/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.util.InputInfo;

public final class FNMath
extends FuncCall {
    public FNMath(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        double d = 0.0;
        if (this.expr.length > 0) {
            if (this.expr[0].empty()) {
                return null;
            }
            d = this.checkDbl(this.expr[0], ctx);
        }
        double e = this.expr.length > 1 ? this.checkDbl(this.expr[1], ctx) : 0.0;
        switch (this.def) {
            case PI: {
                return Dbl.get(Math.PI);
            }
            case E: {
                return Dbl.get(Math.E);
            }
            case SQRT: {
                return Dbl.get(StrictMath.sqrt(d));
            }
            case SIN: {
                return Dbl.get(StrictMath.sin(d));
            }
            case COS: {
                return Dbl.get(StrictMath.cos(d));
            }
            case TAN: {
                return Dbl.get(StrictMath.tan(d));
            }
            case ASIN: {
                return Dbl.get(StrictMath.asin(d));
            }
            case ACOS: {
                return Dbl.get(StrictMath.acos(d));
            }
            case ATAN: {
                return Dbl.get(StrictMath.atan(d));
            }
            case EXP: {
                return Dbl.get(StrictMath.exp(d));
            }
            case EXP10: {
                return Dbl.get(StrictMath.pow(10.0, d));
            }
            case LOG: {
                return Dbl.get(StrictMath.log(d));
            }
            case LOG10: {
                return Dbl.get(StrictMath.log10(d));
            }
            case ATAN2: {
                return Dbl.get(StrictMath.atan2(d, e));
            }
            case POW: {
                return Dbl.get(d == 1.0 ? 1.0 : StrictMath.pow(d, e));
            }
            case RANDOM: {
                return Dbl.get(StrictMath.random());
            }
            case SINH: {
                return Dbl.get(StrictMath.sinh(d));
            }
            case COSH: {
                return Dbl.get(StrictMath.cosh(d));
            }
            case TANH: {
                return Dbl.get(StrictMath.tanh(d));
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.X30 || u == Expr.Use.CTX && this.def == Function.RANDOM || super.uses(u);
    }
}

